/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeKeyIdIdentification represents an IKE entity identification based on a Key ID.
 *
 * <p>Key ID is an octet stream that may be used to pass vendor-specific information necessary to do
 * certain proprietary types of identification.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeKeyIdIdentification extends android.net.ipsec.ike.IkeIdentification {

/**
 * Construct an instance of {@link android.net.ipsec.ike.IkeKeyIdIdentification IkeKeyIdIdentification} with a Key ID.
 *
 * @param keyId the Key ID in bytes.

 * This value cannot be {@code null}.
 */

public IkeKeyIdIdentification(@android.annotation.NonNull byte[] keyId) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** The KEY ID in octet stream. */

@android.annotation.NonNull public final byte[] keyId;
{ keyId = new byte[0]; }
}

