/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * TransportModeChildSessionParams represents proposed configurations for negotiating a transport
 * mode Child Session.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class TransportModeChildSessionParams extends android.net.ipsec.ike.ChildSessionParams {

private TransportModeChildSessionParams() { throw new RuntimeException("Stub!"); }
/**
 * This class can be used to incrementally construct a {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Create a Builder for negotiating a transport mode Child Session. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Construct Builder from the {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams} object.
 *
 * @param childParams the object this Builder will be constructed with.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.ipsec.ike.TransportModeChildSessionParams childParams) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Child SA proposal to the {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams} being built.
 *
 * @param proposal Child SA proposal.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TransportModeChildSessionParams.Builder addChildSaProposal(@android.annotation.NonNull android.net.ipsec.ike.ChildSaProposal proposal) { throw new RuntimeException("Stub!"); }

/**
 * Adds an inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} to the {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams}
 * being built.
 *
 * <p>This method allows callers to limit the inbound traffic transmitted over the Child
 * Session to the given range. The IKE server may further narrow the range. Callers should
 * refer to {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} for the negotiated traffic selectors.
 *
 * <p>If no inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} is provided, a default value will be used
 * that covers all IP addresses and ports.
 *
 * @param trafficSelector the inbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TransportModeChildSessionParams.Builder addInboundTrafficSelectors(@android.annotation.NonNull android.net.ipsec.ike.IkeTrafficSelector trafficSelector) { throw new RuntimeException("Stub!"); }

/**
 * Adds an outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} to the {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams} being built.
 *
 * <p>This method allows callers to limit the outbound traffic transmitted over the Child
 * Session to the given range. The IKE server may further narrow the range. Callers should
 * refer to {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration} for the negotiated traffic selectors.
 *
 * <p>If no outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} is provided, a default value will be used
 * that covers all IP addresses and ports.
 *
 * @param trafficSelector the outbound {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}.
 * This value cannot be {@code null}.
 * @return Builder this, to facilitate chaining.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TransportModeChildSessionParams.Builder addOutboundTrafficSelectors(@android.annotation.NonNull android.net.ipsec.ike.IkeTrafficSelector trafficSelector) { throw new RuntimeException("Stub!"); }

/**
 * Sets hard and soft lifetimes.
 *
 * <p>Lifetimes will not be negotiated with the remote IKE server.
 *
 * @param hardLifetimeSeconds number of seconds after which Child SA will expire. Defaults
 *     to 7200 seconds (2 hours). Considering IPsec packet lifetime, IKE library requires
 *     hard lifetime to be a value from 300 seconds (5 minutes) to 14400 seconds (4 hours),
 *     inclusive.
 * Value is between CHILD_HARD_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 * @param softLifetimeSeconds number of seconds after which Child SA will request rekey.
 *     Defaults to 3600 seconds (1 hour). MUST be at least 120 seconds (2 minutes), and at
 *     least 60 seconds (1 minute) shorter than the hard lifetime.
 
 * Value is between CHILD_SOFT_LIFETIME_SEC_MINIMUM and CHILD_HARD_LIFETIME_SEC_MAXIMUM inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TransportModeChildSessionParams.Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) { throw new RuntimeException("Stub!"); }

/**
 * Validates and builds the {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams}.
 *
 * @return the validated {@link android.net.ipsec.ike.TransportModeChildSessionParams TransportModeChildSessionParams}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.ipsec.ike.TransportModeChildSessionParams build() { throw new RuntimeException("Stub!"); }
}

}

