/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.telephony;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SignalThresholdInfo implements android.os.Parcelable {

private SignalThresholdInfo() { throw new RuntimeException("Stub!"); }

public int getRadioAccessNetworkType() { throw new RuntimeException("Stub!"); }

public int getSignalMeasurementType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getThresholds() { throw new RuntimeException("Stub!"); }

public static int getMinimumNumberOfThresholdsAllowed() { throw new RuntimeException("Stub!"); }

public static int getMaximumNumberOfThresholdsAllowed() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.telephony.SignalThresholdInfo> CREATOR;
static { CREATOR = null; }

public static final int SIGNAL_MEASUREMENT_TYPE_RSCP = 2; // 0x2

public static final int SIGNAL_MEASUREMENT_TYPE_RSRP = 3; // 0x3

public static final int SIGNAL_MEASUREMENT_TYPE_RSRQ = 4; // 0x4

public static final int SIGNAL_MEASUREMENT_TYPE_RSSI = 1; // 0x1

public static final int SIGNAL_MEASUREMENT_TYPE_RSSNR = 5; // 0x5

public static final int SIGNAL_MEASUREMENT_TYPE_SSRSRP = 6; // 0x6

public static final int SIGNAL_MEASUREMENT_TYPE_SSRSRQ = 7; // 0x7

public static final int SIGNAL_MEASUREMENT_TYPE_SSSINR = 8; // 0x8

public static final int SIGNAL_MEASUREMENT_TYPE_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.telephony.SignalThresholdInfo.Builder setRadioAccessNetworkType(int ran) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.telephony.SignalThresholdInfo.Builder setSignalMeasurementType(int signalMeasurementType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.telephony.SignalThresholdInfo.Builder setThresholds(@android.annotation.NonNull int[] thresholds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.telephony.SignalThresholdInfo build() { throw new RuntimeException("Stub!"); }
}

}

