/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view.displayhash;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface DisplayHashResultCallback {

public void onDisplayHashResult(@android.annotation.NonNull android.view.displayhash.DisplayHash displayHash);

public void onDisplayHashError(int errorCode);

public static final int DISPLAY_HASH_ERROR_INVALID_BOUNDS = -2; // 0xfffffffe

public static final int DISPLAY_HASH_ERROR_INVALID_HASH_ALGORITHM = -5; // 0xfffffffb

public static final int DISPLAY_HASH_ERROR_MISSING_WINDOW = -3; // 0xfffffffd

public static final int DISPLAY_HASH_ERROR_NOT_VISIBLE_ON_SCREEN = -4; // 0xfffffffc

public static final int DISPLAY_HASH_ERROR_TOO_MANY_REQUESTS = -6; // 0xfffffffa

public static final int DISPLAY_HASH_ERROR_UNKNOWN = -1; // 0xffffffff
}

