/*
 * Copyright (c) 2005, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util;


/**
 * Error thrown when something goes wrong while locating, loading, or
 * instantiating a service provider.
 *
 * @author Mark Reinhold
 * @since 1.6
 * @see java.util.ServiceLoader
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ServiceConfigurationError extends java.lang.Error {

/**
 * Constructs a new instance with the specified message.
 *
 * @param  msg  The message, or {@code null} if there is no message
 *
 */

public ServiceConfigurationError(java.lang.String msg) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new instance with the specified message and cause.
 *
 * @param  msg  The message, or {@code null} if there is no message
 *
 * @param  cause  The cause, or {@code null} if the cause is nonexistent
 *                or unknown
 */

public ServiceConfigurationError(java.lang.String msg, java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }
}

