/*
 * Copyright (c) 2003-2010 Rony Shapiro <ronys@users.sourceforge.net>.
 * All rights reserved. Use of the code is allowed under the
 * Artistic License 2.0 terms, as specified in the LICENSE file
 * distributed with this code, or available from
 * http://www.opensource.org/licenses/artistic-license-2.0.php
 */

/** \file safecombinationsetup.cpp
* 
*/
// Generated by DialogBlocks, Wed 21 Jan 2009 09:07:57 PM IST

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "safecombinationsetup.h"
#include "corelib/PWCharPool.h" // for CheckPassword()

////@begin XPM images
////@end XPM images


/*!
 * CSafeCombinationSetup type definition
 */

IMPLEMENT_DYNAMIC_CLASS( CSafeCombinationSetup, wxDialog )


/*!
 * CSafeCombinationSetup event table definition
 */

BEGIN_EVENT_TABLE( CSafeCombinationSetup, wxDialog )

////@begin CSafeCombinationSetup event table entries
  EVT_BUTTON( wxID_OK, CSafeCombinationSetup::OnOkClick )

  EVT_BUTTON( wxID_CANCEL, CSafeCombinationSetup::OnCancelClick )

////@end CSafeCombinationSetup event table entries

END_EVENT_TABLE()


/*!
 * CSafeCombinationSetup constructors
 */

CSafeCombinationSetup::CSafeCombinationSetup()
{
  Init();
}

CSafeCombinationSetup::CSafeCombinationSetup( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
  Init();
  Create(parent, id, caption, pos, size, style);
}


/*!
 * CSafeCombinationSetup creator
 */

bool CSafeCombinationSetup::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin CSafeCombinationSetup creation
  SetExtraStyle(wxWS_EX_BLOCK_EVENTS);
  wxDialog::Create( parent, id, caption, pos, size, style );

  CreateControls();
  if (GetSizer())
  {
    GetSizer()->SetSizeHints(this);
  }
  Centre();
////@end CSafeCombinationSetup creation
  return true;
}


/*!
 * CSafeCombinationSetup destructor
 */

CSafeCombinationSetup::~CSafeCombinationSetup()
{
////@begin CSafeCombinationSetup destruction
////@end CSafeCombinationSetup destruction
}


/*!
 * Member initialisation
 */

void CSafeCombinationSetup::Init()
{
////@begin CSafeCombinationSetup member initialisation
////@end CSafeCombinationSetup member initialisation
}


/*!
 * Control creation for CSafeCombinationSetup
 */

void CSafeCombinationSetup::CreateControls()
{    
////@begin CSafeCombinationSetup content construction
  // Generated by DialogBlocks, Wed 21 Jan 2009 09:40:36 PM IST

  CSafeCombinationSetup* itemDialog1 = this;

  wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxVERTICAL);
  itemDialog1->SetSizer(itemBoxSizer2);

  wxStaticText* itemStaticText3 = new wxStaticText( itemDialog1, wxID_STATIC, _("A new password database will be created.\nThe safe combination you enter will be used to encrypt the password database file.\nThe Safe Combination can use any keyboard character and is case-sensitive."), wxDefaultPosition, wxDefaultSize, 0 );
  itemBoxSizer2->Add(itemStaticText3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

  wxBoxSizer* itemBoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer2->Add(itemBoxSizer4, 0, wxGROW|wxALL, 5);

  itemBoxSizer4->Add(50, 10, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxStaticText* itemStaticText6 = new wxStaticText( itemDialog1, wxID_STATIC, _("Safe Combination:"), wxDefaultPosition, wxDefaultSize, 0 );
  itemBoxSizer4->Add(itemStaticText6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxTextCtrl* itemTextCtrl7 = new wxTextCtrl( itemDialog1, ID_PASSKEY, _T(""), wxDefaultPosition, wxSize(itemDialog1->ConvertDialogToPixels(wxSize(120, -1)).x, -1), wxTE_PASSWORD );
  itemBoxSizer4->Add(itemTextCtrl7, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxBoxSizer* itemBoxSizer8 = new wxBoxSizer(wxHORIZONTAL);
  itemBoxSizer2->Add(itemBoxSizer8, 0, wxGROW|wxALL, 5);

  itemBoxSizer8->Add(130, 10, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxStaticText* itemStaticText10 = new wxStaticText( itemDialog1, wxID_STATIC, _("Verify:"), wxDefaultPosition, wxDefaultSize, 0 );
  itemBoxSizer8->Add(itemStaticText10, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxTextCtrl* itemTextCtrl11 = new wxTextCtrl( itemDialog1, ID_VERIFY, _T(""), wxDefaultPosition, wxSize(itemDialog1->ConvertDialogToPixels(wxSize(120, -1)).x, -1), wxTE_PASSWORD );
  itemBoxSizer8->Add(itemTextCtrl11, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

  wxStdDialogButtonSizer* itemStdDialogButtonSizer12 = new wxStdDialogButtonSizer;

  itemBoxSizer2->Add(itemStdDialogButtonSizer12, 0, wxGROW|wxALL, 5);
  wxButton* itemButton13 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
  itemStdDialogButtonSizer12->AddButton(itemButton13);

  wxButton* itemButton14 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
  itemStdDialogButtonSizer12->AddButton(itemButton14);

  wxButton* itemButton15 = new wxButton( itemDialog1, wxID_HELP, _("&Help"), wxDefaultPosition, wxDefaultSize, 0 );
  itemStdDialogButtonSizer12->AddButton(itemButton15);

  itemStdDialogButtonSizer12->Realize();

  // Set validators
  itemTextCtrl7->SetValidator( wxGenericValidator(& m_password) );
  itemTextCtrl11->SetValidator( wxGenericValidator(& m_verify) );
////@end CSafeCombinationSetup content construction
}


/*!
 * Should we show tooltips?
 */

bool CSafeCombinationSetup::ShowToolTips()
{
  return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap CSafeCombinationSetup::GetBitmapResource( const wxString& name )
{
  // Bitmap retrieval
////@begin CSafeCombinationSetup bitmap retrieval
  wxUnusedVar(name);
  return wxNullBitmap;
////@end CSafeCombinationSetup bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon CSafeCombinationSetup::GetIconResource( const wxString& name )
{
  // Icon retrieval
////@begin CSafeCombinationSetup icon retrieval
  wxUnusedVar(name);
  return wxNullIcon;
////@end CSafeCombinationSetup icon retrieval
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void CSafeCombinationSetup::OnOkClick( wxCommandEvent& event )
{
  if (Validate() && TransferDataFromWindow()) {
    if (m_password != m_verify) {
      wxMessageDialog err(this, _("The two entries do not match."),
                          _("Error"), wxOK | wxICON_EXCLAMATION);
      err.ShowModal();
      return;
    }
    if (m_password.empty()) {
      wxMessageDialog err(this, _("Please enter the key and verify it."),
                          _("Error"), wxOK | wxICON_EXCLAMATION);
      err.ShowModal();
      return;
    }
    // Vox populi vox dei - folks want the ability to use a weak
    // passphrase, best we can do is warn them...
    // If someone want to build a version that insists on proper
    // passphrases, then just define the preprocessor macro
    // PWS_FORCE_STRONG_PASSPHRASE in the build properties/Makefile
    // (also used in CPasskeyChangeDlg)
#ifndef _DEBUG // for debug, we want no checks at all, to save time
    StringX errmess;
    if (!CPasswordCharPool::CheckPassword(m_password.c_str(), errmess)) {
      wxString cs_msg;
      cs_msg = _("Weak passphrase:\n\n");
      cs_msg += errmess.c_str();
#ifndef PWS_FORCE_STRONG_PASSPHRASE
      cs_msg += _("\nUse it anyway?");
      wxMessageDialog mb(this, _("Warning"), cs_msg,
                      wxYES_NO | wxNO_DEFAULT | wxICON_HAND);
      int rc = mb.ShowModal();
    if (rc == wxID_NO)
      return;
#else
    cs_msg += _("\nPlease try another");
    wxMessageDialog mb(this, _("Error"), cs_msg, wxOK | wxICON_HAND);
    mb.ShowModal();
    return;
#endif // PWS_FORCE_STRONG_PASSPHRASE
    }
#endif // _DEBUG
    EndModal(wxID_OK);
  }
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void CSafeCombinationSetup::OnCancelClick( wxCommandEvent& event )
{
////@begin wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL in CSafeCombinationSetup.
  // Before editing this code, remove the block markers.
  event.Skip();
////@end wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL in CSafeCombinationSetup. 
}

