/*
* Copyright (c) 2003-2013 Rony Shapiro <ronys@users.sourceforge.net>.
* All rights reserved. Use of the code is allowed under the
* Artistic License 2.0 terms, as specified in the LICENSE file
* distributed with this code, or available from
* http://www.opensource.org/licenses/artistic-license-2.0.php
*
* This file is used to generate pronounceable passwords.
* It was generated by the loadtris.C utility from
* http://www.multicians.org/thvv/tvvtools.html
* and slightly modified.
*/

/* BEGIN INCLUDE FILE .. trigram.h */

const long sigma = 611062;
const short tris[26][26][26] = {
  /* A A */ {{0, 6, 4, 0, 1, 0, 2, 0, 1, 0, 2, 11, 6, 6, 0, 0, 0, 16, 4, 2, 0, 0, 0, 0, 0, 0}, 
  /* A B */ {128, 171, 0, 24, 125, 0, 0, 8, 286, 12, 0, 823, 0, 15, 185, 0, 0, 93, 146, 0, 75, 0, 4, 0, 43, 0}, 
  /* A C */ {124, 4, 272, 2, 423, 0, 0, 421, 303, 0, 810, 57, 5, 2, 105, 0, 56, 105, 72, 532, 89, 0, 0, 0, 105, 0}, 
  /* A D */ {145, 27, 18, 187, 483, 15, 24, 28, 329, 68, 3, 71, 88, 17, 179, 10, 2, 98, 275, 12, 67, 112, 31, 0, 40, 11}, 
  /* A E */ {14, 0, 1, 35, 0, 0, 5, 0, 0, 2, 0, 38, 7, 5, 11, 0, 0, 42, 48, 5, 6, 1, 0, 0, 0, 2}, 
  /* A F */ {25, 0, 0, 0, 57, 211, 8, 0, 23, 0, 3, 11, 0, 6, 13, 0, 0, 23, 17, 164, 4, 0, 0, 0, 1, 0}, 
  /* A G */ {133, 0, 0, 4, 693, 2, 211, 18, 180, 0, 0, 35, 29, 124, 180, 11, 0, 96, 78, 5, 101, 0, 4, 0, 7, 0}, 
  /* A H */ {75, 0, 0, 4, 24, 2, 0, 2, 16, 2, 0, 13, 22, 6, 45, 0, 0, 6, 86, 2, 15, 0, 2, 0, 2, 0}, 
  /* A I */ {14, 4, 27, 117, 3, 9, 50, 0, 5, 4, 13, 400, 66, 690, 0, 18, 3, 349, 178, 122, 2, 16, 3, 0, 4, 5}, 
  /* A J */ {19, 0, 0, 0, 10, 0, 0, 0, 3, 0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0}, 
  /* A K */ {48, 2, 4, 3, 396, 8, 0, 22, 154, 0, 8, 14, 0, 7, 12, 1, 0, 11, 80, 3, 15, 0, 3, 0, 11, 0}, 
  /* A L */ {330, 59, 104, 142, 494, 52, 63, 14, 1257, 0, 124, 1385, 124, 13, 216, 88, 5, 22, 620, 262, 97, 86, 9, 0, 89, 4}, 
  /* A M */ {289, 269, 6, 0, 454, 2, 0, 6, 329, 0, 0, 17, 206, 26, 164, 335, 0, 23, 252, 3, 50, 0, 9, 0, 19, 0}, 
  /* A N */ {422, 15, 860, 1286, 373, 12, 658, 33, 688, 17, 305, 36, 7, 445, 192, 4, 34, 0, 1415, 1390, 95, 22, 5, 10, 66, 37}, 
  /* A O */ {0, 5, 2, 0, 0, 0, 0, 7, 11, 0, 2, 9, 2, 0, 0, 2, 0, 10, 14, 7, 3, 0, 0, 0, 0, 0}, 
  /* A P */ {110, 13, 0, 7, 252, 5, 0, 323, 143, 3, 3, 55, 4, 7, 141, 521, 0, 46, 186, 109, 32, 0, 3, 0, 18, 0}, 
  /* A Q */ {0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 72, 0, 0, 0, 0, 0}, 
  /* A R */ {553, 215, 351, 900, 449, 48, 193, 17, 1034, 21, 285, 249, 326, 206, 205, 131, 34, 484, 492, 753, 15, 68, 26, 8, 308, 10}, 
  /* A S */ {91, 9, 127, 2, 303, 0, 4, 402, 244, 0, 72, 12, 54, 6, 87, 134, 21, 2, 774, 913, 65, 0, 7, 0, 34, 0}, 
  /* A T */ {222, 14, 200, 0, 2557, 22, 2, 528, 3529, 0, 10, 34, 27, 24, 578, 1, 0, 215, 318, 522, 231, 4, 8, 0, 22, 15}, 
  /* A U */ {2, 19, 82, 129, 13, 11, 139, 2, 3, 2, 5, 124, 19, 145, 0, 18, 4, 116, 197, 220, 0, 10, 0, 18, 0, 10}, 
  /* A V */ {164, 0, 0, 2, 430, 0, 0, 0, 251, 0, 0, 7, 0, 0, 112, 0, 0, 2, 8, 0, 13, 6, 0, 0, 12, 0}, 
  /* A W */ {128, 25, 0, 23, 43, 17, 3, 6, 33, 0, 51, 58, 6, 77, 7, 5, 0, 5, 94, 5, 0, 0, 0, 0, 8, 0}, 
  /* A X */ {19, 0, 0, 0, 41, 0, 0, 0, 76, 0, 0, 4, 0, 2, 20, 3, 0, 0, 25, 4, 2, 0, 8, 0, 4, 0}, 
  /* A Y */ {78, 28, 9, 18, 122, 22, 6, 5, 70, 0, 0, 27, 35, 18, 50, 8, 0, 12, 333, 13, 5, 0, 22, 0, 6, 0}, 
  /* A Z */ {57, 0, 1, 2, 100, 0, 0, 1, 79, 0, 0, 2, 0, 0, 38, 2, 2, 0, 4, 6, 6, 2, 0, 0, 7, 40}}, 
  /* B A */ {{6, 87, 309, 54, 10, 9, 85, 16, 43, 0, 32, 317, 19, 299, 7, 20, 0, 428, 240, 237, 31, 5, 10, 2, 38, 8}, 
  /* B B */ {27, 0, 0, 0, 161, 0, 0, 0, 147, 0, 0, 131, 0, 0, 27, 0, 0, 7, 8, 0, 6, 0, 0, 0, 47, 0}, 
  /* B C */ {6, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 2, 0, 0, 17, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0}, 
  /* B D */ {2, 0, 0, 0, 2, 0, 0, 0, 19, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0}, 
  /* B E */ {247, 3, 58, 219, 95, 27, 45, 44, 20, 0, 9, 318, 8, 156, 2, 0, 7, 732, 182, 133, 4, 17, 18, 3, 17, 11}, 
  /* B F */ {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 2, 0, 0, 6, 0, 0, 0, 0, 0}, 
  /* B G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B H */ {1, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0}, 
  /* B I */ {92, 28, 59, 59, 89, 15, 49, 0, 1, 0, 23, 412, 9, 259, 72, 10, 5, 109, 117, 235, 4, 16, 2, 0, 0, 8}, 
  /* B J */ {0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 1, 0, 15, 0, 0, 0, 0, 0}, 
  /* B K */ {0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* B L */ {264, 0, 0, 0, 1198, 0, 0, 0, 291, 2, 0, 0, 0, 0, 213, 0, 0, 0, 0, 0, 113, 1, 0, 0, 221, 0}, 
  /* B M */ {5, 0, 0, 0, 16, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0}, 
  /* B N */ {8, 0, 0, 0, 18, 0, 0, 0, 2, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B O */ {234, 55, 6, 70, 20, 2, 39, 14, 32, 5, 4, 144, 42, 188, 238, 10, 0, 251, 88, 71, 151, 6, 77, 63, 64, 3}, 
  /* B P */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 5, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B R */ {431, 0, 0, 0, 288, 0, 0, 0, 365, 0, 0, 0, 0, 2, 283, 0, 0, 1, 1, 0, 120, 0, 0, 0, 19, 2}, 
  /* B S */ {2, 0, 45, 0, 66, 0, 0, 3, 30, 0, 8, 5, 0, 0, 43, 2, 0, 0, 4, 123, 11, 0, 0, 0, 2, 0}, 
  /* B T */ {13, 0, 0, 0, 17, 2, 0, 0, 7, 0, 0, 10, 0, 0, 10, 0, 0, 21, 7, 0, 6, 0, 0, 0, 0, 0}, 
  /* B U */ {2, 15, 80, 55, 5, 36, 59, 2, 29, 3, 10, 208, 47, 101, 9, 1, 2, 315, 180, 173, 2, 0, 0, 5, 8, 14}, 
  /* B V */ {0, 0, 0, 0, 10, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B W */ {9, 0, 0, 0, 7, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* B Y */ {4, 2, 0, 0, 10, 0, 2, 8, 10, 0, 0, 17, 0, 2, 0, 9, 0, 9, 55, 12, 0, 0, 6, 0, 0, 4}, 
  /* B Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* C A */ {{0, 120, 52, 120, 17, 20, 27, 10, 29, 10, 30, 871, 177, 498, 7, 278, 0, 678, 381, 920, 82, 74, 10, 2, 19, 0}, 
  /* C B */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C C */ {86, 0, 0, 0, 93, 0, 0, 19, 50, 0, 0, 38, 0, 0, 120, 0, 0, 20, 1, 0, 104, 0, 0, 0, 4, 0}, 
  /* C D */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* C E */ {73, 20, 19, 225, 25, 28, 2, 7, 66, 0, 5, 202, 86, 438, 7, 143, 0, 330, 1068, 55, 7, 2, 18, 0, 13, 1}, 
  /* C F */ {4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* C G */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0}, 
  /* C H */ {755, 37, 7, 16, 1073, 11, 3, 13, 797, 0, 0, 65, 87, 65, 338, 4, 0, 137, 206, 45, 162, 0, 39, 0, 49, 0}, 
  /* C I */ {304, 20, 18, 142, 182, 68, 11, 0, 0, 0, 0, 135, 21, 348, 155, 116, 0, 101, 212, 235, 15, 35, 0, 0, 0, 36}, 
  /* C J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C K */ {68, 63, 4, 13, 605, 19, 8, 35, 265, 7, 9, 198, 20, 58, 46, 40, 0, 26, 601, 24, 21, 0, 34, 0, 49, 0}, 
  /* C L */ {358, 0, 0, 0, 368, 0, 0, 0, 202, 0, 0, 0, 0, 0, 247, 0, 0, 0, 1, 0, 126, 0, 0, 0, 13, 0}, 
  /* C M */ {6, 0, 0, 0, 5, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* C N */ {4, 0, 0, 0, 4, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C O */ {124, 45, 147, 73, 38, 29, 58, 41, 56, 0, 8, 402, 898, 1676, 130, 196, 6, 513, 179, 131, 372, 87, 70, 14, 21, 13}, 
  /* C P */ {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 0, 0}, 
  /* C R */ {429, 0, 3, 0, 416, 0, 0, 0, 347, 0, 0, 0, 0, 0, 371, 0, 0, 0, 1, 0, 223, 0, 0, 0, 57, 0}, 
  /* C S */ {0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 1, 0, 0, 7, 0, 0, 0, 64, 5, 0, 0, 0, 0, 0, 0}, 
  /* C T */ {125, 0, 0, 0, 186, 8, 0, 0, 892, 0, 0, 20, 12, 22, 271, 0, 0, 106, 183, 0, 185, 0, 0, 0, 8, 0}, 
  /* C U */ {17, 51, 13, 27, 25, 21, 0, 0, 31, 0, 0, 343, 132, 32, 13, 81, 0, 330, 172, 152, 5, 2, 0, 0, 0, 7}, 
  /* C V */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C W */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* C Y */ {2, 8, 75, 2, 0, 0, 6, 3, 1, 0, 0, 6, 3, 12, 5, 9, 0, 7, 146, 18, 0, 0, 0, 3, 0, 0}, 
  /* C Z */ {6, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* D A */ {{0, 53, 45, 28, 9, 11, 49, 22, 69, 0, 8, 161, 107, 233, 1, 28, 0, 161, 140, 166, 35, 31, 22, 0, 95, 13}, 
  /* D B */ {50, 0, 0, 0, 18, 0, 0, 0, 11, 0, 0, 13, 0, 0, 17, 0, 0, 18, 1, 0, 19, 0, 0, 0, 5, 0}, 
  /* D C */ {36, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 5, 0, 0, 10, 0, 0, 7, 0, 0, 14, 0, 0, 0, 0, 0}, 
  /* D D */ {30, 3, 0, 0, 152, 0, 0, 11, 129, 0, 0, 157, 0, 2, 19, 0, 0, 12, 5, 0, 6, 0, 0, 0, 42, 0}, 
  /* D E */ {171, 128, 310, 436, 82, 216, 33, 23, 37, 9, 11, 312, 250, 618, 58, 200, 10, 1334, 858, 162, 15, 124, 43, 26, 0, 15}, 
  /* D F */ {20, 0, 0, 0, 3, 0, 0, 0, 20, 0, 0, 5, 0, 0, 14, 0, 0, 3, 0, 0, 13, 0, 0, 0, 0, 0}, 
  /* D G */ {7, 0, 0, 0, 292, 0, 0, 0, 55, 0, 2, 3, 18, 0, 2, 0, 0, 2, 2, 0, 6, 0, 2, 0, 4, 0}, 
  /* D H */ {15, 0, 0, 0, 35, 0, 0, 0, 17, 0, 0, 0, 0, 0, 43, 1, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0}, 
  /* D I */ {294, 29, 365, 48, 290, 94, 102, 0, 2, 4, 10, 101, 72, 762, 147, 43, 0, 90, 1181, 276, 41, 162, 4, 16, 0, 64}, 
  /* D J */ {11, 0, 0, 0, 5, 0, 0, 0, 2, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0}, 
  /* D K */ {2, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* D L */ {25, 0, 0, 0, 325, 0, 0, 0, 135, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 6, 0, 0, 0, 151, 0}, 
  /* D M */ {35, 0, 0, 0, 14, 0, 0, 0, 71, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* D N */ {19, 0, 0, 0, 150, 0, 0, 0, 7, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 6, 0, 0, 0, 0, 0, 0}, 
  /* D O */ {3, 9, 84, 26, 35, 8, 81, 2, 22, 0, 0, 123, 145, 181, 69, 19, 0, 181, 115, 34, 113, 22, 210, 19, 5, 19}, 
  /* D P */ {21, 0, 0, 0, 3, 0, 0, 3, 13, 0, 0, 4, 0, 0, 9, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* D Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0}, 
  /* D R */ {285, 0, 0, 0, 182, 0, 0, 0, 181, 0, 0, 0, 0, 0, 222, 0, 0, 0, 3, 0, 82, 0, 0, 0, 37, 0}, 
  /* D S */ {3, 0, 11, 2, 24, 1, 0, 39, 20, 0, 3, 15, 25, 0, 33, 11, 0, 0, 9, 71, 9, 0, 8, 0, 2, 0}, 
  /* D T */ {2, 0, 0, 0, 6, 0, 0, 27, 3, 0, 0, 0, 0, 0, 5, 0, 0, 3, 10, 0, 0, 0, 0, 0, 0, 0}, 
  /* D U */ {42, 24, 229, 12, 34, 7, 8, 1, 10, 0, 15, 132, 60, 63, 17, 36, 0, 65, 86, 12, 0, 6, 0, 0, 0, 2}, 
  /* D V */ {24, 0, 0, 0, 63, 0, 0, 0, 25, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* D W */ {60, 0, 0, 0, 25, 0, 0, 0, 56, 0, 0, 0, 0, 0, 32, 0, 0, 3, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* D X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* D Y */ {3, 7, 0, 0, 17, 3, 4, 0, 26, 0, 5, 9, 7, 31, 0, 0, 0, 0, 101, 0, 0, 0, 2, 0, 0, 0}, 
  /* D Z */ {0, 0, 0, 0, 7, 0, 0, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0}}, 
  /* E A */ {{0, 67, 162, 507, 3, 49, 63, 9, 1, 0, 219, 275, 178, 275, 0, 88, 0, 635, 482, 495, 108, 104, 21, 0, 0, 10}, 
  /* E B */ {127, 23, 0, 0, 98, 2, 0, 0, 40, 0, 0, 33, 0, 0, 112, 0, 0, 109, 22, 9, 81, 0, 0, 0, 3, 0}, 
  /* E C */ {175, 0, 39, 5, 212, 0, 0, 163, 216, 0, 221, 95, 0, 0, 338, 0, 2, 142, 22, 901, 139, 0, 0, 0, 13, 2}, 
  /* E D */ {125, 16, 7, 76, 295, 10, 101, 4, 433, 0, 0, 99, 17, 58, 115, 3, 0, 60, 184, 5, 106, 0, 19, 0, 20, 0}, 
  /* E E */ {6, 30, 54, 260, 0, 27, 5, 17, 31, 5, 96, 143, 74, 241, 0, 213, 0, 227, 267, 179, 2, 36, 18, 8, 2, 44}, 
  /* E F */ {91, 2, 3, 0, 139, 114, 0, 0, 175, 0, 0, 49, 0, 4, 98, 0, 0, 71, 41, 48, 172, 0, 0, 0, 11, 0}, 
  /* E G */ {234, 0, 0, 0, 110, 4, 67, 9, 155, 0, 0, 29, 14, 16, 98, 0, 0, 131, 23, 0, 73, 0, 2, 0, 13, 0}, 
  /* E H */ {61, 0, 0, 0, 110, 0, 0, 0, 21, 0, 0, 0, 2, 1, 89, 0, 0, 13, 5, 0, 17, 0, 0, 0, 8, 0}, 
  /* E I */ {10, 2, 19, 41, 4, 16, 164, 0, 2, 3, 10, 48, 38, 243, 0, 9, 0, 39, 117, 60, 2, 46, 0, 0, 0, 10}, 
  /* E J */ {26, 0, 0, 0, 23, 0, 0, 0, 2, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0}, 
  /* E K */ {14, 3, 0, 5, 56, 0, 0, 4, 41, 0, 4, 8, 0, 10, 4, 0, 0, 0, 37, 0, 0, 0, 0, 0, 4, 0}, 
  /* E L */ {280, 40, 24, 145, 649, 43, 19, 4, 683, 2, 11, 991, 58, 9, 207, 55, 0, 15, 468, 100, 57, 68, 7, 0, 355, 5}, 
  /* E M */ {346, 234, 5, 0, 524, 2, 0, 0, 353, 0, 2, 25, 24, 35, 279, 236, 0, 0, 78, 1, 65, 0, 0, 0, 16, 0}, 
  /* E N */ {333, 36, 874, 725, 884, 39, 174, 48, 420, 16, 22, 72, 20, 197, 186, 18, 6, 48, 926, 2748, 112, 48, 16, 0, 19, 37}, 
  /* E O */ {0, 0, 33, 29, 2, 8, 34, 0, 6, 0, 2, 55, 15, 136, 0, 54, 0, 68, 44, 29, 77, 7, 8, 0, 0, 1}, 
  /* E P */ {147, 5, 7, 6, 161, 6, 0, 92, 160, 0, 2, 100, 3, 3, 126, 64, 0, 170, 98, 206, 71, 0, 9, 0, 8, 0}, 
  /* E Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 0, 0, 0, 0, 0}, 
  /* E R */ {967, 260, 346, 132, 1027, 180, 237, 80, 1267, 26, 53, 255, 440, 443, 337, 219, 6, 421, 4451, 532, 66, 272, 92, 4, 298, 13}, 
  /* E S */ {100, 12, 263, 26, 285, 0, 7, 149, 306, 0, 16, 24, 48, 11, 124, 210, 29, 0, 3031, 2351, 93, 0, 15, 0, 15, 0}, 
  /* E T */ {257, 27, 73, 3, 493, 16, 0, 230, 432, 0, 3, 23, 10, 13, 161, 7, 0, 282, 564, 506, 65, 0, 14, 0, 75, 17}, 
  /* E U */ {0, 4, 22, 17, 5, 0, 12, 0, 1, 0, 6, 14, 37, 19, 0, 32, 0, 120, 65, 55, 0, 16, 2, 4, 0, 0}, 
  /* E V */ {181, 0, 0, 0, 453, 0, 0, 0, 270, 0, 0, 3, 0, 0, 110, 0, 0, 7, 26, 2, 5, 2, 0, 0, 8, 0}, 
  /* E W */ {129, 10, 5, 18, 117, 7, 3, 15, 87, 0, 0, 13, 5, 5, 84, 7, 0, 20, 129, 12, 0, 0, 0, 0, 6, 0}, 
  /* E X */ {93, 0, 149, 0, 106, 0, 0, 53, 122, 0, 0, 1, 0, 0, 36, 294, 2, 0, 29, 221, 47, 0, 0, 2, 3, 0}, 
  /* E Y */ {18, 15, 8, 9, 113, 3, 0, 6, 21, 0, 2, 5, 21, 20, 15, 4, 0, 13, 285, 0, 0, 1, 10, 0, 0, 0}, 
  /* E Z */ {3, 2, 0, 0, 47, 0, 0, 4, 18, 0, 0, 0, 0, 0, 7, 0, 0, 2, 33, 0, 5, 5, 0, 0, 2, 23}}, 
  /* F A */ {{0, 42, 160, 11, 5, 2, 18, 8, 84, 0, 12, 131, 42, 86, 0, 0, 0, 117, 72, 109, 47, 21, 12, 11, 6, 4}, 
  /* F B */ {6, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* F C */ {3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F D */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F E */ {67, 12, 130, 116, 64, 1, 8, 0, 38, 0, 3, 78, 20, 96, 0, 0, 0, 370, 138, 59, 14, 6, 11, 0, 7, 6}, 
  /* F F */ {40, 9, 0, 0, 260, 0, 0, 5, 221, 0, 0, 97, 4, 4, 43, 0, 0, 33, 132, 0, 30, 0, 0, 0, 18, 0}, 
  /* F G */ {2, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F H */ {5, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F I */ {44, 25, 322, 63, 344, 15, 97, 0, 0, 5, 0, 152, 0, 344, 6, 0, 0, 167, 146, 90, 0, 5, 0, 51, 0, 17}, 
  /* F J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F K */ {3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* F L */ {313, 0, 0, 0, 205, 0, 0, 0, 133, 0, 0, 0, 0, 0, 194, 0, 0, 0, 2, 0, 155, 0, 0, 0, 55, 0}, 
  /* F M */ {6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* F N */ {0, 0, 0, 0, 12, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F O */ {15, 5, 30, 6, 9, 0, 32, 0, 22, 0, 2, 100, 10, 33, 126, 6, 0, 722, 19, 3, 92, 0, 16, 28, 3, 0}, 
  /* F P */ {0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F R */ {251, 0, 0, 0, 254, 0, 0, 0, 176, 0, 0, 0, 0, 0, 149, 0, 0, 3, 1, 0, 52, 0, 0, 0, 13, 0}, 
  /* F S */ {1, 0, 0, 0, 4, 0, 0, 4, 2, 0, 4, 0, 0, 0, 0, 3, 0, 0, 1, 7, 0, 0, 0, 0, 0, 0}, 
  /* F T */ {6, 3, 0, 0, 122, 0, 0, 7, 70, 0, 0, 5, 1, 6, 12, 0, 0, 0, 97, 0, 0, 0, 10, 0, 13, 0}, 
  /* F U */ {0, 0, 23, 13, 14, 0, 25, 0, 0, 6, 2, 497, 30, 100, 0, 0, 0, 114, 112, 31, 0, 0, 0, 0, 0, 19}, 
  /* F V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F W */ {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* F Y */ {0, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0}, 
  /* F Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* G A */ {{2, 53, 12, 35, 13, 8, 51, 7, 47, 0, 0, 214, 105, 254, 5, 21, 0, 322, 120, 357, 42, 14, 19, 0, 15, 37}, 
  /* G B */ {0, 0, 0, 0, 6, 0, 0, 0, 9, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* G C */ {3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* G D */ {9, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 2, 1, 0, 1, 0, 0, 0, 0, 0}, 
  /* G E */ {52, 7, 7, 295, 43, 5, 0, 18, 17, 0, 0, 120, 67, 492, 115, 8, 0, 619, 609, 109, 2, 6, 13, 0, 14, 0}, 
  /* G F */ {0, 0, 0, 0, 4, 0, 0, 0, 12, 0, 0, 2, 0, 0, 2, 0, 0, 5, 0, 0, 6, 0, 0, 0, 0, 0}, 
  /* G G */ {39, 3, 0, 2, 221, 0, 0, 3, 171, 0, 0, 136, 0, 2, 15, 3, 0, 32, 13, 0, 0, 0, 0, 0, 26, 0}, 
  /* G H */ {65, 28, 3, 2, 70, 4, 1, 5, 37, 4, 0, 19, 0, 17, 56, 2, 0, 2, 58, 640, 8, 0, 12, 0, 3, 0}, 
  /* G I */ {69, 68, 100, 29, 155, 5, 24, 0, 0, 0, 0, 76, 34, 491, 64, 4, 0, 56, 241, 76, 6, 32, 0, 0, 0, 27}, 
  /* G J */ {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* G K */ {0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* G L */ {154, 0, 0, 0, 298, 0, 0, 0, 186, 0, 0, 0, 0, 0, 140, 0, 0, 0, 0, 0, 44, 0, 0, 0, 179, 0}, 
  /* G M */ {64, 0, 0, 0, 50, 0, 0, 0, 12, 0, 0, 0, 0, 0, 5, 0, 0, 0, 6, 0, 4, 0, 0, 0, 7, 0}, 
  /* G N */ {133, 3, 0, 0, 127, 0, 0, 0, 111, 0, 0, 1, 14, 0, 83, 5, 0, 0, 25, 2, 12, 0, 0, 0, 0, 0}, 
  /* G O */ {42, 28, 3, 62, 31, 5, 38, 0, 36, 0, 0, 95, 10, 174, 84, 4, 0, 125, 105, 81, 46, 36, 12, 0, 9, 0}, 
  /* G P */ {2, 0, 0, 0, 3, 0, 0, 0, 9, 0, 0, 6, 0, 0, 3, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* G Q */ {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* G R */ {835, 0, 0, 0, 331, 0, 0, 0, 185, 0, 0, 0, 0, 2, 243, 0, 0, 0, 1, 3, 93, 0, 0, 0, 2, 0}, 
  /* G S */ {8, 5, 0, 0, 0, 0, 0, 21, 3, 0, 7, 0, 0, 0, 9, 6, 0, 0, 6, 49, 0, 0, 0, 0, 0, 0}, 
  /* G T */ {7, 0, 0, 0, 4, 0, 0, 23, 7, 0, 0, 0, 0, 0, 30, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 2}, 
  /* G U */ {136, 5, 4, 2, 181, 9, 2, 0, 162, 6, 0, 116, 31, 79, 13, 9, 0, 80, 90, 33, 0, 0, 0, 0, 12, 9}, 
  /* G V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* G W */ {20, 0, 0, 0, 10, 0, 0, 3, 3, 0, 0, 0, 0, 0, 11, 0, 0, 3, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* G X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* G Y */ {5, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 20, 13, 0, 17, 0, 16, 98, 0, 0, 0, 2, 0, 0, 1}, 
  /* G Z */ {5, 0, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* H A */ {{4, 126, 64, 80, 22, 32, 64, 12, 151, 0, 46, 297, 250, 661, 4, 104, 0, 621, 199, 150, 87, 53, 80, 0, 46, 42}, 
  /* H B */ {29, 0, 0, 0, 3, 0, 0, 0, 6, 0, 0, 8, 0, 0, 46, 0, 0, 10, 0, 0, 7, 0, 0, 0, 0, 0}, 
  /* H C */ {9, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 6, 0, 0, 6, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H D */ {5, 0, 0, 0, 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 9, 0, 0, 8, 1, 0, 3, 0, 0, 0, 0, 0}, 
  /* H E */ {551, 22, 87, 393, 210, 19, 7, 2, 123, 0, 7, 286, 172, 264, 80, 31, 6, 1107, 627, 154, 19, 42, 46, 12, 22, 7}, 
  /* H F */ {4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 1, 0, 45, 0, 0, 0, 0, 0}, 
  /* H G */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0}, 
  /* H H */ {6, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H I */ {75, 73, 193, 44, 250, 24, 77, 3, 1, 9, 24, 305, 88, 695, 46, 296, 2, 155, 226, 168, 8, 40, 0, 0, 0, 37}, 
  /* H J */ {4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H K */ {3, 0, 0, 0, 4, 0, 0, 2, 2, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H L */ {8, 0, 0, 0, 72, 0, 0, 0, 40, 0, 0, 0, 0, 0, 45, 0, 0, 3, 3, 0, 2, 0, 0, 0, 51, 0}, 
  /* H M */ {88, 0, 0, 0, 87, 0, 0, 0, 17, 0, 0, 0, 0, 0, 11, 0, 0, 0, 11, 0, 6, 0, 0, 0, 0, 0}, 
  /* H N */ {23, 0, 0, 0, 83, 0, 0, 2, 36, 0, 0, 0, 2, 4, 20, 0, 1, 0, 17, 0, 5, 0, 0, 0, 2, 0}, 
  /* H O */ {55, 61, 42, 66, 76, 14, 62, 9, 27, 0, 24, 384, 177, 274, 290, 148, 0, 474, 171, 148, 299, 37, 104, 0, 4, 0}, 
  /* H P */ {9, 0, 0, 0, 0, 0, 0, 1, 9, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* H Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0}, 
  /* H R */ {83, 0, 0, 1, 79, 0, 0, 0, 160, 0, 0, 2, 2, 0, 222, 0, 0, 0, 3, 0, 39, 0, 0, 0, 21, 0}, 
  /* H S */ {9, 0, 2, 0, 2, 0, 0, 9, 5, 0, 3, 0, 0, 0, 10, 0, 0, 0, 3, 20, 0, 0, 0, 0, 0, 0}, 
  /* H T */ {17, 0, 9, 0, 151, 18, 3, 35, 82, 3, 0, 34, 5, 17, 14, 0, 0, 12, 175, 1, 8, 0, 5, 0, 12, 2}, 
  /* H U */ {31, 34, 38, 18, 10, 29, 28, 2, 4, 0, 4, 33, 201, 135, 0, 4, 0, 114, 113, 63, 0, 2, 0, 2, 6, 0}, 
  /* H V */ {2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H W */ {60, 0, 0, 0, 25, 0, 0, 8, 13, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* H Y */ {7, 9, 0, 80, 7, 0, 11, 0, 6, 0, 0, 25, 26, 2, 0, 105, 0, 9, 129, 14, 2, 0, 0, 9, 0, 0}, 
  /* H Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 0}}, 
  /* I A */ {{0, 77, 67, 30, 6, 2, 66, 33, 8, 0, 9, 479, 51, 893, 2, 18, 0, 119, 385, 436, 4, 4, 4, 0, 0, 7}, 
  /* I B */ {57, 92, 2, 0, 171, 0, 0, 0, 188, 0, 0, 208, 2, 6, 26, 0, 0, 57, 26, 0, 97, 0, 3, 0, 11, 0}, 
  /* I C */ {1148, 0, 29, 0, 443, 0, 0, 177, 526, 0, 644, 69, 2, 8, 138, 0, 0, 77, 458, 245, 138, 0, 0, 0, 28, 0}, 
  /* I D */ {157, 3, 0, 125, 758, 0, 92, 2, 226, 2, 0, 58, 2, 38, 48, 3, 0, 9, 177, 14, 38, 0, 23, 0, 17, 0}, 
  /* I E */ {0, 15, 46, 282, 0, 74, 32, 4, 8, 0, 5, 158, 14, 312, 0, 2, 0, 991, 2142, 135, 24, 109, 45, 0, 2, 5}, 
  /* I F */ {17, 0, 0, 0, 134, 167, 0, 0, 431, 0, 0, 28, 0, 0, 31, 0, 0, 7, 12, 131, 33, 0, 0, 0, 149, 0}, 
  /* I G */ {198, 0, 0, 0, 123, 1, 139, 661, 119, 0, 0, 24, 46, 265, 61, 3, 0, 99, 53, 3, 83, 0, 10, 0, 4, 5}, 
  /* I H */ {9, 0, 0, 0, 7, 0, 0, 0, 20, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0}, 
  /* I I */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 5, 1, 0, 0, 0, 0, 0, 0}, 
  /* I J */ {22, 0, 0, 0, 0, 0, 0, 0, 11, 0, 2, 0, 0, 0, 5, 0, 0, 0, 3, 0, 4, 0, 0, 0, 0, 0}, 
  /* I K */ {36, 0, 0, 3, 127, 0, 0, 14, 46, 0, 6, 0, 0, 2, 20, 0, 0, 0, 19, 0, 4, 0, 0, 0, 1, 0}, 
  /* I L */ {219, 47, 27, 146, 463, 29, 18, 13, 761, 0, 59, 995, 49, 9, 127, 3, 4, 10, 239, 118, 16, 24, 13, 0, 171, 0}, 
  /* I M */ {235, 115, 2, 0, 340, 6, 0, 0, 262, 0, 0, 17, 197, 15, 93, 576, 0, 7, 101, 2, 59, 0, 4, 0, 3, 0}, 
  /* I N */ {799, 32, 564, 696, 1793, 287, 8834, 81, 555, 31, 264, 39, 23, 228, 206, 22, 43, 8, 1058, 1062, 123, 165, 22, 15, 29, 1}, 
  /* I O */ {5, 2, 33, 24, 2, 2, 38, 0, 4, 0, 2, 128, 13, 4252, 0, 37, 0, 88, 118, 80, 373, 4, 7, 4, 0, 2}, 
  /* I P */ {88, 10, 5, 0, 142, 1, 0, 49, 60, 0, 3, 99, 16, 0, 33, 250, 0, 23, 212, 97, 30, 0, 8, 0, 4, 2}, 
  /* I Q */ {2, 2, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 0, 0, 0, 0, 0}, 
  /* I R */ {164, 15, 129, 105, 437, 10, 31, 3, 159, 0, 48, 87, 79, 13, 96, 24, 0, 131, 149, 138, 12, 11, 22, 0, 24, 2}, 
  /* I S */ {242, 43, 394, 39, 509, 52, 38, 769, 336, 13, 67, 84, 653, 13, 191, 198, 27, 55, 593, 1856, 37, 2, 0, 0, 12, 2}, 
  /* I T */ {557, 5, 153, 1, 617, 22, 0, 248, 908, 5, 0, 46, 16, 25, 205, 6, 0, 74, 263, 348, 249, 0, 7, 0, 1029, 69}, 
  /* I U */ {0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 208, 2, 2, 0, 0, 4, 100, 2, 0, 0, 0, 0, 0, 0}, 
  /* I V */ {204, 0, 0, 0, 1046, 0, 0, 0, 309, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 7, 11, 0, 0, 7, 0}, 
  /* I W */ {10, 0, 0, 0, 6, 0, 0, 0, 15, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* I X */ {10, 0, 0, 0, 38, 0, 0, 0, 29, 0, 0, 0, 0, 0, 9, 3, 0, 0, 21, 26, 0, 0, 0, 0, 1, 0}, 
  /* I Y */ {17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* I Z */ {265, 0, 0, 0, 832, 0, 0, 2, 249, 0, 0, 0, 11, 0, 34, 0, 0, 0, 12, 0, 3, 2, 0, 0, 0, 88}}, 
  /* J A */ {{0, 18, 136, 5, 2, 0, 17, 12, 21, 0, 10, 8, 45, 69, 0, 16, 0, 32, 18, 2, 17, 13, 16, 4, 39, 8}, 
  /* J B */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J C */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J D */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J E */ {22, 0, 108, 4, 15, 13, 0, 4, 0, 1, 2, 17, 0, 18, 6, 2, 0, 52, 30, 20, 0, 2, 29, 0, 0, 3}, 
  /* J F */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J H */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J I */ {6, 16, 0, 2, 0, 3, 22, 3, 0, 0, 1, 11, 13, 34, 0, 0, 0, 0, 3, 16, 0, 7, 2, 0, 0, 0}, 
  /* J J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J K */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* J L */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J M */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J N */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J O */ {10, 14, 32, 7, 10, 0, 13, 32, 53, 0, 9, 29, 2, 27, 0, 2, 0, 33, 42, 5, 52, 7, 3, 0, 47, 0}, 
  /* J P */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J R */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* J S */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0}, 
  /* J T */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J U */ {11, 14, 0, 82, 0, 0, 33, 0, 13, 5, 5, 35, 23, 86, 0, 2, 0, 62, 58, 11, 0, 9, 2, 7, 0, 0}, 
  /* J V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J W */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J Y */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* J Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* K A */ {{4, 35, 3, 21, 2, 3, 34, 15, 15, 0, 0, 45, 15, 54, 4, 8, 0, 73, 59, 79, 8, 0, 6, 7, 19, 13}, 
  /* K B */ {13, 0, 0, 0, 11, 0, 0, 0, 15, 0, 0, 3, 0, 0, 33, 0, 0, 4, 0, 0, 7, 0, 0, 0, 0, 0}, 
  /* K C */ {6, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0}, 
  /* K D */ {15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K E */ {11, 11, 2, 375, 88, 6, 9, 3, 14, 0, 1, 77, 12, 212, 17, 10, 0, 612, 262, 222, 5, 7, 16, 0, 114, 0}, 
  /* K F */ {6, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 19, 0, 0, 0, 0, 0}, 
  /* K G */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* K H */ {70, 0, 0, 0, 13, 0, 0, 0, 3, 0, 0, 0, 4, 2, 42, 0, 0, 2, 7, 0, 6, 0, 2, 0, 2, 2}, 
  /* K I */ {22, 12, 24, 44, 210, 5, 2, 2, 2, 0, 4, 90, 32, 787, 5, 20, 0, 56, 78, 59, 2, 5, 5, 0, 2, 0}, 
  /* K J */ {9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K K */ {9, 0, 0, 0, 11, 0, 0, 0, 10, 0, 0, 0, 0, 9, 5, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* K L */ {38, 0, 0, 0, 186, 0, 0, 0, 82, 0, 0, 0, 0, 1, 18, 0, 0, 0, 0, 0, 12, 0, 0, 0, 26, 0}, 
  /* K M */ {52, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K N */ {31, 0, 0, 0, 98, 0, 2, 0, 55, 0, 0, 0, 0, 0, 90, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0}, 
  /* K O */ {3, 2, 7, 8, 6, 5, 1, 9, 0, 2, 6, 12, 2, 22, 18, 11, 0, 24, 28, 9, 25, 21, 8, 0, 2, 0}, 
  /* K P */ {10, 0, 0, 0, 9, 0, 0, 0, 10, 0, 0, 2, 0, 0, 13, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K R */ {36, 0, 0, 0, 12, 0, 0, 0, 32, 0, 0, 0, 0, 3, 35, 0, 0, 0, 1, 0, 15, 0, 0, 0, 8, 0}, 
  /* K S */ {14, 2, 8, 0, 5, 0, 5, 37, 7, 0, 5, 12, 13, 0, 15, 9, 0, 0, 6, 43, 3, 0, 2, 0, 1, 0}, 
  /* K T */ {3, 0, 0, 0, 1, 0, 0, 6, 5, 0, 0, 0, 0, 0, 17, 0, 0, 4, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* K U */ {1, 4, 0, 5, 0, 0, 2, 2, 2, 0, 4, 25, 9, 9, 4, 27, 0, 13, 12, 8, 0, 0, 5, 0, 2, 6}, 
  /* K V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K W */ {31, 0, 0, 0, 15, 0, 0, 2, 5, 0, 0, 0, 0, 0, 15, 0, 0, 2, 0, 0, 6, 0, 0, 0, 1, 0}, 
  /* K X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* K Y */ {12, 0, 3, 9, 3, 0, 0, 0, 2, 7, 0, 17, 0, 0, 4, 0, 0, 9, 42, 0, 6, 0, 7, 0, 0, 0}, 
  /* K Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* L A */ {{5, 182, 343, 156, 19, 11, 152, 40, 210, 6, 36, 10, 275, 797, 10, 115, 5, 474, 547, 977, 168, 103, 84, 35, 232, 52}, 
  /* L B */ {43, 0, 0, 0, 52, 0, 0, 0, 22, 2, 0, 9, 0, 0, 56, 0, 0, 13, 7, 0, 13, 2, 0, 0, 8, 0}, 
  /* L C */ {36, 0, 0, 0, 15, 0, 0, 56, 20, 0, 2, 5, 2, 0, 53, 0, 0, 7, 1, 0, 28, 0, 0, 0, 5, 0}, 
  /* L D */ {24, 12, 5, 0, 221, 18, 0, 5, 88, 0, 0, 18, 2, 13, 54, 4, 0, 23, 154, 4, 11, 1, 11, 0, 2, 0}, 
  /* L E */ {419, 59, 306, 890, 175, 51, 237, 15, 63, 9, 2, 45, 215, 442, 68, 69, 4, 781, 1773, 442, 36, 133, 49, 99, 182, 8}, 
  /* L F */ {14, 3, 0, 0, 17, 2, 2, 7, 51, 0, 0, 7, 0, 0, 25, 4, 0, 24, 24, 4, 30, 0, 1, 0, 0, 0}, 
  /* L G */ {73, 0, 0, 0, 53, 0, 0, 0, 28, 0, 0, 0, 0, 0, 17, 0, 0, 12, 0, 0, 2, 0, 0, 0, 1, 0}, 
  /* L H */ {19, 0, 0, 0, 12, 0, 0, 0, 2, 0, 0, 0, 0, 0, 27, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* L I */ {321, 168, 491, 124, 560, 187, 299, 8, 0, 2, 61, 60, 222, 1791, 186, 155, 51, 19, 729, 874, 27, 139, 6, 11, 2, 454}, 
  /* L J */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0}, 
  /* L K */ {24, 3, 0, 0, 55, 0, 0, 5, 49, 0, 0, 5, 8, 3, 5, 0, 0, 0, 62, 0, 0, 0, 9, 0, 9, 0}, 
  /* L L */ {476, 43, 5, 18, 891, 29, 3, 16, 800, 2, 0, 0, 24, 16, 404, 21, 0, 9, 430, 6, 135, 2, 11, 0, 721, 0}, 
  /* L M */ {64, 0, 0, 0, 73, 0, 0, 2, 51, 0, 0, 1, 2, 2, 40, 0, 0, 0, 41, 0, 4, 0, 0, 0, 6, 0}, 
  /* L N */ {10, 0, 0, 0, 129, 0, 0, 0, 7, 0, 0, 0, 0, 0, 3, 0, 0, 0, 4, 0, 8, 0, 0, 0, 0, 0}, 
  /* L O */ {125, 73, 283, 80, 27, 24, 551, 14, 71, 0, 4, 29, 78, 291, 222, 161, 37, 281, 214, 226, 238, 93, 331, 10, 78, 3}, 
  /* L P */ {40, 0, 0, 0, 20, 5, 0, 59, 31, 0, 0, 9, 6, 0, 20, 0, 0, 7, 13, 13, 1, 0, 0, 0, 1, 0}, 
  /* L Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0}, 
  /* L R */ {8, 0, 0, 0, 3, 0, 0, 0, 10, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 6, 0, 0, 0, 19, 0}, 
  /* L S */ {30, 5, 2, 0, 42, 1, 0, 28, 73, 0, 6, 0, 2, 0, 29, 13, 2, 0, 6, 66, 2, 0, 2, 0, 4, 0}, 
  /* L T */ {76, 0, 3, 4, 165, 2, 0, 52, 172, 0, 0, 3, 7, 0, 55, 3, 0, 61, 93, 0, 36, 0, 4, 0, 33, 17}, 
  /* L U */ {32, 67, 120, 74, 104, 22, 51, 2, 35, 2, 17, 28, 203, 116, 31, 22, 0, 79, 233, 179, 0, 8, 0, 32, 2, 4}, 
  /* L V */ {62, 0, 0, 1, 148, 0, 0, 0, 51, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* L W */ {19, 0, 0, 0, 9, 0, 0, 0, 8, 0, 0, 0, 0, 0, 13, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* L X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* L Y */ {21, 11, 35, 10, 14, 6, 21, 19, 35, 0, 0, 10, 41, 61, 6, 31, 0, 12, 133, 38, 7, 0, 20, 5, 0, 20}, 
  /* L Z */ {2, 0, 0, 0, 2, 0, 0, 4, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}}, 
  /* M A */ {{5, 30, 221, 114, 18, 6, 195, 53, 185, 25, 89, 323, 51, 1141, 10, 29, 0, 681, 382, 659, 49, 11, 7, 43, 58, 38}, 
  /* M B */ {149, 3, 0, 2, 232, 4, 0, 0, 122, 0, 3, 200, 2, 7, 135, 0, 0, 84, 61, 3, 80, 0, 3, 0, 1, 0}, 
  /* M C */ {5, 2, 29, 8, 7, 4, 10, 5, 13, 0, 12, 8, 4, 6, 4, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0}, 
  /* M D */ {0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 4, 1, 0, 2, 0, 0, 0, 0, 0}, 
  /* M E */ {126, 17, 34, 364, 23, 4, 48, 5, 10, 2, 10, 245, 81, 1467, 24, 8, 0, 636, 360, 324, 5, 2, 26, 8, 16, 10}, 
  /* M F */ {0, 0, 0, 0, 3, 0, 0, 0, 10, 0, 0, 8, 0, 0, 31, 0, 0, 0, 0, 0, 13, 0, 0, 0, 1, 0}, 
  /* M G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* M H */ {4, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 1}, 
  /* M I */ {72, 4, 273, 147, 136, 23, 73, 0, 0, 3, 16, 318, 32, 1026, 9, 5, 0, 102, 700, 312, 9, 0, 2, 16, 0, 61}, 
  /* M J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* M K */ {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* M L */ {7, 0, 0, 0, 36, 0, 0, 0, 32, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0}, 
  /* M M */ {136, 0, 0, 0, 312, 0, 0, 0, 171, 0, 0, 2, 0, 0, 133, 0, 0, 0, 2, 0, 100, 0, 0, 0, 37, 0}, 
  /* M N */ {41, 0, 2, 1, 50, 0, 0, 0, 55, 0, 0, 1, 0, 0, 8, 0, 0, 0, 11, 0, 2, 0, 0, 0, 2, 0}, 
  /* M O */ {16, 58, 57, 134, 10, 0, 52, 28, 45, 2, 29, 155, 33, 582, 111, 35, 0, 391, 153, 210, 217, 38, 15, 7, 2, 10}, 
  /* M P */ {216, 8, 0, 3, 346, 3, 3, 70, 159, 0, 8, 296, 3, 5, 209, 5, 0, 145, 118, 114, 106, 0, 0, 0, 12, 0}, 
  /* M Q */ {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* M R */ {9, 0, 0, 0, 3, 0, 3, 0, 2, 0, 0, 0, 0, 0, 24, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0}, 
  /* M S */ {2, 2, 7, 2, 16, 1, 0, 14, 17, 0, 9, 0, 3, 0, 21, 3, 0, 0, 4, 49, 5, 0, 0, 0, 3, 0}, 
  /* M T */ {0, 0, 0, 0, 5, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* M U */ {2, 2, 32, 43, 14, 24, 31, 7, 4, 2, 3, 216, 40, 123, 0, 2, 0, 97, 194, 105, 6, 0, 0, 0, 0, 12}, 
  /* M V */ {0, 0, 0, 0, 7, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* M W */ {4, 0, 0, 0, 6, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* M X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* M Y */ {4, 0, 7, 0, 3, 0, 0, 0, 3, 0, 3, 4, 0, 5, 4, 0, 0, 21, 82, 12, 0, 0, 0, 0, 0, 0}, 
  /* M Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* N A */ {{2, 131, 157, 92, 32, 14, 114, 25, 106, 0, 34, 527, 130, 236, 4, 118, 0, 267, 333, 752, 81, 63, 18, 2, 12, 16}, 
  /* N B */ {39, 0, 0, 0, 68, 0, 0, 0, 9, 0, 0, 9, 0, 0, 40, 0, 0, 17, 1, 0, 35, 0, 0, 0, 0, 0}, 
  /* N C */ {114, 0, 0, 0, 1269, 0, 0, 463, 314, 0, 12, 99, 2, 0, 289, 0, 0, 72, 9, 154, 77, 0, 0, 0, 185, 0}, 
  /* N D */ {334, 64, 21, 6, 1104, 25, 3, 27, 539, 5, 4, 153, 34, 19, 236, 28, 3, 155, 527, 12, 160, 0, 29, 0, 61, 0}, 
  /* N E */ {120, 29, 131, 554, 121, 56, 96, 9, 42, 0, 6, 200, 86, 101, 48, 27, 17, 707, 2784, 290, 80, 52, 119, 53, 159, 16}, 
  /* N F */ {73, 0, 0, 0, 120, 0, 0, 0, 118, 0, 0, 86, 0, 0, 112, 0, 0, 60, 0, 0, 69, 0, 0, 0, 0, 0}, 
  /* N G */ {101, 23, 2, 14, 583, 16, 0, 61, 174, 2, 9, 368, 11, 17, 107, 8, 1, 130, 1101, 61, 135, 0, 14, 0, 13, 5}, 
  /* N H */ {82, 0, 0, 0, 58, 0, 0, 0, 21, 0, 0, 0, 0, 2, 56, 0, 0, 0, 2, 0, 15, 0, 0, 0, 0, 0}, 
  /* N I */ {342, 42, 416, 27, 250, 138, 121, 15, 1, 2, 30, 38, 101, 751, 101, 75, 23, 18, 588, 382, 53, 47, 2, 11, 0, 231}, 
  /* N J */ {17, 0, 0, 0, 18, 0, 0, 0, 2, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0}, 
  /* N K */ {31, 6, 3, 0, 202, 18, 4, 13, 156, 0, 0, 66, 5, 19, 10, 0, 0, 15, 134, 2, 4, 0, 3, 0, 23, 0}, 
  /* N L */ {39, 0, 0, 0, 41, 0, 0, 0, 92, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 4, 0, 0, 0, 45, 0}, 
  /* N M */ {46, 0, 0, 0, 85, 0, 0, 0, 9, 0, 0, 0, 0, 0, 15, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0}, 
  /* N N */ {154, 2, 0, 0, 449, 0, 0, 4, 265, 0, 3, 0, 2, 0, 120, 0, 0, 0, 47, 0, 33, 0, 0, 0, 85, 2}, 
  /* N O */ {7, 68, 78, 34, 27, 22, 50, 2, 52, 0, 1, 101, 165, 249, 64, 51, 0, 244, 196, 175, 149, 88, 113, 15, 14, 10}, 
  /* N P */ {24, 0, 0, 0, 7, 0, 0, 1, 16, 0, 0, 26, 0, 0, 32, 0, 0, 35, 0, 0, 9, 0, 0, 0, 0, 0}, 
  /* N Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 0, 0, 0, 0, 0}, 
  /* N R */ {20, 0, 0, 0, 63, 0, 0, 0, 33, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 15, 0, 0, 0, 12, 0}, 
  /* N S */ {115, 8, 105, 3, 331, 46, 9, 99, 377, 0, 39, 40, 47, 14, 151, 93, 0, 0, 46, 374, 168, 16, 22, 0, 14, 0}, 
  /* N T */ {584, 5, 4, 3, 1149, 8, 9, 222, 983, 0, 0, 229, 27, 17, 254, 2, 0, 386, 1169, 0, 114, 0, 14, 0, 45, 15}, 
  /* N U */ {56, 20, 27, 21, 47, 28, 14, 2, 26, 2, 16, 35, 111, 44, 17, 13, 0, 44, 78, 101, 3, 0, 0, 1, 0, 4}, 
  /* N V */ {63, 0, 0, 0, 179, 0, 0, 0, 90, 0, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 13, 0, 0, 0, 3, 0}, 
  /* N W */ {51, 0, 0, 0, 10, 0, 0, 10, 23, 0, 0, 0, 0, 0, 24, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* N X */ {0, 0, 0, 0, 8, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0}, 
  /* N Y */ {35, 2, 0, 2, 2, 0, 0, 1, 12, 0, 0, 6, 36, 0, 8, 1, 2, 0, 103, 6, 0, 2, 7, 3, 0, 0}, 
  /* N Z */ {37, 0, 0, 0, 16, 0, 0, 1, 17, 0, 0, 0, 0, 0, 15, 0, 0, 0, 2, 0, 2, 0, 2, 0, 5, 0}}, 
  /* O A */ {{0, 1, 56, 150, 0, 15, 12, 6, 0, 0, 27, 47, 26, 58, 0, 17, 2, 208, 75, 196, 5, 4, 0, 14, 0, 0}, 
  /* O B */ {75, 137, 3, 9, 119, 6, 3, 0, 120, 22, 0, 86, 0, 11, 46, 0, 0, 18, 161, 26, 20, 10, 6, 0, 10, 0}, 
  /* O C */ {200, 0, 98, 0, 106, 0, 0, 144, 106, 0, 543, 33, 0, 0, 80, 0, 1, 102, 13, 80, 92, 0, 0, 0, 13, 0}, 
  /* O D */ {47, 7, 23, 87, 243, 7, 55, 17, 207, 0, 5, 48, 11, 5, 98, 9, 0, 18, 181, 7, 79, 0, 20, 0, 74, 3}, 
  /* O E */ {2, 16, 3, 58, 0, 9, 2, 8, 18, 0, 4, 16, 12, 32, 3, 0, 2, 32, 154, 21, 4, 10, 6, 6, 7, 0}, 
  /* O F */ {20, 0, 0, 0, 59, 191, 0, 0, 60, 0, 0, 9, 0, 2, 21, 0, 0, 6, 29, 58, 11, 0, 0, 0, 1, 0}, 
  /* O G */ {90, 6, 3, 2, 128, 8, 120, 11, 269, 5, 0, 23, 15, 61, 28, 0, 0, 281, 67, 5, 69, 0, 10, 0, 168, 0}, 
  /* O H */ {44, 0, 0, 0, 41, 0, 0, 2, 34, 0, 0, 5, 5, 27, 23, 0, 0, 2, 13, 0, 0, 0, 0, 0, 3, 0}, 
  /* O I */ {9, 3, 44, 97, 5, 12, 4, 0, 0, 0, 5, 141, 3, 254, 0, 0, 0, 40, 202, 48, 0, 0, 0, 3, 0, 0}, 
  /* O J */ {11, 0, 0, 0, 20, 0, 0, 0, 3, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* O K */ {30, 3, 3, 0, 241, 0, 0, 2, 73, 0, 9, 11, 15, 2, 16, 0, 0, 3, 93, 1, 15, 0, 6, 0, 10, 0}, 
  /* O L */ {253, 20, 15, 297, 428, 44, 18, 8, 492, 0, 36, 507, 32, 7, 552, 10, 0, 3, 147, 80, 125, 65, 6, 0, 115, 2}, 
  /* O M */ {322, 186, 3, 2, 520, 35, 0, 0, 323, 0, 0, 5, 294, 33, 93, 467, 0, 5, 179, 2, 10, 0, 3, 0, 49, 0}, 
  /* O N */ {596, 20, 271, 359, 823, 200, 351, 15, 709, 42, 36, 27, 30, 187, 249, 29, 27, 34, 3519, 530, 42, 147, 26, 2, 117, 18}, 
  /* O O */ {0, 11, 24, 380, 19, 90, 14, 9, 18, 0, 282, 190, 177, 259, 0, 117, 0, 102, 132, 286, 0, 17, 0, 0, 0, 36}, 
  /* O P */ {102, 0, 8, 0, 313, 4, 6, 205, 163, 2, 8, 66, 13, 0, 157, 216, 0, 69, 205, 65, 66, 0, 6, 0, 44, 0}, 
  /* O Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 0, 0}, 
  /* O R */ {472, 74, 130, 370, 634, 22, 164, 8, 613, 0, 238, 51, 377, 275, 190, 110, 7, 223, 904, 793, 38, 15, 36, 0, 192, 2}, 
  /* O S */ {78, 15, 87, 0, 391, 2, 2, 73, 321, 0, 3, 23, 42, 2, 49, 112, 7, 0, 288, 464, 39, 2, 6, 0, 33, 2}, 
  /* O T */ {155, 21, 52, 0, 299, 6, 8, 361, 274, 0, 2, 39, 6, 7, 186, 14, 0, 34, 265, 258, 33, 0, 5, 0, 35, 0}, 
  /* O U */ {17, 59, 82, 57, 15, 12, 184, 3, 33, 0, 3, 95, 5, 614, 0, 90, 3, 372, 1236, 626, 0, 16, 1, 4, 2, 2}, 
  /* O V */ {96, 0, 0, 0, 856, 0, 2, 0, 115, 0, 0, 0, 0, 2, 26, 0, 0, 0, 32, 0, 10, 0, 0, 0, 5, 0}, 
  /* O W */ {63, 44, 8, 63, 319, 8, 11, 16, 103, 0, 2, 120, 24, 305, 9, 30, 0, 10, 238, 20, 5, 0, 8, 0, 5, 6}, 
  /* O X */ {2, 3, 6, 0, 46, 6, 3, 6, 88, 0, 0, 0, 0, 1, 4, 0, 0, 0, 41, 5, 2, 2, 2, 0, 32, 2}, 
  /* O Y */ {78, 3, 11, 8, 48, 9, 0, 3, 21, 0, 0, 11, 13, 8, 18, 0, 0, 8, 80, 0, 2, 0, 0, 0, 0, 0}, 
  /* O Z */ {18, 0, 0, 0, 38, 0, 0, 2, 23, 0, 0, 4, 0, 4, 23, 0, 0, 0, 4, 0, 2, 0, 0, 0, 7, 9}}, 
  /* P A */ {{4, 28, 196, 54, 13, 0, 71, 10, 97, 1, 5, 228, 20, 309, 0, 83, 13, 687, 226, 391, 47, 21, 37, 4, 66, 3}, 
  /* P B */ {4, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 2, 0, 0, 22, 0, 0, 10, 1, 0, 6, 0, 0, 0, 0, 0}, 
  /* P C */ {3, 0, 0, 0, 0, 0, 0, 7, 2, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P D */ {11, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 8, 0, 0, 6, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* P E */ {180, 8, 257, 398, 99, 17, 22, 0, 9, 2, 17, 162, 5, 452, 23, 36, 2, 1427, 266, 226, 6, 3, 33, 3, 9, 11}, 
  /* P F */ {3, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 3, 0, 0, 6, 2, 0, 9, 0, 0, 0, 0, 0}, 
  /* P G */ {3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* P H */ {193, 0, 0, 1, 264, 0, 0, 0, 269, 0, 0, 17, 0, 2, 316, 0, 0, 53, 68, 19, 11, 0, 0, 0, 149, 0}, 
  /* P I */ {79, 0, 209, 78, 244, 12, 65, 0, 1, 0, 21, 158, 23, 594, 33, 52, 8, 153, 112, 229, 10, 6, 0, 7, 0, 15}, 
  /* P J */ {3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* P K */ {0, 0, 0, 0, 7, 0, 0, 0, 13, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, 
  /* P L */ {562, 0, 0, 0, 428, 0, 0, 0, 319, 0, 0, 0, 0, 0, 170, 0, 0, 0, 0, 0, 134, 0, 0, 0, 42, 0}, 
  /* P M */ {16, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0}, 
  /* P N */ {0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P O */ {8, 0, 64, 37, 32, 0, 30, 0, 145, 0, 43, 384, 53, 187, 123, 101, 0, 414, 477, 195, 83, 17, 59, 16, 2, 2}, 
  /* P P */ {63, 0, 0, 0, 434, 0, 0, 5, 231, 0, 0, 147, 2, 0, 129, 0, 0, 135, 9, 0, 12, 0, 0, 0, 31, 0}, 
  /* P Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P R */ {171, 0, 4, 0, 936, 0, 0, 0, 470, 0, 0, 0, 0, 0, 1116, 0, 0, 0, 1, 2, 49, 0, 0, 0, 10, 0}, 
  /* P S */ {23, 2, 11, 0, 63, 1, 0, 25, 66, 0, 6, 0, 0, 0, 31, 0, 3, 0, 20, 47, 24, 0, 3, 0, 85, 0}, 
  /* P T */ {53, 0, 3, 0, 73, 0, 0, 3, 306, 0, 0, 6, 2, 12, 89, 0, 0, 8, 51, 0, 79, 0, 3, 0, 6, 0}, 
  /* P U */ {0, 50, 23, 27, 12, 16, 23, 0, 0, 0, 4, 208, 31, 111, 0, 26, 0, 200, 94, 153, 0, 0, 0, 0, 0, 11}, 
  /* P V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P W */ {13, 0, 0, 0, 2, 0, 0, 0, 5, 0, 0, 0, 0, 0, 1, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* P Y */ {3, 0, 7, 0, 0, 0, 11, 3, 10, 0, 0, 7, 2, 2, 6, 0, 0, 34, 25, 9, 0, 0, 3, 5, 0, 0}, 
  /* P Z */ {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* Q A */ {{0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0}, 
  /* Q B */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q C */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q D */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q E */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q F */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q H */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q I */ {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q K */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q L */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q M */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q N */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q O */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q P */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q R */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q S */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q T */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q U */ {405, 1, 0, 1, 466, 0, 0, 2, 529, 0, 0, 0, 2, 0, 56, 0, 0, 0, 3, 0, 2, 0, 0, 0, 7, 0}, 
  /* Q V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q W */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q Y */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Q Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* R A */ {{0, 232, 643, 304, 24, 139, 298, 46, 388, 17, 61, 398, 399, 1173, 12, 507, 9, 84, 463, 1393, 62, 212, 128, 9, 147, 62}, 
  /* R B */ {134, 0, 0, 0, 112, 0, 0, 0, 126, 0, 0, 27, 0, 0, 147, 0, 0, 36, 29, 0, 43, 0, 0, 0, 10, 0}, 
  /* R C */ {72, 0, 0, 0, 195, 0, 0, 347, 102, 0, 8, 43, 0, 0, 96, 0, 0, 15, 4, 13, 124, 0, 0, 0, 17, 0}, 
  /* R D */ {65, 11, 6, 0, 217, 3, 0, 14, 264, 0, 0, 45, 5, 19, 76, 4, 0, 51, 462, 11, 22, 3, 10, 0, 12, 0}, 
  /* R E */ {894, 122, 670, 1068, 475, 310, 253, 113, 125, 38, 19, 349, 314, 570, 103, 409, 49, 259, 1844, 548, 41, 272, 147, 27, 74, 14}, 
  /* R F */ {33, 5, 0, 2, 73, 2, 0, 0, 46, 0, 0, 14, 0, 0, 43, 0, 0, 7, 17, 0, 51, 0, 0, 0, 1, 0}, 
  /* R G */ {124, 0, 0, 0, 271, 0, 0, 17, 118, 0, 0, 40, 2, 3, 58, 0, 0, 36, 57, 0, 32, 0, 0, 0, 24, 0}, 
  /* R H */ {39, 0, 0, 0, 74, 0, 0, 0, 23, 0, 0, 0, 0, 0, 67, 0, 0, 0, 4, 0, 5, 0, 0, 0, 13, 2}, 
  /* R I */ {623, 193, 676, 260, 800, 164, 269, 5, 1, 2, 34, 211, 248, 1446, 262, 232, 13, 2, 631, 585, 88, 175, 9, 20, 6, 293}, 
  /* R J */ {12, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0}, 
  /* R K */ {31, 6, 0, 6, 141, 2, 0, 14, 82, 0, 0, 21, 11, 9, 6, 4, 0, 5, 192, 2, 5, 0, 9, 0, 7, 0}, 
  /* R L */ {103, 4, 0, 17, 151, 3, 0, 3, 190, 0, 0, 0, 0, 0, 89, 5, 0, 0, 44, 2, 8, 0, 3, 0, 82, 0}, 
  /* R M */ {343, 3, 3, 0, 195, 7, 0, 11, 280, 0, 0, 17, 0, 2, 149, 3, 0, 3, 119, 2, 44, 0, 4, 0, 11, 0}, 
  /* R N */ {213, 10, 6, 0, 302, 11, 0, 6, 196, 0, 3, 5, 20, 3, 66, 6, 0, 5, 167, 10, 24, 0, 4, 0, 8, 0}, 
  /* R O */ {175, 185, 287, 176, 49, 126, 196, 18, 94, 22, 63, 285, 258, 552, 328, 402, 14, 57, 530, 307, 474, 199, 317, 34, 50, 13}, 
  /* R P */ {51, 0, 0, 0, 109, 0, 0, 52, 55, 0, 0, 46, 3, 2, 92, 0, 0, 70, 34, 7, 20, 0, 0, 0, 2, 0}, 
  /* R Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0}, 
  /* R R */ {232, 0, 0, 0, 375, 0, 0, 25, 375, 0, 0, 0, 0, 0, 220, 0, 0, 0, 14, 0, 64, 0, 0, 0, 139, 0}, 
  /* R S */ {81, 3, 19, 3, 351, 2, 0, 141, 196, 0, 20, 6, 9, 12, 119, 48, 1, 2, 20, 157, 41, 2, 8, 0, 6, 0}, 
  /* R T */ {207, 16, 17, 0, 356, 14, 16, 321, 510, 0, 2, 70, 41, 34, 99, 0, 0, 44, 282, 5, 104, 0, 24, 0, 39, 17}, 
  /* R U */ {24, 119, 168, 126, 56, 39, 50, 2, 98, 2, 2, 49, 214, 167, 3, 110, 0, 7, 358, 70, 0, 2, 3, 9, 2, 6}, 
  /* R V */ {100, 0, 0, 0, 160, 0, 0, 0, 128, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0}, 
  /* R W */ {54, 0, 0, 0, 31, 0, 0, 11, 21, 0, 0, 0, 0, 0, 49, 0, 0, 13, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* R X */ {0, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* R Y */ {30, 12, 9, 9, 18, 0, 2, 0, 43, 0, 4, 31, 34, 26, 21, 26, 0, 0, 446, 7, 2, 0, 14, 0, 0, 0}, 
  /* R Z */ {6, 0, 0, 0, 11, 0, 0, 2, 3, 0, 2, 2, 0, 0, 3, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0}}, 
  /* S A */ {{8, 83, 98, 82, 2, 51, 88, 6, 89, 2, 38, 337, 83, 334, 0, 75, 0, 165, 118, 174, 85, 76, 56, 14, 41, 2}, 
  /* S B */ {33, 0, 0, 0, 31, 0, 0, 0, 8, 0, 0, 0, 0, 0, 31, 0, 0, 8, 1, 0, 36, 0, 0, 0, 12, 0}, 
  /* S C */ {399, 0, 0, 0, 223, 0, 0, 280, 148, 0, 0, 34, 0, 0, 439, 0, 0, 369, 6, 0, 162, 0, 0, 0, 10, 0}, 
  /* S D */ {32, 0, 0, 0, 17, 0, 0, 0, 15, 0, 0, 0, 0, 0, 9, 0, 0, 7, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* S E */ {179, 36, 216, 406, 123, 26, 37, 25, 40, 2, 7, 293, 228, 435, 11, 94, 49, 517, 1064, 173, 34, 52, 49, 67, 67, 0}, 
  /* S F */ {15, 0, 0, 0, 15, 0, 0, 0, 40, 0, 0, 1, 0, 0, 14, 0, 0, 6, 0, 0, 31, 0, 0, 0, 5, 0}, 
  /* S G */ {2, 0, 0, 0, 2, 0, 0, 0, 11, 0, 0, 0, 0, 0, 12, 0, 0, 20, 0, 1, 18, 0, 0, 0, 0, 0}, 
  /* S H */ {441, 28, 21, 5, 682, 6, 2, 5, 653, 0, 15, 45, 72, 64, 402, 3, 0, 126, 118, 22, 88, 4, 27, 0, 31, 0}, 
  /* S I */ {172, 119, 163, 257, 238, 70, 187, 4, 0, 0, 11, 168, 129, 686, 525, 30, 3, 40, 260, 345, 25, 214, 0, 18, 0, 77}, 
  /* S J */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0}, 
  /* S K */ {36, 0, 0, 0, 111, 0, 0, 0, 212, 1, 0, 1, 6, 2, 5, 0, 0, 5, 60, 2, 25, 0, 0, 0, 102, 0}, 
  /* S L */ {212, 0, 0, 0, 173, 0, 0, 0, 175, 0, 0, 0, 0, 0, 124, 0, 0, 0, 0, 0, 72, 0, 0, 0, 304, 0}, 
  /* S M */ {218, 0, 0, 0, 94, 0, 0, 0, 111, 0, 0, 0, 0, 0, 116, 0, 0, 3, 329, 0, 47, 0, 0, 0, 0, 0}, 
  /* S N */ {96, 0, 0, 0, 301, 0, 0, 0, 71, 0, 0, 0, 0, 0, 136, 0, 0, 0, 1, 4, 30, 0, 0, 0, 2, 0}, 
  /* S O */ {27, 33, 94, 35, 10, 34, 11, 5, 23, 5, 2, 268, 156, 498, 35, 70, 0, 245, 30, 33, 156, 16, 13, 2, 9, 1}, 
  /* S P */ {264, 3, 0, 0, 450, 0, 0, 87, 348, 0, 0, 120, 0, 2, 313, 0, 0, 179, 22, 0, 66, 0, 0, 0, 11, 0}, 
  /* S Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 250, 0, 0, 0, 0, 0}, 
  /* S R */ {15, 0, 0, 0, 31, 0, 0, 0, 4, 0, 0, 0, 0, 0, 11, 0, 0, 0, 2, 0, 12, 0, 0, 0, 0, 0}, 
  /* S S */ {236, 27, 8, 0, 672, 16, 0, 12, 732, 0, 3, 72, 36, 97, 171, 20, 0, 9, 935, 23, 90, 0, 23, 0, 37, 0}, 
  /* S T */ {1085, 29, 15, 7, 1399, 29, 3, 71, 1183, 0, 0, 158, 47, 22, 659, 20, 0, 1091, 949, 0, 242, 0, 34, 0, 114, 0}, 
  /* S U */ {63, 332, 84, 17, 38, 58, 26, 4, 59, 0, 9, 126, 134, 135, 3, 244, 0, 358, 109, 12, 0, 4, 2, 0, 0, 12}, 
  /* S V */ {6, 0, 0, 0, 16, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* S W */ {153, 0, 0, 0, 136, 0, 0, 0, 108, 0, 0, 0, 0, 0, 71, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* S X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* S Y */ {0, 9, 73, 2, 0, 4, 3, 0, 9, 0, 2, 48, 56, 97, 0, 14, 0, 21, 62, 3, 0, 0, 2, 0, 0, 0}, 
  /* S Z */ {0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 2, 0}}, 
  /* T A */ {{2, 322, 178, 37, 18, 31, 195, 21, 311, 1, 97, 550, 165, 645, 9, 88, 0, 466, 265, 702, 47, 26, 32, 47, 19, 0}, 
  /* T B */ {50, 0, 0, 0, 15, 0, 0, 0, 17, 0, 0, 3, 0, 0, 29, 0, 0, 26, 0, 0, 13, 0, 0, 0, 0, 0}, 
  /* T C */ {36, 0, 0, 0, 3, 0, 0, 494, 1, 0, 0, 10, 0, 0, 21, 0, 0, 12, 1, 0, 7, 0, 0, 0, 2, 0}, 
  /* T D */ {5, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 20, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* T E */ {211, 34, 129, 1606, 240, 46, 51, 15, 52, 0, 0, 358, 195, 786, 41, 91, 3, 2976, 1469, 57, 32, 19, 30, 47, 5, 3}, 
  /* T F */ {15, 0, 0, 0, 2, 0, 0, 0, 30, 0, 0, 4, 0, 0, 24, 0, 0, 0, 0, 0, 94, 0, 0, 0, 0, 0}, 
  /* T G */ {15, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 11, 2, 0, 7, 0, 0, 0, 0, 0}, 
  /* T H */ {198, 16, 1, 11, 902, 33, 2, 7, 336, 0, 2, 61, 33, 13, 349, 15, 5, 268, 339, 8, 105, 0, 50, 0, 76, 0}, 
  /* T I */ {299, 80, 1119, 65, 547, 237, 129, 8, 0, 2, 11, 304, 299, 2253, 3497, 109, 29, 86, 392, 277, 22, 588, 1, 0, 0, 132}, 
  /* T J */ {8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* T K */ {2, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* T L */ {57, 0, 0, 0, 439, 0, 0, 0, 132, 0, 0, 1, 0, 0, 17, 0, 0, 0, 6, 0, 6, 0, 0, 0, 249, 0}, 
  /* T M */ {78, 0, 0, 0, 115, 0, 0, 0, 8, 0, 0, 0, 0, 0, 24, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0}, 
  /* T N */ {17, 0, 0, 0, 169, 0, 0, 0, 14, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 1, 7, 0, 0, 0, 0, 0}, 
  /* T O */ {35, 26, 117, 32, 40, 20, 69, 0, 59, 7, 37, 134, 209, 636, 112, 186, 3, 1214, 186, 64, 140, 17, 122, 38, 18, 10}, 
  /* T P */ {12, 0, 0, 0, 9, 0, 0, 2, 9, 0, 0, 11, 0, 0, 17, 0, 0, 11, 0, 0, 5, 0, 0, 0, 0, 0}, 
  /* T Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* T R */ {1299, 0, 0, 0, 433, 0, 0, 0, 891, 0, 2, 0, 1, 0, 579, 0, 0, 0, 1, 0, 391, 0, 0, 0, 144, 0}, 
  /* T S */ {11, 6, 16, 4, 22, 0, 0, 36, 36, 0, 26, 3, 34, 0, 17, 7, 0, 0, 17, 44, 19, 2, 16, 0, 13, 0}, 
  /* T T */ {145, 0, 0, 0, 801, 0, 4, 10, 357, 0, 0, 169, 2, 2, 153, 0, 0, 39, 74, 0, 10, 2, 2, 0, 50, 0}, 
  /* T U */ {182, 65, 33, 117, 19, 24, 13, 0, 23, 0, 0, 73, 113, 119, 41, 49, 0, 655, 137, 91, 0, 1, 0, 6, 2, 2}, 
  /* T V */ {2, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* T W */ {65, 0, 0, 0, 56, 0, 0, 6, 91, 0, 0, 0, 0, 2, 44, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* T X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* T Y */ {3, 0, 8, 3, 5, 0, 1, 1, 14, 0, 3, 53, 17, 4, 0, 108, 0, 48, 606, 3, 0, 0, 0, 2, 0, 0}, 
  /* T Z */ {11, 0, 0, 0, 40, 0, 2, 0, 20, 0, 2, 0, 2, 0, 7, 4, 0, 2, 38, 0, 0, 0, 0, 0, 5, 0}}, 
  /* U A */ {{1, 18, 27, 81, 1, 6, 20, 6, 21, 0, 14, 257, 7, 95, 0, 5, 0, 192, 46, 185, 5, 16, 10, 0, 19, 0}, 
  /* U B */ {51, 140, 28, 14, 74, 3, 3, 13, 76, 24, 0, 123, 32, 1, 20, 10, 0, 32, 141, 58, 18, 8, 3, 0, 5, 0}, 
  /* U C */ {52, 0, 69, 0, 92, 0, 0, 142, 115, 0, 295, 15, 0, 0, 14, 0, 0, 22, 2, 238, 21, 0, 0, 0, 5, 0}, 
  /* U D */ {45, 3, 0, 92, 234, 0, 120, 4, 174, 0, 0, 10, 4, 2, 21, 0, 0, 10, 67, 0, 7, 0, 4, 0, 17, 3}, 
  /* U E */ {35, 24, 2, 59, 41, 14, 4, 2, 9, 5, 0, 107, 5, 125, 1, 5, 0, 101, 277, 85, 11, 3, 0, 0, 3, 22}, 
  /* U F */ {11, 0, 0, 0, 2, 287, 0, 0, 4, 0, 0, 12, 2, 0, 4, 0, 0, 0, 0, 12, 4, 0, 0, 0, 0, 0}, 
  /* U G */ {71, 8, 0, 0, 56, 0, 131, 250, 14, 0, 0, 21, 7, 13, 17, 0, 0, 0, 53, 0, 53, 0, 0, 0, 0, 0}, 
  /* U H */ {20, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 2, 0, 0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* U I */ {14, 13, 49, 60, 45, 3, 11, 0, 0, 2, 2, 124, 0, 162, 5, 18, 0, 81, 188, 233, 3, 23, 0, 5, 1, 16}, 
  /* U J */ {9, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 7, 0, 0, 0, 0, 0}, 
  /* U K */ {7, 0, 2, 0, 41, 0, 0, 4, 12, 0, 10, 3, 0, 0, 9, 0, 0, 5, 10, 4, 6, 0, 0, 0, 3, 0}, 
  /* U L */ {587, 16, 56, 34, 183, 39, 65, 0, 118, 0, 43, 426, 19, 109, 56, 47, 0, 5, 160, 293, 34, 13, 3, 0, 10, 2}, 
  /* U M */ {105, 287, 7, 7, 157, 12, 0, 0, 121, 0, 0, 10, 162, 37, 31, 210, 4, 2, 325, 2, 26, 10, 0, 0, 1, 0}, 
  /* U N */ {123, 91, 448, 812, 138, 86, 199, 44, 283, 10, 170, 58, 37, 129, 31, 59, 11, 85, 236, 451, 13, 8, 49, 0, 6, 6}, 
  /* U O */ {0, 0, 0, 5, 0, 2, 0, 0, 15, 0, 4, 0, 2, 2, 0, 0, 0, 41, 10, 31, 87, 0, 0, 0, 11, 0}, 
  /* U P */ {20, 13, 9, 11, 216, 4, 4, 39, 58, 2, 2, 59, 1, 0, 22, 145, 0, 29, 121, 89, 15, 0, 3, 0, 9, 0}, 
  /* U Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0}, 
  /* U R */ {286, 116, 74, 84, 652, 48, 197, 3, 393, 0, 40, 88, 45, 247, 78, 74, 5, 192, 274, 164, 35, 47, 0, 0, 52, 2}, 
  /* U S */ {77, 15, 78, 2, 554, 0, 0, 234, 264, 0, 65, 244, 2, 171, 12, 39, 8, 0, 480, 529, 19, 0, 0, 0, 13, 0}, 
  /* U T */ {122, 28, 55, 15, 287, 22, 13, 204, 347, 0, 0, 59, 26, 14, 125, 23, 0, 89, 268, 237, 45, 4, 16, 0, 7, 15}, 
  /* U U */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 2, 11, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* U V */ {9, 0, 0, 0, 36, 0, 0, 0, 18, 0, 0, 0, 0, 0, 4, 0, 0, 7, 2, 0, 6, 0, 0, 0, 0, 0}, 
  /* U W */ {10, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* U X */ {0, 0, 0, 0, 14, 0, 0, 0, 5, 0, 0, 2, 0, 0, 3, 0, 0, 0, 15, 9, 15, 0, 0, 0, 0, 0}, 
  /* U Y */ {3, 0, 0, 0, 7, 0, 2, 2, 2, 0, 0, 4, 0, 0, 2, 0, 0, 1, 7, 2, 2, 2, 0, 0, 0, 0}, 
  /* U Z */ {5, 3, 2, 0, 13, 0, 0, 6, 4, 0, 0, 0, 2, 6, 6, 0, 0, 0, 9, 0, 4, 0, 0, 0, 3, 56}}, 
  /* V A */ {{4, 34, 65, 33, 5, 0, 71, 6, 28, 3, 10, 284, 18, 213, 2, 24, 0, 122, 127, 195, 21, 0, 0, 0, 0, 2}, 
  /* V B */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V C */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V D */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V E */ {25, 6, 11, 143, 12, 2, 25, 10, 30, 0, 2, 409, 30, 572, 0, 5, 0, 1398, 517, 79, 0, 0, 3, 14, 36, 2}, 
  /* V F */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V H */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V I */ {140, 25, 135, 109, 131, 10, 49, 0, 0, 6, 8, 180, 2, 314, 95, 5, 0, 78, 271, 183, 5, 61, 0, 7, 0, 10}, 
  /* V J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V K */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V L */ {9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* V M */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V N */ {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V O */ {0, 0, 82, 2, 1, 0, 11, 0, 40, 0, 23, 151, 7, 23, 6, 0, 0, 100, 17, 43, 43, 2, 23, 0, 32, 0}, 
  /* V P */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V R */ {2, 0, 0, 0, 7, 0, 0, 0, 1, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V S */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* V T */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* V U */ {0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 73, 2, 1, 2, 0, 0, 6, 4, 2, 0, 0, 0, 0, 0, 0}, 
  /* V V */ {0, 0, 0, 0, 1, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0}, 
  /* V W */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* V Y */ {0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 3, 0, 0, 0}, 
  /* V Z */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* W A */ {{0, 14, 16, 40, 0, 14, 55, 5, 96, 0, 38, 209, 20, 110, 0, 7, 0, 378, 139, 189, 8, 31, 6, 21, 221, 4}, 
  /* W B */ {19, 0, 0, 0, 14, 0, 0, 0, 6, 0, 0, 0, 0, 0, 28, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W C */ {10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W D */ {3, 0, 0, 0, 19, 0, 0, 0, 22, 0, 0, 13, 0, 4, 7, 0, 0, 17, 3, 0, 5, 0, 0, 0, 7, 0}, 
  /* W E */ {152, 20, 0, 141, 169, 5, 3, 4, 100, 0, 0, 208, 0, 42, 0, 5, 0, 229, 102, 21, 0, 2, 0, 0, 4, 2}, 
  /* W F */ {4, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 3, 0, 0, 5, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0}, 
  /* W G */ {3, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* W H */ {55, 0, 0, 0, 135, 0, 0, 0, 225, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* W I */ {0, 0, 43, 33, 38, 28, 61, 0, 0, 0, 0, 161, 25, 455, 0, 16, 0, 38, 107, 138, 0, 15, 0, 1, 2, 6}, 
  /* W J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W K */ {0, 0, 0, 0, 9, 0, 0, 0, 17, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 0, 0, 0, 6, 0, 1, 0}, 
  /* W L */ {11, 0, 0, 0, 66, 0, 0, 0, 29, 0, 0, 0, 0, 0, 2, 0, 0, 0, 47, 0, 0, 0, 0, 0, 8, 0}, 
  /* W M */ {19, 0, 0, 0, 8, 0, 0, 0, 3, 0, 0, 0, 0, 0, 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* W N */ {2, 6, 1, 0, 56, 3, 6, 5, 48, 0, 0, 4, 0, 0, 3, 7, 0, 1, 132, 8, 3, 0, 3, 0, 9, 0}, 
  /* W O */ {0, 10, 0, 2, 8, 7, 6, 0, 0, 0, 7, 36, 111, 28, 204, 5, 0, 395, 6, 3, 15, 5, 9, 0, 0, 4}, 
  /* W P */ {9, 0, 0, 0, 2, 0, 0, 2, 5, 0, 0, 8, 0, 0, 13, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* W Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W R */ {37, 0, 0, 0, 60, 0, 0, 0, 127, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 1}, 
  /* W S */ {1, 3, 7, 0, 18, 1, 0, 11, 16, 0, 4, 6, 3, 0, 7, 16, 0, 3, 8, 13, 5, 0, 5, 0, 3, 0}, 
  /* W T */ {3, 0, 0, 0, 3, 0, 0, 15, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, 
  /* W U */ {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 1, 1, 0, 3, 0, 10, 3, 0, 0, 0, 0, 0, 0, 0}, 
  /* W V */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W W */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W Y */ {4, 0, 4, 0, 10, 0, 0, 0, 0, 0, 0, 2, 0, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* W Z */ {0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}}, 
  /* X A */ {{0, 3, 23, 1, 0, 0, 16, 0, 0, 0, 0, 6, 28, 16, 0, 0, 0, 2, 8, 24, 0, 2, 0, 0, 0, 0}, 
  /* X B */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X C */ {15, 0, 0, 0, 40, 0, 0, 8, 23, 0, 0, 21, 0, 0, 17, 0, 0, 17, 0, 0, 14, 0, 0, 0, 0, 0}, 
  /* X D */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X E */ {0, 0, 29, 50, 0, 0, 3, 0, 2, 0, 0, 3, 27, 19, 0, 0, 0, 40, 109, 0, 0, 0, 0, 0, 0, 0}, 
  /* X F */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X G */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X H */ {18, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0}, 
  /* X I */ {17, 8, 43, 27, 29, 6, 9, 0, 1, 0, 0, 12, 29, 64, 25, 0, 0, 3, 49, 23, 0, 3, 0, 0, 0, 0}, 
  /* X J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X K */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X L */ {0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, 
  /* X M */ {3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X N */ {1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X O */ {0, 0, 4, 5, 0, 0, 0, 0, 0, 0, 0, 3, 3, 25, 0, 6, 0, 20, 1, 8, 0, 0, 0, 0, 0, 0}, 
  /* X P */ {30, 0, 0, 0, 96, 0, 0, 0, 14, 0, 0, 62, 0, 0, 54, 0, 0, 29, 0, 0, 15, 0, 0, 0, 0, 0}, 
  /* X Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* X R */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X S */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0}, 
  /* X T */ {13, 3, 0, 0, 72, 0, 0, 2, 30, 0, 0, 0, 0, 0, 22, 0, 0, 91, 6, 0, 16, 0, 0, 0, 2, 0}, 
  /* X U */ {23, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 8, 2, 0, 0, 0, 0, 15, 10, 0, 0, 0, 0, 0, 0, 2}, 
  /* X V */ {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X W */ {0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* X Y */ {2, 0, 2, 0, 1, 0, 9, 0, 2, 0, 0, 7, 4, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0}, 
  /* X Z */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}, 
  /* Y A */ {{0, 10, 25, 9, 0, 0, 12, 9, 0, 0, 18, 55, 16, 105, 3, 6, 4, 76, 33, 15, 0, 0, 16, 0, 0, 0}, 
  /* Y B */ {23, 0, 0, 4, 32, 0, 0, 0, 9, 0, 0, 2, 0, 0, 26, 0, 0, 9, 3, 0, 9, 0, 0, 0, 3, 0}, 
  /* Y C */ {16, 0, 0, 0, 38, 0, 0, 77, 4, 0, 2, 77, 0, 0, 34, 0, 0, 1, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* Y D */ {13, 2, 0, 0, 28, 0, 0, 0, 17, 0, 0, 0, 0, 4, 1, 0, 0, 78, 4, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y E */ {37, 8, 0, 92, 6, 5, 3, 0, 1, 0, 2, 41, 4, 20, 3, 5, 0, 112, 74, 17, 8, 8, 6, 0, 1, 0}, 
  /* Y F */ {7, 0, 0, 0, 1, 0, 0, 0, 9, 0, 0, 8, 0, 0, 4, 0, 0, 3, 0, 0, 15, 0, 0, 0, 0, 0}, 
  /* Y G */ {10, 0, 0, 0, 12, 0, 2, 0, 13, 0, 0, 5, 8, 5, 14, 0, 0, 11, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* Y H */ {0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 2, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* Y I */ {0, 0, 0, 2, 8, 0, 0, 0, 0, 0, 2, 0, 0, 355, 0, 6, 0, 0, 19, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y J */ {7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y K */ {0, 0, 0, 0, 10, 0, 0, 0, 2, 2, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y L */ {39, 0, 0, 0, 62, 0, 0, 0, 39, 0, 2, 47, 0, 0, 37, 3, 0, 0, 18, 0, 10, 13, 0, 0, 8, 0}, 
  /* Y M */ {63, 22, 0, 0, 64, 0, 0, 0, 16, 0, 0, 0, 11, 24, 36, 59, 0, 0, 13, 0, 7, 0, 0, 0, 2, 0}, 
  /* Y N */ {47, 2, 39, 17, 61, 0, 7, 0, 11, 0, 0, 0, 2, 12, 25, 0, 0, 0, 23, 27, 0, 0, 0, 9, 2, 0}, 
  /* Y O */ {0, 0, 0, 15, 0, 8, 13, 0, 0, 0, 14, 14, 5, 48, 0, 4, 0, 32, 11, 13, 45, 6, 4, 0, 0, 0}, 
  /* Y P */ {10, 0, 0, 0, 107, 0, 0, 46, 22, 0, 0, 3, 0, 15, 56, 2, 0, 13, 18, 35, 7, 0, 0, 0, 0, 0}, 
  /* Y Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* Y R */ {46, 0, 0, 8, 27, 0, 1, 0, 57, 0, 0, 0, 0, 2, 47, 0, 0, 3, 8, 7, 10, 0, 0, 0, 3, 0}, 
  /* Y S */ {15, 2, 3, 0, 25, 4, 0, 8, 85, 0, 0, 8, 12, 0, 18, 9, 0, 0, 23, 124, 5, 0, 2, 0, 4, 0}, 
  /* Y T */ {5, 0, 0, 0, 44, 0, 0, 59, 16, 0, 0, 0, 0, 0, 11, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0}, 
  /* Y U */ {4, 2, 11, 0, 0, 0, 12, 0, 2, 0, 8, 9, 4, 6, 0, 5, 0, 4, 8, 2, 0, 0, 0, 0, 0, 2}, 
  /* Y V */ {2, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y W */ {32, 0, 0, 0, 14, 0, 0, 6, 4, 0, 0, 0, 0, 0, 31, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y X */ {0, 0, 0, 0, 5, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0}, 
  /* Y Y */ {4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, 
  /* Y Z */ {4, 0, 0, 0, 16, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}}, 
  /* Z A */ {{7, 11, 11, 2, 0, 0, 7, 2, 4, 0, 8, 13, 19, 49, 0, 12, 0, 71, 32, 219, 0, 2, 0, 0, 0, 4}, 
  /* Z B */ {0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, 
  /* Z C */ {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z D */ {2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z E */ {13, 19, 11, 302, 5, 9, 2, 0, 0, 0, 6, 26, 8, 50, 0, 12, 0, 143, 326, 20, 2, 0, 0, 0, 0, 2}, 
  /* Z F */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z G */ {0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z H */ {0, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 0, 2, 10, 0, 0, 0, 1, 0, 3, 0, 0, 0, 2, 0}, 
  /* Z I */ {2, 4, 5, 0, 88, 0, 9, 0, 2, 0, 0, 28, 11, 342, 9, 20, 0, 5, 10, 5, 0, 0, 0, 0, 0, 0}, 
  /* Z J */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z K */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0}, 
  /* Z L */ {0, 0, 0, 0, 58, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 0}, 
  /* Z M */ {8, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z N */ {2, 0, 0, 0, 6, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z O */ {5, 0, 0, 6, 3, 0, 0, 2, 16, 0, 0, 11, 8, 42, 24, 4, 0, 17, 22, 4, 2, 6, 0, 0, 0, 0}, 
  /* Z P */ {6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z Q */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0}, 
  /* Z R */ {2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z S */ {0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, 
  /* Z T */ {0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z U */ {0, 4, 3, 0, 6, 0, 0, 0, 0, 0, 4, 3, 3, 3, 0, 0, 0, 9, 3, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z V */ {2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z W */ {0, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z X */ {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
  /* Z Y */ {0, 4, 0, 0, 0, 0, 3, 0, 2, 0, 0, 0, 7, 0, 0, 0, 0, 2, 6, 0, 2, 0, 0, 0, 0, 0}, 
  /* Z Z */ {29, 1, 0, 0, 32, 0, 0, 0, 48, 0, 0, 75, 0, 0, 4, 0, 0, 0, 3, 0, 0, 0, 2, 0, 12, 0}}};
  /* END   INCLUDE FILE .. trigram.h */
