/*
 * Copyright (c) 2003-2016 Rony Shapiro <ronys@pwsafe.org>.
 * All rights reserved. Use of the code is allowed under the
 * Artistic License 2.0 terms, as specified in the LICENSE file
 * distributed with this code, or available from
 * http://www.opensource.org/licenses/artistic-license-2.0.php
 */

#ifndef _VERSION_H_
#define _VERSION_H_

// version.h will be automatically generated from version.in via cmake
// Until we get cmake configuration working under Windows,
// we'll use the old format:

// Format: Major, Minor, Build, Revision
//   Build  = 0 for all Formally Released versions
//   Build != 0 for all Intermediate versions
// Full information shown in AboutBox; only Major & Minor are displayed in initial dialog

#ifdef CMAKE_ON_WINDOWS
#define PRODUCTVER     @pwsafe_VERSION_MAJOR@, @pwsafe_VERSION_MINOR@, @pwsafe_REVISION@
#define STRPRODUCTVER  "@pwsafe_VERSION_MAJOR@, @pwsafe_VERSION_MINOR@, @pwsafe_REVISION@, gf70a7dc\0"
#define SPECIAL_BUILD L"@pwsafe_SPECIALBUILD@"
#else
#define PRODUCTVER     3, 38, 2
#define STRPRODUCTVER  "3, 38, 2, gf70a7dc\0"
#define SPECIAL_BUILD L""
#endif /* CMAKE_ON_WINDOWS */
#define FILEVER        PRODUCTVER
#define STRFILEVER     STRPRODUCTVER

#endif // _VERSION_H_
