/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPatchCommand
extends SVNCommand {
    public SVNPatchCommand() {
        super("patch", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.DRY_RUN);
        options.add(SVNOption.ACCEPT);
        options.add(SVNOption.DIFF3_CMD);
        options.add(SVNOption.STRIP);
        options.add(SVNOption.REVERSE_DIFF);
        options.add(SVNOption.IGNORE_WHITESPACE);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        int targetsCount = targets.size();
        if (targetsCount < 1 || targetsCount > 2) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
        SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(printer);
        }
        File patchPath = new File(targets.get(0));
        File targetPath = new File(targetsCount != 2 ? "." : targets.get(1));
        try {
            client.doPatch(patchPath.getAbsoluteFile(), targetPath.getAbsoluteFile(), this.getSVNEnvironment().isDryRun(), this.getSVNEnvironment().getStripCount(), this.getSVNEnvironment().isIgnoreWhitespace(), true, this.getSVNEnvironment().isReverseDiff());
        }
        catch (SVNException e) {
            this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.ENTRY_EXISTS, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
        }
        finally {
            if (!this.getSVNEnvironment().isQuiet()) {
                StringBuffer status = new StringBuffer();
                printer.printConflictStatus(status);
                this.getSVNEnvironment().getOut().print(status);
            }
        }
    }
}

