/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.util.Version;
import org.xml.sax.helpers.DefaultHandler;

class HTTPRequest {
    public static final char[] CRLF = new char[]{'\r', '\n'};
    private boolean myIsSecured;
    private boolean myIsProxied;
    private HTTPConnection myConnection;
    private String myAuthentication;
    private String myProxyAuthentication;
    private HTTPHeader myResponseHeader;
    private HTTPStatus myStatus;
    private SVNErrorMessage myErrorMessage;
    private DefaultHandler myResponseHandler;
    private OutputStream myResponseStream;
    private byte[] myRequestBody;
    private InputStream myRequestStream;
    private boolean myIsProxyAuthForced;
    private boolean myIsKeepAlive;
    private String myCharset;
    private long myTimeout;
    private Map<String, List<String>> myCookieHeaders;

    public HTTPRequest(String charset) {
        this.myCharset = charset;
    }

    public void reset() {
        if (this.myRequestStream != null) {
            try {
                this.myRequestStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myAuthentication = null;
        this.myProxyAuthentication = null;
        this.myResponseHeader = null;
        this.myStatus = null;
        this.myErrorMessage = null;
    }

    public void setProxied(boolean proxied) {
        this.myIsProxied = proxied;
    }

    public void setSecured(boolean secured) {
        this.myIsSecured = secured;
    }

    public void setConnection(HTTPConnection connection) {
        this.myConnection = connection;
    }

    public void initCredentials(HTTPAuthentication authentication, String method, String path) {
        if (authentication != null) {
            authentication.setChallengeParameter("method", method);
            authentication.setChallengeParameter("uri", this.composeRequestURI(method, path));
            authentication.setChallengeParameter("host", this.myConnection.getHost().getHost());
        }
    }

    public void setAuthentication(String auth) {
        this.myAuthentication = auth;
    }

    public void setProxyAuthentication(String auth) {
        this.myProxyAuthentication = auth;
    }

    public void setForceProxyAuth(boolean force) {
        this.myIsProxyAuthForced = force;
    }

    public void setResponseHandler(DefaultHandler handler) {
        this.myResponseHandler = handler;
    }

    public void setResponseStream(OutputStream os) {
        this.myResponseStream = os;
    }

    public void setRequestBody(byte[] body) {
        this.myRequestBody = body;
    }

    public void setRequestBody(StringBuffer sb) {
        try {
            this.myRequestBody = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.myRequestBody = sb.toString().getBytes();
        }
    }

    public void setRequestBody(InputStream is) {
        this.myRequestStream = is;
    }

    public void dispatch(String request, String path, HTTPHeader header, int ok1, int ok2, SVNErrorMessage context) throws IOException {
        long length = 0L;
        if (this.myRequestBody != null) {
            length = this.myRequestBody.length;
        } else if (this.myRequestStream instanceof ByteArrayInputStream) {
            length = ((ByteArrayInputStream)this.myRequestStream).available();
        } else if (header != null && header.hasHeader("Content-Length")) {
            try {
                length = Long.parseLong(header.getFirstHeaderValue("Content-Length"));
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe.getMessage());
            }
        }
        StringBuffer headerText = this.composeHTTPHeader(request, path, header, length, this.myIsKeepAlive);
        this.myConnection.sendData(headerText.toString().getBytes(this.myCharset));
        if (this.myRequestBody != null && length > 0L) {
            this.myConnection.sendData(this.myRequestBody);
        } else if (this.myRequestStream != null && length > 0L) {
            this.myConnection.sendData(this.myRequestStream, length);
        }
        this.myConnection.readHeader(this);
        this.myTimeout = HTTPRequest.computeTimeout(this.myStatus, this.getResponseHeader());
        SVNErrorMessage sVNErrorMessage = context = context == null ? SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} of ''{1}''", request, path) : context;
        if (this.myStatus.getCode() == 301 || this.myStatus.getCode() == 302 || this.myStatus.getCode() == 403 || this.myStatus.getCode() == 401 || this.myStatus.getCode() == 407) {
            this.myErrorMessage = HTTPRequest.createDefaultErrorMessage(this.myConnection.getHost(), path, this.myStatus, context.getMessageTemplate(), context.getRelatedObjects());
            this.myConnection.skipData(this);
            return;
        }
        boolean notExpected = false;
        if (ok1 >= 0) {
            if (ok1 == 0) {
                int n = ok1 = "PROPFIND".equals(request) ? 207 : 200;
            }
            if (ok2 <= 0) {
                ok2 = ok1;
            }
            notExpected = this.myStatus.getCode() != ok1 && this.myStatus.getCode() != ok2;
        } else if ("CONNECT".equalsIgnoreCase(request) && this.myStatus.getCode() != 200) {
            notExpected = true;
        }
        if (notExpected) {
            this.myErrorMessage = this.readError(request, path, context);
        } else if (this.myStatus.getCode() == 204) {
            this.myConnection.skipData(this);
        } else if (this.myStatus.getCode() >= 300) {
            SVNErrorMessage error = this.readError(request, path, context);
            this.myStatus.setError(error);
        } else if (this.myResponseStream != null) {
            this.myErrorMessage = this.myConnection.readData(this, this.myResponseStream);
        } else if (this.myResponseHandler != null) {
            this.myErrorMessage = this.myConnection.readData(this, request, path, this.myResponseHandler);
        } else if (!"CONNECT".equalsIgnoreCase(request)) {
            this.myConnection.skipData(this);
        }
    }

    private static long computeTimeout(HTTPStatus status, HTTPHeader header) {
        if (header == null) {
            return -1L;
        }
        String keepAlive = header.getFirstHeaderValue("Keep-Alive");
        if (keepAlive == null && status.isHTTP11()) {
            return Long.MAX_VALUE;
        }
        if (keepAlive == null) {
            String value2 = header.getFirstHeaderValue("Connection");
            if (value2 != null && value2.toLowerCase().indexOf("keep-alive") >= 0) {
                return Long.MAX_VALUE;
            }
            List<String> connectionHeaders = header.getHeaderValues("Connection");
            if (connectionHeaders != null) {
                for (String value2 : connectionHeaders) {
                    if (value2 == null || value2.toLowerCase().indexOf("keep-alive") < 0) continue;
                    return Long.MAX_VALUE;
                }
            }
            return -1L;
        }
        String[] fields = keepAlive.split(",");
        for (int i = 0; i < fields.length; ++i) {
            int index = fields[i].indexOf(61);
            if (index < 0) continue;
            String name = fields[i].substring(0, index).trim();
            String value = fields[i].substring(index + 1).trim();
            if (!"timeout".equalsIgnoreCase(name)) continue;
            try {
                int seconds = Integer.parseInt(value);
                if (seconds >= 1) {
                    return System.currentTimeMillis() + (long)((seconds - 1) * 1000);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1L;
        }
        return Long.MAX_VALUE;
    }

    private SVNErrorMessage readError(String request, String path, SVNErrorMessage context) {
        String contextMessage = context.getMessageTemplate();
        Object[] contextObjects = context.getRelatedObjects();
        if (this.myStatus.getCode() == 404) {
            contextMessage = "''{0}'' path not found";
            contextObjects = new Object[]{path};
        }
        SVNErrorMessage error = HTTPRequest.createDefaultErrorMessage(this.myConnection.getHost(), path, this.myStatus, contextMessage, contextObjects);
        SVNErrorMessage davError = this.myConnection.readError(this, request, path);
        if (davError != null) {
            if (error != null) {
                davError.setChildErrorMessage(error);
            }
            return davError;
        }
        return error;
    }

    public HTTPHeader getResponseHeader() {
        return this.myResponseHeader;
    }

    public long getNextRequestTimeout() {
        return this.myTimeout;
    }

    public HTTPStatus getStatus() {
        return this.myStatus;
    }

    public void setStatus(HTTPStatus status) {
        this.myStatus = status;
    }

    public void setResponseHeader(HTTPHeader header) {
        this.myResponseHeader = header;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    private StringBuffer composeHTTPHeader(String request, String path, HTTPHeader header, long length, boolean keepAlive) {
        int defaultPort;
        StringBuffer sb = new StringBuffer();
        sb.append(request);
        sb.append(' ');
        sb.append(this.composeRequestURI(request, path));
        sb.append(' ');
        sb.append("HTTP/1.1");
        sb.append(CRLF);
        sb.append("Host: ");
        sb.append(this.myConnection.getHost().getHost());
        int n = defaultPort = "https".equals(this.myConnection.getHost().getProtocol()) ? 443 : 80;
        if (this.myConnection.getHost().getPort() != defaultPort) {
            sb.append(":");
            sb.append(this.myConnection.getHost().getPort());
        }
        sb.append(CRLF);
        sb.append("User-Agent: ");
        sb.append(Version.getUserAgent());
        sb.append(CRLF);
        if (keepAlive) {
            sb.append("Keep-Alive:");
            sb.append(CRLF);
            sb.append("Connection: TE, Keep-Alive");
            sb.append(CRLF);
        }
        sb.append("TE: trailers");
        sb.append(CRLF);
        if (this.myAuthentication != null) {
            sb.append("Authorization: ");
            sb.append(this.myAuthentication);
            sb.append(CRLF);
        }
        if ((this.myIsProxyAuthForced || this.myIsProxied && !this.myIsSecured) && this.myProxyAuthentication != null) {
            sb.append("Proxy-Authorization: ");
            sb.append(this.myProxyAuthentication);
            sb.append(CRLF);
        }
        if (header == null || !header.hasHeader("Content-Length")) {
            sb.append("Content-Length: ");
            sb.append(length);
            sb.append(CRLF);
        }
        sb.append("Accept-Encoding: gzip");
        sb.append(CRLF);
        if (header == null || !header.hasHeader("Content-Type")) {
            sb.append("Content-Type: text/xml; charset=\"utf-8\"");
            sb.append(CRLF);
        }
        sb.append("DAV: ");
        sb.append("http://subversion.tigris.org/xmlns/dav/svn/depth");
        sb.append(CRLF);
        sb.append("DAV: ");
        sb.append("http://subversion.tigris.org/xmlns/dav/svn/mergeinfo");
        sb.append(CRLF);
        sb.append("DAV: ");
        sb.append("http://subversion.tigris.org/xmlns/dav/svn/log-revprops");
        sb.append(CRLF);
        if (header != null) {
            sb.append(header.toString());
        }
        if (this.myCookieHeaders != null) {
            Set<Map.Entry<String, List<String>>> entries = this.myCookieHeaders.entrySet();
            for (Map.Entry<String, List<String>> entry : entries) {
                String headerKey = entry.getKey();
                for (String cookie : entry.getValue()) {
                    sb.append(headerKey);
                    sb.append(": ");
                    sb.append(cookie);
                    sb.append(CRLF);
                }
            }
        }
        sb.append(CRLF);
        return sb;
    }

    private String composeRequestURI(String request, String path) {
        StringBuffer sb = new StringBuffer();
        if (this.myIsProxied && !this.myIsSecured) {
            sb.append("http://");
            sb.append(this.myConnection.getHost().getHost());
            sb.append(":");
            sb.append(this.myConnection.getHost().getPort());
        }
        if (path == null) {
            path = "/";
        }
        if (!("CONNECT".equals(request) || ((String)path).length() != 0 && ((String)path).charAt(0) == '/')) {
            path = "/" + (String)path;
        }
        HTTPParser.getCanonicalPath((String)path, sb);
        return sb.toString();
    }

    public static SVNErrorMessage createDefaultErrorMessage(SVNURL host, String path, HTTPStatus status, String context, Object[] contextObjects) {
        Object message;
        SVNErrorCode errorCode = SVNErrorCode.RA_DAV_REQUEST_FAILED;
        Object object = message = status != null ? status.getCode() + " " + status.getReason() : "";
        if (status != null && status.getCode() == 403 || status.getCode() == 401) {
            errorCode = SVNErrorCode.RA_NOT_AUTHORIZED;
            message = status.getCode() + " " + status.getReason();
        } else if (status != null && status.getCode() == 404) {
            errorCode = SVNErrorCode.FS_NOT_FOUND;
        } else if (status != null && (status.getCode() == 301 || status.getCode() == 302)) {
            String location;
            String string = location = status.getHeader() != null ? status.getHeader().getFirstHeaderValue("Location") : null;
            if (location != null) {
                message = status.getCode() == 301 ? "Repository moved permanently to ''{0}''; please relocate" : "Repository moved temporarily to ''{0}''; please relocate";
                return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, (String)message, (Object)location);
            }
            message = status.getCode() == 301 ? "Repository moved permanently; please relocate" : "Repository moved temporarily; please relocate";
            return SVNErrorMessage.create(SVNErrorCode.RA_DAV_RELOCATED, (String)message);
        }
        Object[] messageObjects = contextObjects == null ? new Object[1] : new Object[contextObjects.length + 1];
        int index = messageObjects.length - 1;
        messageObjects[messageObjects.length - 1] = host;
        if (messageObjects.length > 1) {
            System.arraycopy(contextObjects, 0, messageObjects, 0, contextObjects.length);
        }
        return SVNErrorMessage.create(errorCode, context + ": " + (String)message + " ({" + index + "})", messageObjects);
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.myIsKeepAlive = isKeepAlive;
    }

    public void setCookies(Map<String, List<String>> cookieHeader) {
        this.myCookieHeaders = cookieHeader;
    }
}

