/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.repcache.IFSRepresentationCacheManagerFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.util.ISVNThreadPool;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNClassLoader {
    private static final String SVNKIT_PROPERTIES = "svnkit.properties";
    private static final String SVNKIT_PROPERTIES_PATH = "svnkit.properties.property";
    private static final String DEFAULT_PROPERTIES = "svnkit.adminareafactory.1=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea16Factory\nsvnkit.adminareafactory.2=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15Factory\nsvnkit.adminareafactory.3=org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14Factory\nsvnkit.adminareafactory.4=org.tmatesoft.svn.core.internal.wc.admin.SVNXMLAdminAreaFactory\nsvnkit.repcachemanagerfactory.1=org.tmatesoft.svn.core.internal.io.fs.repcache.FSRepresentationCacheManagerFactory\nsvnkit.repcachemanagerfactory.2=org.tmatesoft.svn.core.internal.io.fs.repcache.FSEmptyRepresentationCacheManagerFactory\nsvnkit.saslauthenticator.1=org.tmatesoft.svn.core.internal.io.svn.sasl.SVNSaslAuthenticator\nsvnkit.saslauthenticator.2=org.tmatesoft.svn.core.internal.io.svn.SVNPlainAuthenticator\nsvnkit.threadpool.1=org.tmatesoft.svn.core.internal.util.SVNThreadPool\nsvnkit.threadpool.2=org.tmatesoft.svn.core.internal.util.SVNEmptyThreadPool\n";

    public static ISVNThreadPool getThreadPool() {
        Collection threadPoolClasses = SVNClassLoader.getAllClasses("svnkit.threadpool.");
        for (Class threadPoolClass : threadPoolClasses) {
            Object object = null;
            try {
                object = threadPoolClass.newInstance();
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Could not instantiate a thread pool class " + threadPoolClass.getName() + ": " + th.getMessage());
            }
            if (object == null || !(object instanceof ISVNThreadPool)) continue;
            return object;
        }
        return null;
    }

    public static Collection getAvailableAdminAreaFactories() {
        Collection instances = SVNClassLoader.getAllClasses("svnkit.adminareafactory.");
        TreeSet<Object> factories = new TreeSet<Object>();
        for (Class adminAreaFactoryClass : instances) {
            Object object = null;
            try {
                object = adminAreaFactoryClass.newInstance();
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to instantiate an admin area factory class " + adminAreaFactoryClass.getName() + ": " + th.getMessage());
                continue;
            }
            if (object == null || !(object instanceof SVNAdminAreaFactory)) continue;
            factories.add(object);
        }
        return factories;
    }

    public static SVNAuthenticator getSASLAuthenticator(SVNConnection connection) throws SVNException {
        Collection saslAuthenticatorClasses = SVNClassLoader.getAllClasses("svnkit.saslauthenticator.");
        for (Class saslAuthenticatorClass : saslAuthenticatorClasses) {
            Constructor constructor = null;
            try {
                constructor = saslAuthenticatorClass.getConstructor(SVNConnection.class);
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to get constructor of a SASL authenticator (" + saslAuthenticatorClass.getName() + "): " + th.getMessage());
            }
            if (constructor == null) continue;
            Object object = null;
            try {
                object = constructor.newInstance(connection);
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Failed to instantiate a SASL authenticator ( " + saslAuthenticatorClass.getName() + "): " + th.getMessage());
            }
            if (object == null || !(object instanceof SVNAuthenticator)) continue;
            return object;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "No SASL authenticator class found!");
        SVNErrorManager.error(err, SVNLogType.NETWORK);
        return null;
    }

    public static IFSRepresentationCacheManagerFactory getFSRepresentationCacheManagerFactory() {
        Collection repCacheManagerFactoryClasses = SVNClassLoader.getAllClasses("svnkit.repcachemanagerfactory.");
        for (Class repCacheManagerFactoryClass : repCacheManagerFactoryClasses) {
            Object object = null;
            try {
                object = repCacheManagerFactoryClass.newInstance();
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Could not instantiate a rep-cache manager class " + repCacheManagerFactoryClass.getName() + ": " + th.getMessage());
            }
            if (object == null || !(object instanceof IFSRepresentationCacheManagerFactory)) continue;
            return object;
        }
        return null;
    }

    private static Collection getAllClasses(String keyPrefix) {
        LinkedList classes = new LinkedList();
        Map svnkitProps = SVNClassLoader.loadProperties();
        for (String key : svnkitProps.keySet()) {
            String className;
            if (!key.startsWith(keyPrefix) || (className = (String)svnkitProps.get(key)) == null) continue;
            Class<?> clazz = null;
            try {
                clazz = SVNClassLoader.class.getClassLoader().loadClass(className);
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to load class " + className + ": " + th.getMessage());
                continue;
            }
            if (clazz == null) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Failed to load class " + className);
                continue;
            }
            classes.add(clazz);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadProperties() {
        TreeMap<String, String> finalProps = new TreeMap<String, String>();
        Properties props = new Properties();
        InputStream resourceStream = new ByteArrayInputStream(DEFAULT_PROPERTIES.getBytes());
        try {
            props.load(resourceStream);
        }
        catch (IOException ioe) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Failed to load default SVNKit properties: " + ioe.getMessage());
        }
        String svnkitPropertiesResource = System.getProperty(SVNKIT_PROPERTIES_PATH, SVNKIT_PROPERTIES);
        try {
            resourceStream = SVNClassLoader.class.getClassLoader().getResourceAsStream(svnkitPropertiesResource);
            if (resourceStream != null) {
                props.load(resourceStream);
            }
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Failed to load '" + svnkitPropertiesResource + "': " + e.getMessage());
        }
        finally {
            SVNFileUtil.closeFile(resourceStream);
        }
        for (String string : props.keySet()) {
            String value = props.getProperty(string);
            value = System.getProperty(string, value);
            finalProps.put(string, value);
        }
        return finalProps;
    }
}

