/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import com.hierynomus.sshj.key.KeyAlgorithm;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.LinkedList;
import java.util.Queue;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;

public abstract class KeyedAuthMethod
extends AbstractAuthMethod {
    protected final KeyProvider kProv;
    private Queue<KeyAlgorithm> available;

    public KeyedAuthMethod(String name, KeyProvider kProv) {
        super(name);
        this.kProv = kProv;
    }

    private KeyAlgorithm getPublicKeyAlgorithm(KeyType keyType) throws TransportException {
        if (this.available == null) {
            this.available = new LinkedList<KeyAlgorithm>(this.params.getTransport().getClientKeyAlgorithms(keyType));
        }
        return this.available.peek();
    }

    @Override
    public boolean shouldRetry() {
        if (this.available != null) {
            this.available.poll();
            return !this.available.isEmpty();
        }
        return false;
    }

    protected SSHPacket putPubKey(SSHPacket reqBuf) throws UserAuthException {
        PublicKey key;
        try {
            key = this.kProv.getPublic();
        }
        catch (IOException ioe) {
            throw new UserAuthException("Problem getting public key from " + this.kProv, (Throwable)ioe);
        }
        KeyType keyType = KeyType.fromKey(key);
        try {
            KeyAlgorithm ka = this.getPublicKeyAlgorithm(keyType);
            if (ka != null) {
                ((SSHPacket)reqBuf.putString(ka.getKeyAlgorithm())).putString(((Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(key)).getCompactData());
                return reqBuf;
            }
        }
        catch (IOException ioe) {
            throw new UserAuthException("No KeyAlgorithm configured for key " + keyType, (Throwable)ioe);
        }
        throw new UserAuthException("No KeyAlgorithm configured for key " + keyType);
    }

    protected SSHPacket putSig(SSHPacket reqBuf) throws UserAuthException {
        Signature signature;
        PrivateKey key;
        try {
            key = this.kProv.getPrivate();
        }
        catch (IOException ioe) {
            throw new UserAuthException("Problem getting private key from " + this.kProv, (Throwable)ioe);
        }
        KeyType kt = KeyType.fromKey(key);
        try {
            signature = this.getPublicKeyAlgorithm(kt).newSignature();
        }
        catch (TransportException e) {
            throw new UserAuthException("No KeyAlgorithm configured for key " + kt);
        }
        signature.initSign(key);
        signature.update(((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer(reqBuf)).getCompactData());
        reqBuf.putSignature(signature.getSignatureName(), signature.encode(signature.sign()));
        return reqBuf;
    }
}

