/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.revwalk.AddToBitmapFilter;
import org.eclipse.jgit.internal.revwalk.AddToBitmapWithCacheFilter;
import org.eclipse.jgit.internal.revwalk.AddUnseenToBitmapFilter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.filter.ObjectFilter;

public final class BitmapWalker {
    private final ObjectWalk walker;
    private final BitmapIndex bitmapIndex;
    private final ProgressMonitor pm;
    private long countOfBitmapIndexMisses;
    private AnyObjectId prevCommit;
    private BitmapIndex.Bitmap prevBitmap;

    public BitmapWalker(ObjectWalk walker, BitmapIndex bitmapIndex, ProgressMonitor pm) {
        this.walker = walker;
        this.bitmapIndex = bitmapIndex;
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
    }

    public void setPrevCommit(AnyObjectId prevCommit) {
        this.prevCommit = prevCommit;
    }

    public void setPrevBitmap(BitmapIndex.Bitmap prevBitmap) {
        this.prevBitmap = prevBitmap;
    }

    public long getCountOfBitmapIndexMisses() {
        return this.countOfBitmapIndexMisses;
    }

    public BitmapIndex.BitmapBuilder findObjects(Iterable<? extends ObjectId> start, BitmapIndex.BitmapBuilder seen, boolean ignoreMissing) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (!ignoreMissing) {
            return this.findObjectsWalk(start, seen, false);
        }
        try {
            return this.findObjectsWalk(start, seen, true);
        }
        catch (MissingObjectException missingObjectException) {
            BitmapIndex.BitmapBuilder result = this.bitmapIndex.newBitmapBuilder();
            for (ObjectId objectId : start) {
                BitmapIndex.Bitmap bitmap = this.bitmapIndex.getBitmap(objectId);
                if (bitmap == null) continue;
                result.or(bitmap);
            }
            for (ObjectId objectId : start) {
                if (result.contains(objectId)) continue;
                try {
                    result.or(this.findObjectsWalk(Arrays.asList(objectId), result, false));
                }
                catch (MissingObjectException missingObjectException2) {}
            }
            return result;
        }
    }

    private BitmapIndex.BitmapBuilder findObjectsWalk(Iterable<? extends ObjectId> start, BitmapIndex.BitmapBuilder seen, boolean ignoreMissingStart) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.walker.reset();
        BitmapIndex.BitmapBuilder bitmapResult = this.bitmapIndex.newBitmapBuilder();
        for (ObjectId objectId : start) {
            BitmapIndex.Bitmap bitmap = this.bitmapIndex.getBitmap(objectId);
            if (bitmap == null) continue;
            bitmapResult.or(bitmap);
        }
        boolean marked = false;
        for (ObjectId objectId : start) {
            try {
                if (bitmapResult.contains(objectId)) continue;
                this.walker.markStart(this.walker.parseAny(objectId));
                marked = true;
            }
            catch (MissingObjectException e) {
                if (ignoreMissingStart) continue;
                throw e;
            }
        }
        if (marked) {
            RevObject revObject;
            if (this.prevCommit != null) {
                this.walker.setRevFilter(new AddToBitmapWithCacheFilter(this.prevCommit, this.prevBitmap, bitmapResult));
            } else if (seen == null) {
                this.walker.setRevFilter(new AddToBitmapFilter(bitmapResult));
            } else {
                this.walker.setRevFilter(new AddUnseenToBitmapFilter(seen, bitmapResult));
            }
            this.walker.setObjectFilter(new BitmapObjectFilter(bitmapResult));
            while (this.walker.next() != null) {
                this.pm.update(1);
                ++this.countOfBitmapIndexMisses;
            }
            while ((revObject = this.walker.nextObject()) != null) {
                bitmapResult.addObject(revObject, revObject.getType());
                this.pm.update(1);
            }
        }
        return bitmapResult;
    }

    static class BitmapObjectFilter
    extends ObjectFilter {
        private final BitmapIndex.BitmapBuilder bitmap;

        BitmapObjectFilter(BitmapIndex.BitmapBuilder bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public final boolean include(ObjectWalk walker, AnyObjectId objid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return !this.bitmap.contains(objid);
        }
    }
}

