/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(use "MouseObjLook")
(use "sciAudio")
(local
   snd
   programControlAction
   HAVE_GLOVES
   HAVE_LIGHTS
   HAVE_HAT
   WHIPPED_SNOWMAN
   FOUND_LADDER
   FOUND_KEY
   HAVE_KEY
   EGO_STRAYED
)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 0
	)
	(method (doit)

		(if(gProgramControl and == programControlAction PC_OPEN_DOOR)
            (door:setCycle(End))

		    PlayerControl()
		    = gProgramControl FALSE
		    = programControlAction NULL
		    
              (send snd:
                   command("play")
                   fileName("effects\\score.sciAudio")
                   volume("50")
                   loopCount("0")
                   init()
              )
                
              (send gGame:changeScore(7))		          		   	
		)
		
		(if(gProgramControl and (send gEgo:isStopped()) and == programControlAction PC_WHIP_SNOWMAN)
			
           (send gEgo:   // look at snowman
               loop(1)
               cel(4)
           )  
		   
		   (snowmanHead:loop(1))	  
           (snowmanHead:setCycle(End))	   
  
  
		   PlayerControl()
		   = gProgramControl FALSE
		   = programControlAction NULL
		   
		   		                
            (send snd:
               command("play")
               fileName("effects\\whip.sciAudio")
               volume("50")
               loopCount("0")
               init()
            )
            (send gGame:changeScore(5))
		)
		
		(if(== FOUND_LADDER FALSE and == (send gEgo:onControl()) ctlFUCHSIA) 
		    Print(1 0) /* Hey, there is a ladder leaning against the wall of the house back here! */	
		    = FOUND_LADDER TRUE
		)  
		
		(if(== EGO_STRAYED FALSE and == (send gEgo:onControl()) ctlBLUE)
		    Print(1 1) /* Better not stray too far away from the house, it's your only hope for survival! */	
		    = EGO_STRAYED TRUE
		)    
		
		// reset the flag once the ego moves off the blue control color
		(if(== EGO_STRAYED TRUE and <> (send gEgo:onControl()) ctlBLUE)
		    = EGO_STRAYED FALSE	
		)
			
	)
	(method (init)
		(var maxCel)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:
  					posn(200 170)
  					loop(1)
  				)
  			)
  		)
  		
  		// init variables
  	    = HAVE_GLOVES FALSE
  	    = HAVE_LIGHTS FALSE
  	    = WHIPPED_SNOWMAN FALSE
		= FOUND_LADDER FALSE
		= FOUND_KEY FALSE
		= HAVE_KEY FALSE
		= EGO_STRAYED FALSE
		= snd aud
		
		
		// Play the music
	    (send snd:
           command("playx")
           fileName("music\\snow.sciAudio")
           volume("10")
           loopCount("-1")
           init()
        )
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init())
		

		= maxCel 52
 
        (snow1:init())
        (snow1:x(Random(10 310)))
        (snow1:setCel(Random(1 maxCel)))
        (snow1:setCycle(Fwd))
        (snow1:loop(-1))

        (snow2:init())
        (snow2:x(Random(10 310)))
        (snow2:setCel(Random(1 maxCel)))
        (snow2:setCycle(Fwd))
        (snow2:loop(-1))

 
        (snow3:init())
        (snow3:x(Random(10 310)))
        (snow3:setCel(Random(1 maxCel)))
        (snow3:setCycle(Fwd))
        (snow3:loop(-1))
 
        (snow4:init())
        (snow4:x(Random(10 310)))
        (snow4:setCel(Random(1 maxCel)))
        (snow4:setCycle(Fwd))
        (snow4:loop(-1)) 
 
        (snow5:init())
        (snow5:x(Random(10 310)))
        (snow5:setCel(Random(1 maxCel)))
        (snow5:setCycle(Fwd))
        (snow5:loop(-1))
        
        (snow6:init())
        (snow6:x(Random(10 310)))
        (snow6:setCel(Random(1 maxCel)))
        (snow6:setCycle(Fwd))
        (snow6:loop(-1))        

        (snow7:init())
        (snow7:x(Random(10 310)))
        (snow7:setCel(Random(1 maxCel)))
        (snow7:setCycle(Fwd))
        (snow7:loop(-1))   
               
        (snow8:init())
        (snow8:x(Random(10 310)))
        (snow8:setCel(Random(1 maxCel)))
        (snow8:setCycle(Fwd))
        (snow8:loop(-1))        

        (snow9:init())
        (snow9:x(Random(10 310)))
        (snow9:setCel(Random(1 maxCel)))
        (snow9:setCycle(Fwd))
        (snow9:loop(-1))          
        
  
        (snow10:init())
        (snow10:x(Random(10 310)))
        (snow10:setCel(Random(1 maxCel)))
        (snow10:setCycle(Fwd))
        (snow10:loop(-1))

        (snow11:init())
        (snow11:x(Random(10 310)))
        (snow11:setCel(Random(1 maxCel)))
        (snow11:setCycle(Fwd))
        (snow11:loop(-1))

        (snow12:init())
        (snow12:x(Random(10 310)))
        (snow12:setCel(Random(1 maxCel)))
        (snow12:setCycle(Fwd))
        (snow12:loop(-1))

 
        (snow13:init())
        (snow13:x(Random(10 310)))
        (snow13:setCel(Random(1 maxCel)))
        (snow13:setCycle(Fwd))
        (snow13:loop(-1))
 
        (snow14:init())
        (snow14:x(Random(10 310)))
        (snow14:setCel(Random(1 maxCel)))
        (snow14:setCycle(Fwd))
        (snow14:loop(-1)) 
 
        (snow15:init())
        (snow15:x(Random(10 310)))
        (snow15:setCel(Random(1 maxCel)))
        (snow15:setCycle(Fwd))
        (snow15:loop(-1))
        
        (snow16:init())
        (snow16:x(Random(10 310)))
        (snow16:setCel(Random(1 maxCel)))
        (snow16:setCycle(Fwd))
        (snow16:loop(-1))        

        (snow17:init())
        (snow17:x(Random(10 310)))
        (snow17:setCel(Random(1 maxCel)))
        (snow17:setCycle(Fwd))
        (snow17:loop(-1))   
               
        (snow18:init())
        (snow18:x(Random(10 310)))
        (snow18:setCel(Random(1 maxCel)))
        (snow18:setCycle(Fwd))
        (snow18:loop(-1))        

        (snow19:init())
        (snow19:x(Random(10 310)))
        (snow19:setCel(Random(1 maxCel)))
        (snow19:setCycle(Fwd))
        (snow19:loop(-1))          

        (snow20:init())
        (snow20:x(Random(10 310)))
        (snow20:setCel(Random(1 maxCel)))
        (snow20:setCycle(Fwd))
        (snow20:loop(-1))

        (snowmanHead:init())
        (snowmanHead:ignoreActors())
        
        (treeSnow:init())
        (treeSnow:setPri(3))

        (lightsHung:init())
        (lightsHung:setCycle(Fwd))
        (lightsHung:setPri(2))
        (lightsHung:loop(-1))

        (smoke:init())
        (smoke:setCycle(Fwd))
        (smoke:setPri(16))    // how is this a valid value?  Works though, the smoke no longer clobbers the inventory title bar

        (door:init())

  		// Show the 'how to play' 
  		Print(1 2) /* It's an extremely cold winter night, you've been stranded outside after your sleigh crash lands on the roof of a small house in one of the remotest parts of Russia. You must find a way to stay warm or death is quite certain. */
        Print(1 3) /* During your landing, you seem to have lost several articles of clothing. Bad luck that. */
        
        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  )
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
	(method (handleEvent pEvent)
		(var dyingScript, mbResult)
        (super:handleEvent(pEvent))
 
        (if(Said('(search,(look<(in,under,behind)))/bush'))
            Print(1 4) /* If there is anything to find in the bushes, you certainly won't find it until Springtime.  There is just too much snow to sift through. */	
		)
 
		(if(Said('(search,(look<(in,under,behind)))/woodpile'))
			(if (== (send gEgo:onControl()) ctlTEAL)
			    (if (== HAVE_GLOVES FALSE)
					Print(1 5) /* You look behind the woodpile and find your gloves!  Hands shaking, you immediately put them on. Now if you can only find something else to protect you from the intense cold... */
				    = HAVE_GLOVES TRUE
				    (send gEgo:get(INV_GLOVES))
				    (send snd:
                           command("play")
                           fileName("effects\\score.sciAudio")
                           volume("50")
                           loopCount("0")
                           init()
                    )
                    (send gGame:changeScore(5))
				)(else
					Print(1 6) /* An additional search behind the woodpile reveals nothing. */
				)
			)(else
					Print(1 7) /* You are not close enough to the woodpile. */
			)
		)

       
        (if(   Said('whip/(snowman,hat)') 
            or Said('whip/(head,hat)<snowman') 
            or Said('(whip,throw,swing,toss)<at/light/(snowman,hat)')
            or Said('take<with/hat/light')
           )
        	(if (== HAVE_LIGHTS TRUE)
	        	(if (== WHIPPED_SNOWMAN FALSE)
	        		(if(== (send gEgo:onControl()) ctlGREEN)    	
		                ProgramControl()
		                = gProgramControl TRUE
		                = programControlAction PC_WHIP_SNOWMAN
		                
		                (send snd:
			               command("play")
			               fileName("music\\indy.sciAudio")
			               volume("100")
			               loopCount("0")
			               init()
			            )
		                
		                (send gEgo:
		                    setCycle(Walk)
		                    setMotion(MoveTo 85 182)
		                ) 
		                = WHIPPED_SNOWMAN TRUE                  
					)(else
						Print(1 8) /* Get closer. */
				    )
				)(else
				   Print(1 9) /* The snowman has been sufficiently whipped. Leave it alone. */	
				)            
			)(else
			   Print(1 10) /* Oh? How should we do that? */	
			)

        )
        
        (if(Said('take/light[<christmas]'))
        	(if (== HAVE_LIGHTS FALSE)
        	   (if (== (send gEgo:onControl()) ctlRED)
	        	   Print(1 11) /* While taking the strand of lights from the tree a large amount of snow is released from the upper branches, covering your arms and hands completely with snow.*/
	        	   (treeSnow:setCycle(End))
	        	   (if (== HAVE_GLOVES FALSE)
	        	         = dyingScript ScriptID(DYING_SCRIPT)
					     (send dyingScript:
					       caller(802)
					       seconds(3)
					       register("The snow falling on your exposed hands have caused them to shake uncontrollably.  Slowly you go into hypothermic shock, and then... You're dead.")
					     )
					     (send gGame:setScript(dyingScript))  
				   )
				   Print("Good thing you had your gloves on!")
	        	   (lightsHung:dispose())
	        	   (treeSnow:setPri(16))
	           	   = HAVE_LIGHTS TRUE
	           	   (send gEgo:get(INV_LIGHTS))
	           	   
	           	   (send snd:
                       command("play")
                       fileName("effects\\score.sciAudio")
                       volume("50")
                       loopCount("0")
                       init()
                   )
                   (send gGame:changeScore(2))
	           	   
			   )(else
			       Print(1 12) /* You need to get closer to the tree to reach the lights. */	
			   )
			)(else
			   Print(1 13) /* You are off your rocker? You've already taken the lights! */	
			)
			
		)
	
		(if(Said('take/hat') or Said('put<on/hat'))
			(if (== WHIPPED_SNOWMAN TRUE)
			  (if (== HAVE_HAT FALSE)
			  	 (if(== (send gEgo:onControl()) ctlGREEN)
			  	 	Print(1 14) /* You pick up the hat and put it on your head. You feel warmer now, but are still chilled to the bone. */
			  	 	(snowmanHead:loop(2))
	                (send snd:
                       command("play")
                       fileName("effects\\score.sciAudio")
                       volume("50")
                       loopCount("0")
                       init()
                    )
                    (send gGame:changeScore(2))
                    = HAVE_HAT TRUE
                    (send gEgo:get(INV_HAT))
				 )(else
				 	Print(1 15) /* You are too far away to pick up the hat. */
				 )
			  )(else
			     Print(1 16) /* It's on your head. I'd leave it there. */	
			  )
			)(else
			   Print(1 17) /* You cannot reach your hat, the snowman is just too tall. */	
			)
		)  
		
		(if(Said('(climb,use)/ladder'))
		    (if (== (send gEgo:onControl()) ctlFUCHSIA)
			     = dyingScript ScriptID(DYING_SCRIPT)
			     (send dyingScript:
			       caller(805)
			       seconds(1)
			       register("You begin to scramble up the ladder. About two thirds on the way up, the ladder snaps in two and you fall to your death.")
			     )
			     (send gGame:setScript(dyingScript))
			)(else
			 	Print(1 18) /* You aren't close enough to climb the ladder */
			)
		)
		
		(if(Said('(search,take,move)/(wreath,bow[<red])') and == FOUND_KEY FALSE)
			(if (== (send gEgo:onControl()) ctlYELLOW)
				(if (== FOUND_KEY FALSE)
					(if( == HAVE_GLOVES TRUE and == HAVE_HAT TRUE)
				       Print(1 19) /* Meticulously, you examine each bough and needle of the wreath.  After an exhaustive search, you find a house key in a hidden pouch of the red bow. */
				       = FOUND_KEY TRUE
		                (send snd:
                           command("play")
                           fileName("effects\\score.sciAudio")
                           volume("50")
                           loopCount("0")
                           init()
                        )
                        (send gGame:changeScore(2))				       
				    )(else
					     = dyingScript ScriptID(DYING_SCRIPT)
					     (send dyingScript:
					       caller(8)
					       seconds(1)
					       register("While searching the wreath, 60% of your body heat continues to dissipate from your uncovered head. Soon, you keel over as stiff and as cold as a popsicle.")
					     )
					     (send gGame:setScript(dyingScript))				      
					)
				)(else
				    Print(1 20) /* Fiddling with the wreath does not lead to any additional revelations. */	
				)
			)(else
			    Print(1 21) /* Get closer to the door. */	
			)
		)
		
		(if(Said('(take,(pick<up))/key[<house]'))
			(if (== FOUND_KEY TRUE)
				(if (== HAVE_KEY FALSE)
					(if (== (send gEgo:onControl()) ctlYELLOW)
					   Print(1 22) /* You take the house key. */
					   = HAVE_KEY TRUE
					   (send gEgo:get(INV_KEY))
		                (send snd:
                           command("play")
                           fileName("effects\\score.sciAudio")
                           volume("50")
                           loopCount("0")
                           init()
                        )
                        (send gGame:changeScore(5))
					)(else
					   Print(1 23) /* Your go-go-gadget arms don't seem to be working today.  Probably should get closer to the wreath to pick up the key. */	
					)
				)(else
					Print(1 24) /* You silly goose, you already have the house key! */
				)
			)(else
			    Print(1 25) /* Key? What key, where? */
			)
		)
		
		(if(Said('knock[<on]/(door,window)'))
	       Print(1 26) /* Nobody's home. */			
	    )
	    
	    (if(Said('(break,smash)/(door,window)'))
	       Print(1 27) /* Hmmm. Let's avoid the breaking and focus on the entering part. */
		)
		
		(if(Said('open/window'))
		   Print(1 28) /* The windows are sealed shut with multiple layers of paint.  It appears that they have not been opened in eons. */	
		)
		
		(if(Said('take/woodpile'))
		   Print(1 29) /* The woodpile is too awkward and heavy to move. */	
		)
		
		// debugging
		(if(Said('(open,unlock)/door'))
				Print(1 32) /* You unlock & open the door. */
				
				
			(RoomScript:changeState(10))
			
		    
              (send snd:
                   command("play")
                   fileName("effects\\score.sciAudio")
                   volume("50")
                   loopCount("0")
                   init()
              )
                
              (send gGame:changeScore(7))	
      	 /* 
	                ProgramControl()
	                = gProgramControl TRUE
	                = programControlAction PC_OPEN_DOOR
	     */           
          // End game
           // Print(1 33) /* You enter the house, avoiding certain death from the cold. Congratulations, you've won the game! */
            
         /*   
			(while(1)
				= mbResult Print(
					"What would you like to do now?"
					#title "Thank you for playing!"
					#button "Play Again"  1
					#button "  Quit  " 2
				)
				(switch(mbResult)
	    			(case 1
                        (send snd:
                          command("stop")
                          fileName("music\\snow.sciAudio")
                          fadeOutMillisecs("5000")
                          loopCount("0")
                          init()
                        )
						(send gGame:restart())
						return
	    			)
	    		    (case 2
                       = snd aud
                       (send snd:
                         command("stop")
                         fileName("music\\snow.sciAudio")
                         fadeOutMillisecs("5000")
                         loopCount("0")
                         init()
                       )
	    				= gQuitGame TRUE
	    				return
	    			)
	    		)
	    	)
	    	*/       

		)
		
	    (if(Said('(open,unlock)/door'))
		    (if (== FOUND_KEY FALSE)
		        Print(1 30) /* You can't open the door, it's locked and you don't have a key! */	
			)(else
			   (if (== HAVE_KEY FALSE)
			   	  Print(1 31) /* You don't have the key.  It's still in the bow of the wreath! */
			   )(else
			   	  Print(1 32) /* You unlock & open the door. */
      	  
	                ProgramControl()
	                = gProgramControl TRUE
	                = programControlAction PC_OPEN_DOOR

	              (send snd:
	                   command("play")
	                   fileName("effects\\score.sciAudio")
	                   volume("50")
	                   loopCount("0")
	                   init()
	              )
	                
	              (send gGame:changeScore(7))	  
			   )	
			)	
		)
		
		(if(Said('lock/door'))
		   Print(1 34) /* Pointless. */	
		)
		
		(if(Said('(tie,attach)/light/lamppost'))
		   Print(1 35) /* Certainly possible, but I think that the lights would be more useful in another way. */	
		)
		
		(if(Said('(tie,attach)/light/ladder'))
		   Print(1 36) /* Reinforcing the ladder with the string of lights won't improve the stability of the ladder. */	
		)
		
		(if(Said('(tie,attach)/light/roof'))
		   Print(1 37) /* You can't reach the roof to attach the lights.  Besides, the light strand is much more useful in your hands. */
		)
		
		(if(Said('(take,move)/ladder'))
		    Print(1 38) /* The ladder is fine right where it is.  No need to move it. */	
		)
		
		(if(Said('climb/(house,tree,lamppost)'))
		    Print(1 39) /* Climbing in this fashion is best left to monkeys. */
		)
		
		(if(Said('decorate/(house,snowman)/light'))
		    Print(1 40) /* I like your sense of style.  But the lights would be more useful as a tool than a decoration. */
		)
		
		(if(Said('look/snowman[<(massive,tall)]') 
				 or (== (send pEvent:claimed) FALSE and (SnowmanLook:rightClicked(pEvent)))   
				 or (    == WHIPPED_SNOWMAN FALSE
				 	 and == (send pEvent:type) evMOUSEBUTTON
    	             and == (send pEvent:modifiers) 515  // right click
				 	 and (> (send pEvent:x) 0)
				     and (< (send pEvent:x) 18)
				     and (> (send pEvent:y) 105)
				     and (< (send pEvent:y) 126)
				     and == (send pEvent:claimed) FALSE  
					)
				 or (    == WHIPPED_SNOWMAN TRUE
				     and == (send pEvent:type) evMOUSEBUTTON
    	             and == (send pEvent:modifiers) 515  // right click
				 	 and (> (send pEvent:x) 46)
				     and (< (send pEvent:x) 71)
				     and (> (send pEvent:y) 156)
				     and (< (send pEvent:y) 179)
				     and == (send pEvent:claimed) FALSE 
					)			     
		   )
		    (if(== WHIPPED_SNOWMAN FALSE)
		        Print(1 67) /* There is a massive snowman here, at least twice your height. Perched on top of the snowman's head is your warm looking hat. */	
			)(else
				Print(1 68) /* There is a massive snowman here, at least twice your height. It's head is lying on the ground. */
			)	
			(send pEvent:claimed(TRUE))  //claim the event so another rightClick look won't be called
		)        
        
        (if(Said('look/light[<(christmas,strand,string)]'))
        	(if(== HAVE_LIGHTS FALSE)
        	   Print(1 41) /* A lit string of Christmas lights adorn the tall tree. */
			)(else
			   Print(1 42) /* You have the sting of lights in your hand, accompanied with an urge to use them for something. */	
			)
		)
		
        (if(Said('look/house[<stone]') or HouseLook:rightClicked(pEvent))
        	Print(1 43) /* A small stone house set in a clearing, surrounded by a large forest is here.  The lights shining from the windows are very inviting. */
		)
		
		(if(Said('look/window<small') or SmallWindowLook:rightClicked(pEvent))
			Print(1 44) /* There are several warmly-lit windows set into the stonework and door of the small house. */
		)
		
		(if(Said('look/window<(large,bay)') or BayWindowLook:rightClicked(pEvent))
			Print(1 45) /* Peering into the large bay window you can see a beatifully decorated tree. */
		)

		(if(Said('look/wreath') or WreathLook:rightClicked(pEvent))
			Print(1 46) /* On the door hangs a wreath. */
		)
		
     	(if(Said('look/door') or DoorLook:rightClicked(pEvent))
			Print(1 47) /* A sturdy wooden door is in the front of the house. */
		)
		
		(if(Said('look/tree<(small,short,tiny)') or SmallTreeLook:rightClicked(pEvent))
			Print(1 48) /* A small tree is visible in the bay window, lights twinkling on it's branches. */	
		)
		
		(if(Said('look/tree<(large,big,huge,tall)') or LargeTreeLook:rightClicked(pEvent))
			(if(== HAVE_LIGHTS TRUE)
			   Print(1 49) /* A tall pine tree is here.  A significant amount of snow is piled up at it's base, dislodged from taking the lights. */
			)(else
		   	   Print(1 50) /* A tall pine tree is decorated here.  Bright lights alternate on and off in a mesmerizing pattern. */
			)
		)
		
		(if(Said('look/tree<dead') or DeadTreeLook:rightClicked(pEvent))
			Print(1 51) /* There are several dead trees visible in the forest.  Probably victims of a pine beetle infestation. */
		)
		
		(if(Said('look/forest') or (== (send pEvent:claimed) FALSE and (ForestLook:rightClicked(pEvent))))
			Print(1 52) /* The edge of an impenetrable dense forest begins a short distance behind the small house. */
		)

		(if(Said('look/moon') or MoonLook:rightClicked(pEvent))
			Print(1 53) /* It's a full moon tonight providing great visibility through the gently falling snow. */
		)
		
		(if(Said('look/lamppost') or LampPostLook:rightClicked(pEvent))
			Print(1 54) /* There is an antique lamppost providing light here. */
		)
		
		(if(Said('look/woodpile') or Said('look<of/pile/wood') or WoodPileLook:rightClicked(pEvent))
			Print(1 55) /* There is a pile of wood neatly stacked next to the bay window.  The snow covering the woodpile looks recently disturbed. */
		)

		(if(Said('look/snowpile') or Said('look<of/pile/snow'))
			Print(1 56) /* There is snow piled everywhere.  Nothing out of the ordinary regarding the current conditions. */
		)
		
		(if(Said('look/mountain') or MountainLook:rightClicked(pEvent))
		    Print(1 57) /* The Rocky Mountains are brightly illuminated by the full moon tonight. */	
		)
		
		(if(Said('look/(sky,star)') or SkyLook:rightClicked(pEvent))
			Print(1 58) /* The dark blue sky is accompanied by several shining stars and a light snowfall. */
		)
		
		(if(Said('look/(chimney,smoke,fire)') or ChimneyLook:rightClicked(pEvent))
			Print(1 59) /* Wisps of smoke emit from the chimney on the roof. */
		)
		
		(if(Said('look/(snow,snowbank)') 
		   or (SnowBankLook:rightClicked(pEvent)) 
	       or ( == (send pEvent:claimed) FALSE) and (SnowLook:rightClicked(pEvent)))
			Print(1 60) /* The ground is covered by a recent snowfall. */
		)
		
		(if(Said('look/(footprint,track)') or FootprintLook:rightClicked(pEvent))
			Print(1 61) /* A trail of footprints lead toward the front door of the small house. */
		)
		
		(if(Said('look/roof') or (RoofLook1:rightClicked(pEvent)) or (RoofLook2:rightClicked(pEvent)))
		    Print(1 62) /* The roof of the small house is covered with a thick layer of snow. */	
		)

		(if(Said('look/bush') or (BushLook1:rightClicked(pEvent)) or (BushLook2:rightClicked(pEvent)))
		    Print(1 63) /* There are several snow-covered bushes in front of the house. */	
		)
		
		(if(Said('look/sleigh') or SleighLook:rightClicked(pEvent))
			Print(1 64) /* Your crashed sleigh sits a-kilter on the roof.  Heaven only knows where the reindeer have disappeared to. */
	    )
	    
	    (if(Said('look/(button,eye)[/snowman]'))
	    	Print(1 65) /* Made of coal, no doubt.  But these items will not help you now. */
		)
		
		(if(Said('look/hat'))
			(if (== HAVE_HAT TRUE)
		       Print("It's your hat. Must have landed on the snowman's head when you crashed!")
			)(else
			   Print("Good thing you retrieved your hat, you are feeling much warmer now with it on your head.")	
			)
		)

		
		(if(Said('look/ladder'))
			(if(== FOUND_LADDER TRUE)
		       Print("The ladder looks pretty flimsy. I'd think twice about attempting to climb up it.")
			)(else
			   Print("I can't see a ladder here.")
			)	
		)
		
		(if(Said('look/gloves'))
		    Print("Your gloves which you found behind the woodpile are keeping your hands nice and warm.")	
		)
		
		
		(if(Said('look/key'))
			Print("It's an ordinary house key.")
		)
		
		(if(Said('(push,pull,hit,knock,roll)/snowman'))
			Print("The snowman is much too heavy to move or knock over.")
		)
	    
		(if(Said('take/snow'))
		    Print(1 66) /* Then what would you do with it?  Make a snowball, I suppose? */	
		)
		
		(if(Said('eat/snow'))
			     = dyingScript ScriptID(DYING_SCRIPT)
			     (send dyingScript:
			       caller(7)
			       seconds(1)
			       register("You really don't get the point of this game, do you? The idea is to get warmer, not colder!")
			     )
			     (send gGame:setScript(dyingScript)) 	
		)
		
		
		// Disambiguate please
		(if(Said('look/window'))
		    Print(1 69) /* Which window do you mean, the large bay window or the smaller windows? */
		)
		
		(if(Said('look/tree'))
			Print(1 70) /* Which tree do you mean, the small tree in the bay window or the large tree? */
		)
		
		(if(Said('look[/!*]'))
		    Print(1 71) /* What do you want to look at? */	
		)
		
		(if(Said('climb[/!*]'))
		    Print(1 72) /* What do you want to climb? */	
		)
		
		(if(Said('tie/light[/!*]'))
		    Print(1 73) /* What do want to tie the string of lights to? */	
		)
		
		(if(Said('whip/light[/!*]'))
		    Print(1 74) /* What do want to whip with the string of lights? */	
		)
		
		// Yuks
		(if(Said('climb/*'))
			Print(1 75) /* Uh, uh. No way. Chimneys provide enough of a challenge, and now is not the time to improve your climbing repertoire. */ 
		)
		
		(if(Said('tie/light/*'))
		    Print(1 76) /* Yeah, and I bet you tie your shoes the same way! */	
		)
		
		(if(Said('whip/light/*'))
            Print(1 77) /* Don't you think that there is something better to whip than that? */
		)
		
		(if(Said('look/*'))
		    Print(1 78) /* You'll go cross-eyed looking at that. Stop it. */	
		)
 	)
 	(method (changeState newState)
 		(var state, mbResult)
 		= state newState
        (switch(state)
            (case 10
                (door:setCycle(End))
                //= seconds 3
                = cycles 3
            )
            (case 11
            	Print(1 33) /* You enter the house, avoiding certain death from the cold. Congratulations, you've won the game! */
	            (while(1)
					= mbResult Print(
						"What would you like to do now?"
						#title "Thank you for playing!"
						#button "Play Again"  1
						#button "  Quit  " 2
					)
					(switch(mbResult)
		    			(case 1
	                        (send snd:
	                          command("stop")
	                          fileName("music\\snow.sciAudio")
	                          fadeOutMillisecs("5000")
	                          loopCount("0")
	                          init()
	                        )
							(send gGame:restart())
							return
		    			)
		    		    (case 2
	                       = snd aud
	                       (send snd:
	                         command("stop")
	                         fileName("music\\snow.sciAudio")
	                         fadeOutMillisecs("5000")
	                         loopCount("0")
	                         init()
	                       )
		    				= gQuitGame TRUE
		    				return
		    			)
		    		)
		    	)
			)
		)
	)
)
/******************************************************************************/                     

(instance snow1 of Prop (properties y 190 x 10 view 1))
(instance snow2 of Prop (properties y 190 x 26 view 1))
(instance snow3 of Prop (properties y 190 x 20 view 1))
(instance snow4 of Prop (properties y 190 x 36 view 1))
(instance snow5 of Prop (properties y 190 x 50 view 1))
(instance snow6 of Prop (properties y 190 x 66 view 1))
(instance snow7 of Prop (properties y 190 x 70 view 1))
(instance snow8 of Prop (properties y 190 x 120 view 1))
(instance snow9 of Prop (properties y 190 x 125 view 1))


(instance snow10 of Prop (properties y 190 x 110 view 1))
(instance snow11 of Prop (properties y 190 x 126 view 1))
(instance snow12 of Prop (properties y 190 x 126 view 1))
(instance snow13 of Prop (properties y 190 x 120 view 1))
(instance snow14 of Prop (properties y 190 x 136 view 1))
(instance snow15 of Prop (properties y 190 x 150 view 1))
(instance snow16 of Prop (properties y 190 x 166 view 1))
(instance snow17 of Prop (properties y 190 x 170 view 1))
(instance snow18 of Prop (properties y 190 x 220 view 1))
(instance snow19 of Prop (properties y 190 x 225 view 1))

(instance snow20 of Prop (properties y 190 x 210 view 1))
(instance snow21 of Prop (properties y 190 x 210 view 1))
(instance snow22 of Prop (properties y 190 x 226 view 1))
(instance snow23 of Prop (properties y 190 x 220 view 1))
(instance snow24 of Prop (properties y 190 x 236 view 1))
(instance snow25 of Prop (properties y 190 x 250 view 1))
(instance snow26 of Prop (properties y 190 x 266 view 1))
(instance snow27 of Prop (properties y 190 x 270 view 1))
(instance snow28 of Prop (properties y 190 x 228 view 1))
(instance snow29 of Prop (properties y 190 x 220 view 1))

(instance snowmanHead of Prop (properties y 180 x 48 view 2))
(instance lightsHung of Prop (properties y 100 x 295 view 3))
(instance smoke of Prop (properties y 70 x 112 view 4))
(instance treeSnow of Prop (properties y 120 x 302 view 5))
(instance door of Prop (properties y 150 x 136 view 6))

// Right-click 'looking' objects
(instance public SkyLook of MouseLookObj (properties priorityColor ctlNAVY xMin 0 xMax 320 yMin 0 yMax 60))
(instance public MoonLook of MouseLookObj (properties priorityColor ctlLIME xMin 222 xMax 251 yMin 16 yMax 39))
(instance public DeadTreeLook of MouseLookObj (properties priorityColor ctlBROWN xMin 0 xMax 317 yMin 11 yMax 122))
(instance public ChimneyLook of MouseLookObj (properties priorityColor ctlFUCHSIA xMin 103 xMax 121 yMin 67 yMax 82))
(instance public LampPostLook of MouseLookObj (properties priorityColor ctlCYAN xMin 242 xMax 273 yMin 79 yMax 144))

(instance public RoofLook1 of MouseLookObj (properties priorityColor ctlLIME xMin 41 xMax 185 yMin 69 yMax 128))
(instance public RoofLook2 of MouseLookObj (properties priorityColor ctlLIME xMin 174 xMax 225 yMin 71 yMax 115))

(instance public BushLook1 of MouseLookObj (properties priorityColor ctlLIME xMin 160 xMax 232 yMin 124 yMax 156))
(instance public BushLook2 of MouseLookObj (properties priorityColor ctlLIME xMin 192 xMax 255 yMin 116 yMax 155))

(instance public LargeTreeLook of MouseLookObj (properties priorityColor ctlGREEN xMin 266 xMax 320 yMin 7 yMax 120))
(instance public MountainLook of MouseLookObj (properties priorityColor ctlPURPLE xMin 94 xMax 282 yMin 42 yMax 101))
(instance public HouseLook of MouseLookObj (properties priorityColor ctlBLUE xMin 38 xMax 212 yMin 87 yMax 161))
(instance public SmallWindowLook of MouseLookObj (properties priorityColor ctlCYAN xMin 153 xMax 202 yMin 94 yMax 128))
(instance public BayWindowLook of MouseLookObj (properties priorityColor ctlCYAN xMin 45 xMax 96 yMin 107 yMax 144))
(instance public WreathLook of MouseLookObj (properties priorityColor ctlGREEN xMin 125 xMax 143 yMin 123 yMax 139))
(instance public SmallTreeLook of MouseLookObj (properties priorityColor ctlGREEN xMin 72 xMax 91 yMin 122 yMax 143))
(instance public WoodPileLook of MouseLookObj (properties priorityColor ctlBROWN xMin 75 xMax 106 yMin 141 yMax 163))
(instance public SnowLook of MouseLookObj (properties priorityColor ctlBLACK xMin 0 xMax 320 yMin 114 yMax 190))
(instance public SnowBankLook of MouseLookObj (properties priorityColor ctlWHITE xMin 285 xMax 320 yMin 158 yMax 190))
(instance public FootprintLook of MouseLookObj (properties priorityColor ctlTEAL xMin 197 xMax 293 yMin 153 yMax 190))
(instance public SnowmanLook of MouseLookObj (properties priorityColor ctlWHITE xMin 0 xMax 45 yMin 122 yMax 190))
(instance public ForestLook of MouseLookObj (properties priorityColor ctlMAROON xMin 0 xMax 320 yMin 13 yMax 138))
(instance public DoorLook of MouseLookObj (properties priorityColor ctlCYAN xMin 124 xMax 147 yMin 109 yMax 153))
(instance public SleighLook of MouseLookObj (properties priorityColor ctlWHITE xMin 161 xMax 204 yMin 64 yMax 107))
/******************************************************************************/

// sciAudio
(instance aud of sciAudio
   (properties)
   (method (init)
      (super:init())
   )
)
