REM
REM Saves the content of BigScreenBuffer to OutFile as a PPM graphic file.
REM Returns 0 if everything went fine, non-zero if a problem occured.
REM


FUNCTION SavePpmFile(BYREF OutFile AS STRING, BYREF xlimit AS INTEGER, BYREF ylimit AS INTEGER) AS BYTE
  DIM AS BYTE Result = 0
  DIM AS INTEGER x, y, PpmFileHandler', WrapingCount = 0
  PpmFileHandler = FREEFILE
  OPEN OutFile FOR OUTPUT AS PpmFileHandler
  REM Write PPM header
  PRINT #PpmFileHandler, "P6" + CHR(10);
  PRINT #PpmFileHandler, "# Generated by ANSiMat v" & pVer + CHR(10);
  PRINT #PpmFileHandler, "" & xlimit & " " & ylimit & CHR(10);
  PRINT #PpmFileHandler, "255"; CHR(10);
  REM Write PPM data
  FOR y = 0 TO ylimit - 1
    FOR x = 0 TO xlimit - 1
      PRINT #PpmFileHandler, CHR((AnsiPallette(BigScreenBuffer(x, y)) SHR 16) AND &b11111111);  ' Red
      PRINT #PpmFileHandler, CHR((AnsiPallette(BigScreenBuffer(x, y)) SHR 8) AND &b11111111);  ' Green
      PRINT #PpmFileHandler, CHR(AnsiPallette(BigScreenBuffer(x, y)) AND &b11111111);  ' Blue
    NEXT x
  NEXT y
  CLOSE #PpmFileHandler
  RETURN Result
END FUNCTION
