;-------------------------------------------------------------------------------
; FunMErgS ... Funktion mit Ergebnisspeicher
; Eine Klasse von Funktionen, deren Ergebnis in einem Kurzzeitgedchtnis
; gespeichert wird.
;
; Dies ist sinnvoll, da beispielsweise Treppen nicht in einer einzigen
; Stellung mehrmals berechnet zu werden brauchen.
;
; Die Variable ERGEBNISSE speichert eine Liste von Paaren, die aus
; Parametersatz und Ergebnis bestehen.
;-------------------------------------------------------------------------------
(setq FUNMERGS '(object () () ()))

(defvar FUNMERGS Ergebnisse)

(defmethod FUNMERGS forgetit ()
   (set-value self Ergebnisse nil)
)

(defun FUNMERGS-Hilfe (Ergebnisse Parameters)
   (cond ((null Ergebnisse) 'not-found)
         ((equal (caar Ergebnisse) Parameters) (cadar Ergebnisse))
         (t (FUNMERGS-Hilfe (cdr Ergebnisse) Parameters))
   )
)

(defmethod FUNMERGS trytofind (Parameters)
   (let (ergebnisse)
      (setq ergebnisse (get-value self Ergebnisse))
      (FUNMERGS-Hilfe ergebnisse Parameters)
   )
)

;--- Diese Methode muss bei Applikationsobjekten abgeleitet werden: ---
(defmethod FUNMERGS doit (&rest irgendwas)
   'dummy
)

;--- Die Applikationen ist dies die Schnittstelle nach aussen: ---
(defmethod FUNMERGS get-result (&rest Parameters)
   (let (result)
      (setq result (send self trytofind Parameters))
      (if (eql result 'not-found)
          (let (ergebnisse)
              (setq ergebnisse (get-value self ergebnisse))
              (setq result (eval `(send self doit ,@Parameters)))
              (setq ergebnisse (cons (list parameters result) ergebnisse))
              (set-value self ergebnisse ergebnisse)
          )
      )
      result
   )
)

