;-------------------------------------------------------------------------------
; In diesem File sollen sich alle Regeln befinden, die fr Prioritaeten
; zwischen Zielen verantwortlich sind. Begonnen am 8.10.1994
;-------------------------------------------------------------------------------



; Stillgelegte Regeln mssen nil liefern, sonst geht der Vergleich schief


;-------------------------------------------------------------------------------
; Vor jeder Ausfuehrung irgendeiner Prozedur soll das Gesamtsystem gefragt
; werden, ob zuvor andere Prozeduren aktiviert werden sollen
;-------------------------------------------------------------------------------
(setq Aufrufwnsche '
   (
     ($$$Ecktripel             (regel-40))
     ($$$rand-besetzen         (regel-39))
     ($$$kette-behandeln       (regel-1 regel-5 regel-11 regel-44 regel-49 regel-53))
     ($$$retten                (regel-37))
     ($$$schlagen-verhindern   (regel-2 regel-7 regel-8 regel-10))
     ($$$besetzen              (regel-3                 ))
     ($$$shimari-punkt         (regel-4                 ))
     ($$$treppe-starten        (regel-6 regel-12        ))
     ($$$treppendroher         (regel-48                ))
     ($$$kontextbezogen        (regel-2 regel-9         ))
     ($$$kontextbezogen-setzen (regel-23 regel-24 regel-58))
     ($$$abdichten             (regel-13 regel-17 regel-28 regel-33 regel-52))
     ($$$abdichtpunkt          (regel-51                ))
     ($$$augenwert-verbessern  (regel-60
                                regel-61
                                regel-62
                                regel-63
                                regel-64
                                regel-67
                                regel-68
                                regel-69
                               ))
     ($$$augenpunkt            (regel-59 regel-71       ))
     ($$$freiheit-nehmen       (regel-14 regel-19 regel-20 ))
     ($$$formzug               (regel-50                ))
     ($$$fluchtsprung          (regel-15 regel-46       ))
     ($$$schneiden             (regel-16                ))
     ($$$nachbarn-atarisieren  (regel-21 regel-26 regel-27 regel-45))
     ($$$invasion-verhindern   (regel-22                ))
     ($$$verbinden             (regel-25 regel-30 regel-36 regel-43))
     ($$$fest-verbinden        (regel-29 regel-38 regel-47))
     ($$$irgendein-formzug     (regel-54                  ))
     ($$$irgendein-vorgeschlagener-zug
                               (regel-73
                                regel-74
                               ))
     ($$$irgendeine-basis      (regel-65 regel-66))
     ($$$endspiel-neutralzug   (
                                regel-31
                                regel-32
                                regel-34
                                regel-35
                                regel-42
                                regel-56
                                regel-57
                                regel-72
                               )
     )
     ($$$aussetzen             (regel-55                ))
     ($$$atari-verhindern      (regel-70                ))
   )
)








;-------------------------------------------------------------------------------
; Alle initialen Ziele auf einmal vorschlagen
;-------------------------------------------------------------------------------
(defun Regel-0 ()

;  (ziel-einplanen '($$$spielerkette   0)          0)

   (if muster-eckzuege
       (ziel-einplanen '($$$eck-besetzen   0)      0)
   )
   (if muster-randzuege
       (ziel-einplanen '($$$rand-besetzen  0)      0)
   )
   (ziel-einplanen '($$$aussetzen      0)          0)
   (if muster-shimaris
       (ziel-einplanen '($$$shimari        0)      0)
   )
   (if muster-ecktripel
       (ziel-einplanen '($$$ecktripel      0)      0)
   )
   (if muster-invasion-verhindern
       (ziel-einplanen '($$$invasion-verhindern 0) 0)
   )
   (ziel-einplanen '($$$endspiel-neutralzug 0)     0)
;  (ziel-einplanen '($$$lokal-optimal  0)      5)


  ;----------------------------------------------------
  ; Alle Gruppen mit strategischem Wert <> 0 behandeln
  ;----------------------------------------------------
  (dolist (x (strategiewerte) nil)
     (ziel-einplanen (list '$$$kette-behandeln (car x)) (cadr x))
  )

  ;----------------------------------------------------
  ; Alle atarisierten Ketten sind zu behandeln
  ;----------------------------------------------------
  (dolist (x (!ketten) nil)
     (if (eql 1 (length (!liberties x)))
         (ziel-einplanen (list '$$$kette-behandeln x) 0)
     )
  )


  (garbage-collection)


  ;----------------------------------------------
  ; Alle Vorschlaege aus Muster-Vorschlaege holen
  ;----------------------------------------------
  (dolist (x muster-vorschlaege nil)
     (ziel-einplanen (list '$$$festwert (car x)) (cadr x))
  )

  ;------------------------------------------------------------------------
  ; Falls fuer eine Kette eine Basis gebildet werden kann, dies vorschlagen
  ;------------------------------------------------------------------------
  (if muster-basiszuege
      (ziel-einplanen '($$$irgendeine-basis  0) 1)
  )

  ;----------------------------------------------
  ; Alle Angriffe auf Steine der 4. Reihe holen
  ;----------------------------------------------
  (dolist (x muster-dreivier nil)
     (ziel-einplanen (list '$$$dreivier (car x)) 0)
  )

  ;----------------------------------------------
  ; Alle Abdichtungen als kontextfrei vorschlagen
  ;----------------------------------------------
  (if muster-abdichten
     (ziel-einplanen '($$$irgendeine-abdichtung 0) 0)
  )

  ;----------------------------------------------
  ; Alle Formzuege als kontextfrei vorschlagen
  ;----------------------------------------------
  (if muster-formzug
     (ziel-einplanen '($$$irgendein-formzug 0) 0)
  )

  ;-------------------------------------------------------
  ; Alle kontextbezogenen Zge als kontextfrei vorschlagen
  ;-------------------------------------------------------
  (if muster-kontextbezogen
     (ziel-einplanen '($$$irgendein-kontextzug 0) 0)
  )

  ; if not strategische-werte ...
  (ziel-einplanen '($$$irgendeine-kette-behandeln 0) 0)

  (ziel-einplanen '($$$irgendein-vorgeschlagener-zug 0) 0)
)











;-------------------------------------------------------------------------------
; Direkt auf einen Gegnerzug reagieren
;-------------------------------------------------------------------------------
(defun Regel-1 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kette-behandeln)
            (eql Prdikat2 '$$$spielerkette   )
       ) -1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, eine atarisierte eigene Kette zu retten, als einen
; kontextbezogenen Zug zu machen
;-------------------------------------------------------------------------------
(defun regel-2 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$schlagen-verhindern)
       ) -1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, einen Punkt zu besetzen, der mehr Freiheiten liefert
;-------------------------------------------------------------------------------
(defun regel-3 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$besetzen)
            (eql Prdikat2 '$$$besetzen)
            (> (!point-liberties Argument1) (!point-liberties Argument2))
       ) 1
   )
)



(defun regel-4 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$shimari-punkt)
            (eql Prdikat2 '$$$shimari-punkt)
            (> (!zobrist Argument1) (!zobrist Argument2))
       ) 1
   )
)



;-------------------------------------------------------------------------------
; Bei einem lokalen Kampf sind zuerst Ketten mit 1 Freiheit zu retten
;-------------------------------------------------------------------------------
(defun regel-5 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kette-behandeln)
            (eql Prdikat2 '$$$kette-behandeln)
            (not (eql Argument1 Argument2))
            (eql 1 (length (!liberties Argument1)))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, eine beteiligte Kette mit einer Treppe zu fangen, als
; ein Auge zu machen
;-------------------------------------------------------------------------------
(defun regel-6 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$treppe-starten)
            (eql Prdikat2 '$$$auge-machen)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es i. wichtiger, e. atarisierte eigene Kette zu retten, als ein Auge zu machen
;-------------------------------------------------------------------------------
(defun regel-7 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schlagen-verhindern)
            (eql Prdikat2 '$$$auge-machen)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine atarisierte eigene Kette zu retten, als einer
; benachbarten Kette eine Freiheit zu nehmen
;-------------------------------------------------------------------------------
(defun regel-8 (Prdikat1 Argument1 Prdikat2 Argument2)
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, einen kontextbezogenen Zug zu machen als einen Fluchtsprung
;-------------------------------------------------------------------------------
(defun regel-9 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$fluchtsprung)
       ) 1
   )
)




;-------------------------------------------------------------------------------
; Es ist wichtiger, eine atarisierte eigene Kette zu retten, als einer
; Nachbarkette eine Freiheit zu nehmen
;-------------------------------------------------------------------------------
(defun regel-10 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schlagen-verhindern)
            (eql Prdikat2 '$$$freiheit-nehmen)
            (> (length (!liberties Argument2)) 1)
       ) 1
   )
)




;-------------------------------------------------------------------------------
; Es ist wichtiger, eine beruehrende Kette zu fangen, als ein Auge zu machen
;-------------------------------------------------------------------------------
(defun regel-11 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kette-behandeln)
            (eql Prdikat2 '$$$auge-machen)
            (assoc Argument1 treppen)
       ) 1
   )
)




;-------------------------------------------------------------------------------
; Es ist wichtiger, eine beteiligte Kette mit einer Treppe zu fangen, als
; einer Kette eine Freiheit zu nehmen
;-------------------------------------------------------------------------------
(defun regel-12 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$treppe-starten)
            (eql Prdikat2 '$$$freiheit-nehmen)
       ) 1
   )
)



;-------------------------------------------------------------------------------
; Es ist wichtiger, das Eindringen des Gegners zu verhindern, als ein Auge zu
; machen. Es ist ebenso wichtiger, den Gegner einzuschlieen
;-------------------------------------------------------------------------------
(defun regel-13 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$auge-machen)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Wenn man einer Gegnergruppe eine Freiheit nimmt, so sind solche Freiheiten zu
; bevorzugen, die auch gleichzeitig schneiden
;-------------------------------------------------------------------------------
(defun regel-14 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$freiheit-nehmen)
            (eql Prdikat2 '$$$freiheit-nehmen)
            (assoc Argument1 muster-schneiden)
       ) 1
   )
)




;-------------------------------------------------------------------------------
; Ein Fluchtsprung ist wichtiger als ein Auge
;-------------------------------------------------------------------------------
(defun regel-15 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$fluchtsprung)
            (eql Prdikat2 '$$$auge-machen)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Ein Schnitt ist wichtiger als ein Auge
;-------------------------------------------------------------------------------
(defun regel-16 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schneiden)
            (eql Prdikat2 '$$$auge-machen)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Falls eine Kette mehr als drei Freiheiten hat, ist es wichtiger, sie
; abzudichten, als ihr eine Freiheit zu nehmen
;-------------------------------------------------------------------------------
(defun regel-17 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$freiheit-nehmen)
            (eql Prdikat2 '$$$abdichten)
            (eql Argument1 Argument2)
            (> (length (!liberties Argument1)) 3)
       ) -1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, eine eigene Kette, die von einer Treppe bedroht ist, zu
; retten, als einer feindlichen Kette mit mehr als 2 Freih. e. Freih. zu nehmen
;-------------------------------------------------------------------------------
(defun regel-19 (Prdikat1 Argument1 Prdikat2 Argument2)
;  (fuer-alle '($$$freiheit-nehmen ?a)
;    '(
;      (if (> (length (!liberties ?a)) 2)
;          (dolist (x (!neighbours ?a) nil)
;             (let (temp)
;                (setq temp (assoc x treppen))
;                (if temp
;                    (prior (list '$$$treppe-verhindern (cadr temp))
;                           (list '$$$freiheit-nehmen ?a)
;                    )
;                )
;             )
;          )
;      )
;     )
;  )
;  (if (and
;           (eql Prdikat1 '$$$???????????????)
;           (eql Prdikat2 '$$$?????????)
;      ) -1
;  )
nil
)

;-------------------------------------------------------------------------------
; Ein Hane-Zug ist wichtiger, als einer Kette irgendeine Freiheit zu nehmen
;-------------------------------------------------------------------------------
(defun regel-20 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$hane)
            (eql Prdikat2 '$$$freiheit-nehmen)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, e. atarisierte Kette zu retten als einen Nachbarn zu ataris.
;-------------------------------------------------------------------------------
(defun regel-21 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schlagen-verhindern)
            (eql Prdikat2 '$$$nachbarn-atarisieren)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, einen kontextfreien Abdichtungszug zu machen, als eine
; Invasion zu verhindern
;-------------------------------------------------------------------------------
(defun regel-22 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendeine-abdichtung)
            (eql Prdikat2 '$$$invasion-verhindern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Wenn es mehrere kontextbezogene Zge gibt, so sind berhrende vorzuziehen
;-------------------------------------------------------------------------------
(defun regel-23 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen-setzen)
            (eql Prdikat2 '$$$kontextbezogen-setzen)
            (not (eql Argument1 Argument2))
            (<  (!point-liberties Argument1) 4)
            (>= (!point-liberties Argument2) 4)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Wenn es mehrere kontextbezogene Zge gibt, so sind die vorzuziehen, die
; am wenigsten Freiheiten besitzen
;-------------------------------------------------------------------------------
(defun regel-24 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen-setzen)
            (eql Prdikat2 '$$$kontextbezogen-setzen)
            (not (eql Argument1 Argument2))
            (< (!point-liberties Argument1) (!point-liberties Argument2))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; In einem kontextbezogenen Zug steckt mehr Information als in einem
; Verbindungszug. Daher ist es besser, einen kontextbezogenen Zug als
; einen Verbindungszug zu machen
;-------------------------------------------------------------------------------
(defun regel-25 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen-setzen)
            (eql Prdikat2 '$$$verbinden)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, eine beteiligte Kette mit einer Treppe zu fangen, als
; diese Kette einfach von irgendwoher zu atarisieren
;-------------------------------------------------------------------------------
(defun regel-26 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$trepp-fangen)
            (eql Prdikat2 '$$$nachbarn-atarisieren)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine benachbarte Kette zu behandeln, als sie zu atarisieren
;-------------------------------------------------------------------------------
(defun regel-27 (Prdikat1 Argument1 Prdikat2 Argument2)
;  (fuer-alle '($$$nachbarn-atarisieren ?a)
;     '(
;       (garbage-collection)
;       (let (n)
;          (setq n (!neighbours ?a))
;          (dolist (y n nil)
;             (fuer-alle (list '$$$toeten          y)
;               '(
;                 (prior (list '$$$toeten          y) (list '$$$nachbarn-atarisieren ?a))
;                )
;             )
;          )
;       )
;      )
;  )
nil
)

;-------------------------------------------------------------------------------
; Es ist besser, eine Kette mit einer Treppe zu fangen als sie abzudichten
;-------------------------------------------------------------------------------
(defun regel-28 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$trepp-fangen)
            (eql Prdikat2 '$$$abdichten)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Einen kontextbezogenen Zug zu machen ist besser als einen Fest-Verbindungszug
; zu machen
;-------------------------------------------------------------------------------
(defun regel-29 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$fest-verbinden)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, ein Gebiet abzudichten bzw. den Gegner abzudichten, als
; einen Verbindungszug zu machen
;-------------------------------------------------------------------------------
(defun regel-30 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$verbinden)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, einen 3-4-Angriff zu starten, als einen Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-31 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$dreivier)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, ein Eck zu besetzen, als einen Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-32 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$Eck-Besetzen)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine atarisierte eigene Kette zu retten, als einen
; Abdichtungszug zu machen
;-------------------------------------------------------------------------------
(defun regel-33 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$schlagen-verhindern)
       ) -1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, irgendeinen Abdichtungszug zu machen, als einen
; Endspiel-Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-34 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendeine-abdichtung)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, irgendeinen Kontextzug zu machen, als einen
; Endspiel-Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-35 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendein-kontextzug)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Ein kontextbezogener Zug ist besser als ein Verbindungszug
;-------------------------------------------------------------------------------
(defun regel-36 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$verbinden)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Wenn eine Kette mehr Feinde hat, dann ist es wichtiger, sie zu retten als eine
; Kette mit weniger Feinden
;-------------------------------------------------------------------------------
(defun regel-37 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$retten)
            (eql Prdikat2 '$$$retten)
            (> (count-of-enemies Argument1) (count-of-enemies Argument2))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Wenn eine feindliche Kette weniger als 4 Freiheiten hat, so ist es besser, sie
; abzudichten, als eine beruehrende Kette fest zu verbinden
;-------------------------------------------------------------------------------
(defun regel-38 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$fest-verbinden)
            (< (length (!liberties Argument1)) 4)
            (!touches Argument2 Argument1)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, ein Eck zu besetzen als den Rand
;-------------------------------------------------------------------------------
(defun regel-39 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$eck-besetzen)
            (eql Prdikat2 '$$$rand-besetzen)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Ein Eck zu besetzen ist wichtiger, als ein Ecktripel zu bilden
;-------------------------------------------------------------------------------
(defun regel-40 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$eck-besetzen)
            (eql Prdikat2 '$$$ecktripel)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, irgendeinen Formzug zu machen, als einen
; Endspiel-Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-41 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendein-formzug)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist besser, irgendeine Kette zu behandeln, als einen Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-42 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendeine-kette-behandeln)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Falls eine Kette mehr als 1 Freiheit hat, ist es besser, einen Formzug zu
; machen als sie zu verbinden
;-------------------------------------------------------------------------------
(defun regel-43 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$formzug)
            (eql Prdikat2 '$$$verbinden)
            (eql Argument1 Argument2)
            (> (length (!liberties Argument1)) 1)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, das Schlagen einer Kette zu verhindern, als eine Kette mit
; mehr als einer Freiheit zu behandeln
;-------------------------------------------------------------------------------
(defun regel-44 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schlagen-verhindern)
            (eql Prdikat2 '$$$behandeln)
            (> (length (!liberties Argument2)) 1)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine Kette mit zwei Freiheiten zu behandeln als sie zu
; atarisieren
;-------------------------------------------------------------------------------
(defun regel-45 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$nachbarn-atarisieren)
            (eql Prdikat2 '$$$kette-behandeln)
            (eql (length (!liberties Argument2)) 2)
       )
       -1
   )
)

;-------------------------------------------------------------------------------
; Ein Abdichtungszug ist besser als ein Fluchtzug
;-------------------------------------------------------------------------------
(defun regel-46 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$fluchtsprung)
            (eql Argument1 Argument2)
       )
       1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, ein Atari durch den Gegner zu verhindern, als die Kette
; einfach so fest zu verbinden.
;-------------------------------------------------------------------------------
(defun regel-47 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$atari-verhindern)
            (eql Prdikat2 '$$$fest-verbinden)
            (eql Argument1 Argument2)
       )
       1
   )
)

;-------------------------------------------------------------------------------
; Wenn eine eigene Kette durch eine Treppe gefangen werden kann, so ist es
; wichtiger, sie zu retten, als eine Kette beim Gegner mit Treppe zu bedrohen
;-------------------------------------------------------------------------------
(defun regel-48 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$retten)
            (eql Prdikat2 '$$$treppendroher)
       )
       1
   )
)

;-------------------------------------------------------------------------------
; Wenn eine Kette mehr Feinde hat, dann ist es wichtiger, sie zu behandeln als
; eine Kette mit weniger Feinden
;-------------------------------------------------------------------------------
(defun regel-49 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$behandeln)
            (eql Prdikat2 '$$$behandeln)
            (> (count-of-enemies Argument1) (count-of-enemies Argument2))
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist besser, eine Kette zu atarisieren, als einen Formzug zu machen
;-------------------------------------------------------------------------------
(defun regel-50 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$nachbarn-atarisieren)
            (eql Prdikat2 '$$$formzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Unter zwei Abdichtpunkten sind einflussmaessig groessere zu bevorzugen
;-------------------------------------------------------------------------------
(defun regel-51 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichtpunkt)
            (eql Prdikat2 '$$$abdichtpunkt)
            (not (eql Argument1 Argument2))
            (> (zv Argument1) (zv Argument2))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Ein kontextbezogener Zug ist wichtiger als ein normaler Abdichtzug
;-------------------------------------------------------------------------------
(defun regel-52 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$abdichten)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine Kette mit weniger Freiheiten zu behandeln als eine
; Kette, die weniger Freiheiten besitzt.
; Diese Regel ist fraglich !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;-------------------------------------------------------------------------------
(defun regel-53 (Prdikat1 Argument1 Prdikat2 Argument2)
;  (if (and
;           (eql Prdikat1 '$$$kette-behandeln)
;           (eql Prdikat2 '$$$kette-behandeln)
;           (< (length (!liberties Argument1)) (length (!liberties Argument2)))
;      ) 1
;  )
)

;-------------------------------------------------------------------------------
; Wenn es darum geht, irgendeinen Zug zu machen, sind kontextbezogene Zuege
; besser als Formzuege
;-------------------------------------------------------------------------------
(defun regel-54 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendein-kontextzug)
            (eql Prdikat2 '$$$irgendein-formzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist besser, irgendeinen vorgeschlagenen Zug zu machen, als auszusetzen
;-------------------------------------------------------------------------------
(defun regel-55 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendein-vorgeschlagener-zug)
            (eql Prdikat2 '$$$aussetzen)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Ein Shimari ist besser als ein Endspiel-Neutralzug
;-------------------------------------------------------------------------------
(defun regel-56 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$shimari)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist besser, irgendeinen vorgeschlagenen Zug zu machen, als einen
; Endspiel-Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-57 (Prdikat1 Argument1 Prdikat2 Argument2)
;  (if (and
;           (eql Prdikat1 '$$$endspiel-neutralzug)
;           (eql Prdikat2 '$$$irgendein-vorgeschlagener-zug)
;      ) -1
;  )
)

;-------------------------------------------------------------------------------
; Wenn es mehrere kontextbezogene Zge gibt, so sind die vorzuziehen, die
; am weitesten am Rand liegen
;-------------------------------------------------------------------------------
(defun regel-58 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen-setzen)
            (eql Prdikat2 '$$$kontextbezogen-setzen)
            (not (eql Argument1 Argument2))
            (< (!hoehe Argument1) (!hoehe Argument2))
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Wenn es mehrere Zuege gibt, um den Augenwert einer Kette zu verbessern, so
; sind diejenigen vorzuziehen, die am freihesten in der Landschaft stehen
;-------------------------------------------------------------------------------
(defun regel-59 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$augenpunkt)
            (eql Prdikat2 '$$$augenpunkt)
            (not (eql Argument1 Argument2))
            (> (!point-liberties Argument1) (!point-liberties Argument2))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Es ist wichtiger, das Schlagen einer eigenen Kette zu verhindern als
; den Augenwert dieser Kette zu verbessern
;-------------------------------------------------------------------------------
(defun regel-60 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$schlagen-verhindern)
            (eql Prdikat2 '$$$augenwert-verbessern)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; In einem kontextbezogenen Zug steckt mehr Information als einfach in
; einem Augenverbesserungszug
;-------------------------------------------------------------------------------
(defun regel-61 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kontextbezogen)
            (eql Prdikat2 '$$$augenwert-verbessern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Abdichten ist besser, als den Augenwert zu verbessern
;-------------------------------------------------------------------------------
(defun regel-62 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$abdichten)
            (eql Prdikat2 '$$$augenwert-verbessern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Einen Nachbarn zu atarisieren ist besser, als den Augenwert zu verbessern
;-------------------------------------------------------------------------------
(defun regel-63 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$nachbarn-atarisieren)
            (eql Prdikat2 '$$$augenwert-verbessern)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Die Atarisierung einer Kette zu verhindern ist besser,
; als den Augenwert zu verbessern
;-------------------------------------------------------------------------------
(defun regel-64 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$atari-verhindern)
            (eql Prdikat2 '$$$augenwert-verbessern)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Ein Eck zu besetzen, ist wichtiger als irgendeine Basis
;-------------------------------------------------------------------------------
(defun regel-65 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$eck-besetzen)
            (eql Prdikat2 '$$$irgendeine-basis)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Ein Shimari ist besser als irgendeine eine Basis-Ausdehnung
;-------------------------------------------------------------------------------
(defun regel-66 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$shimari)
            (eql Prdikat2 '$$$irgendeine-basis)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine Kette zu behandeln, als gleich den Augenwert einer
; anderen Kette zu verbessern
;-------------------------------------------------------------------------------
(defun regel-67 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$kette-behandeln)
            (eql Prdikat2 '$$$augenwert-verbessern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, eine Kette zu retten, als gleich den Augenwert einer
; anderen Kette zu verbessern
;-------------------------------------------------------------------------------
(defun regel-68 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$retten)
            (eql Prdikat2 '$$$augenwert-verbessern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Mit Vorhand zu leben drohen ist besser, als den Augenwert zu verbessern
;-------------------------------------------------------------------------------
(defun regel-69 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$lebensvorhand)
            (eql Prdikat2 '$$$augenwert-verbessern)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Es ist wichtiger, den Nachbarn einer Kette zu atarisieren, als ein
; Atari auf diese Kette zu verhindern
;-------------------------------------------------------------------------------
(defun regel-70 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$nachbarn-atarisieren)
            (eql Prdikat2 '$$$atari-verhindern)
            (eql Argument1 Argument2)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Wenn es mehrere Zuege gibt, um den Augenwert einer Kette zu verbessern, so
; sind diejenigen vorzuziehen, die am weitesten im Feindgebiet stehen
;-------------------------------------------------------------------------------
(defun regel-71 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$augenpunkt)
            (eql Prdikat2 '$$$augenpunkt)
            (not (eql Argument1 Argument2))
            (< (!zobrist Argument1) (!zobrist Argument2))
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Den Rand zu besetzen ist wichtiger, als einen Endspiel-Neutralzug zu machen
;-------------------------------------------------------------------------------
(defun regel-72 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$rand-besetzen)
            (eql Prdikat2 '$$$endspiel-neutralzug)
       ) 1
   )
)

;-------------------------------------------------------------------------------
; Den Rand zu besetzen ist wichtiger, als irgendeinen vorgeschlagenen Zug
; zu machen
;-------------------------------------------------------------------------------
(defun regel-73 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$rand-besetzen)
            (eql Prdikat2 '$$$irgendein-vorgeschlagener-zug)
       ) 1
   )
)


;-------------------------------------------------------------------------------
; Irgendeine Kette zu behandeln ist wichtiger, als irgendeinen grossen Zug zu
; machen
;-------------------------------------------------------------------------------
(defun regel-74 (Prdikat1 Argument1 Prdikat2 Argument2)
   (if (and
            (eql Prdikat1 '$$$irgendeine-kette-behandeln)
            (eql Prdikat2 '$$$irgendein-vorgeschlagener-zug)
       ) 1
   )
)


