uses Vaznik,Lacrt;
const KNHMAGIC = 8888883;

      pocet_palet:longint=0;

type
    pPCXzasobnik = ^tPCXzasobnik;
    tPCXzasobnik = object
       pcx:string;        { nazev souboru }
       vel:dword;
       is_pal:boolean;
       pal:array[0..767] of byte;
       Constructor Init(s:string);
       end;

PCX_Header = Record
   Manufacturer      : Byte;
   Version           : Byte;
   Encoding          : Byte;
   BitsPerPixel      : Byte;
   xmin,ymin         : Word;
   xmax,ymax         : Word;
   Hdpi,Vdpi         : Word;
   Palette           : Array[0..47] of Byte;
   Reserved          : Byte;
   ColorPlanes       : Byte;
   BytesPerLine      : Word;
   PalettenInfo      : Word;
   H_ScreenSize      : Word;
   V_ScreenSize      : Word;
   CTM_definedYMax   : Word;
   CTM_definedXMax   : Word;
   Nothing_else_shit : Array[1..52] of Byte;
   End;

var PCXzasobnik:PVaznik;
    knihovna:string;

Procedure FatalError(s:string;b:byte);
begin
writeln(s);
Halt(b);
end;

Constructor TPCXzasobnik.Init(s:string);
var f:file;
    i:longint;
    obr:pcx_header;
begin
Assign(f,s);
Reset(f,1);
vel:=FileSize(f);
BlockRead(f,obr,sizeof(pcx_header),i);
if obr.manufacturer<>$a then FatalError(s+': Neni to soubor PCX.',0);
(*if obr.version<>$5 then FatalError(s+': Neni ve standardnim formatu.',0);*)
is_pal:=obr.colorplanes=1;        { ma paletu? }
if is_pal then
   begin
   Seek(f,vel-768);
   BlockRead(f,pal,768);
   dec(vel,768);
   inc(pocet_palet);
   end;
pcx:=s;
Close(f);
end;

Procedure UlozPCXKnihovnu;
var a,b,c:dword;
    v:PVaznik;
    f,knh:file;
    g:pointer;
    t:PPCXzasobnik;
    max1:dword;
begin
max1:=PCXzasobnik^.PocetPrvku;

Assign(knh,knihovna);
Rewrite(knh,1);
BlockWrite(knh,KNHMAGIC,4);
BlockWrite(knh,max1,4);
BlockWrite(knh,pocet_palet,4);

b:=12+(max1+max1)*4;            { offset, na kterem bude prvni PCX }

v:=PCXzasobnik^.dalsi;
for a:=1 to max1 do        { ulozi seznam offsetu }
   begin
   t:=v^.vazba;
   BlockWrite(knh,b,4);
   inc(b,t^.vel);
   v:=v^.dalsi;
   end;

v:=PCXzasobnik^.dalsi;
for a:=1 to max1 do        { Ted ulozim odkazy na palety }
   begin
   t:=v^.vazba;
   if t^.is_pal then begin c:=b;inc(b,768);end else c:=0;

   writeln(t^.pcx,' : ',c);

   BlockWrite(knh,c,4);
   v:=v^.dalsi;
   end;

v:=PCXzasobnik^.dalsi;
for a:=1 to max1 do
   begin
   t:=v^.vazba;
   b:=t^.vel;
   GetMem(g,b);
   Assign(f,t^.pcx);
   Reset(f,1);
   Blockread(f,g^,b,c);
   if b<>c then FatalError('Objevila se prazvlastni chyba.',0);
   Close(f);
   BlockWrite(knh,g^,b);
   FreeMem(g,b);
   v:=v^.dalsi;
   end;

v:=PCXzasobnik^.dalsi;
for a:=1 to max1 do
   begin
   t:=v^.vazba;
   if t^.is_pal then BlockWrite(knh,t^.pal,768);
   v:=v^.dalsi;
   end;

Close(knh);
end;

Procedure Helpik;
begin
writeln('Pouziti:'#13#10'KNIHOMOL <@filelist> <knihovna>'#13#10);
writeln('Filelist muzes vytvorit treba pomoci "DIR /B *.PCX > filelist.txt"');
writeln('Umi zpracovat 256 barevne i truecolorove.');
Halt(0);
end;

Procedure Zavinac(s:string);
var t:text;
    h:ppcxzasobnik;
    v:string;
begin
delete(s,1,1);
Assign(t,s);
Reset(t);
while not Eof(t) do
   begin
   readln(t,v);
   if ExistFile(v) then
      begin
      h:=new(pPCXzasobnik,init(v));
      pcxzasobnik^.InitNext(h);
      end;
   end;
Close(t);
end;

Procedure Parser;
var a,b:byte;
        s:string;
begin
knihovna:='';
b:=ParamCount;
if b<2 then Helpik;
for a:=1 to b do
  begin
  s:=Convert_Up(ParamStr(a));
  case s[1] of
    '@':Zavinac(s);
    else knihovna:=s;
  end;
  end;
end;


begin
PCXzasobnik:=New(PVaznik,Init(nil,nil));
Parser;
UlozPCXknihovnu;
end.
