{****************************************************************************}
{Unit VNM_WMF - it is a addon unit for graphics library VenomGFX.            }
{It bring a loader for .WMF graphics files                                   }
{   It defines function Load_WMF                                             }
{      written by BearWindows, adjusted by Laaca                             }
{****************************************************************************}

unit VNM_WMF;
{$IFDEF VER2}{$CALLING OLDFPCCALL}{$ENDIF}


interface
Uses VenomGFX;


Function Load_WMF(s:string;var dest:VirtualWindow):longint;
{Dest must be already defined!}

implementation
uses GrpFile,objects;

Const

{konstanty vyplni prevzate z jednotky Graph}
EmptyFill     = 0; {vybarvi barvou pozadi}
SolidFill     = 1; {plosne vybarvovani}
LineFill      = 2; {styl ---}
LtSlashFill   = 3; {styl ///}
SlashFill     = 4; {styl /// tucne}
BkSlashFill   = 5; {styl \\\ tucne}
LtBkSlashFill = 6; {styl \\\}
HatchFill     = 7; {ctverecky}
xHatchFill    = 8; {ctverecky nasikmo}
InterleaveFill= 9; {interleaving line}
WideDotFill   = 10;{tecky ridce}
CloseDotFill  = 11;{tecky huste}
UserFill      = 12;{uzivatelsky definovane}

{konstanty rezu pisem prevzate z jednotky Graph}
DefaultFont   = 0;
TriplexFont   = 1;
SmallFont     = 2;
SansSerifFont = 3;
GothicFont    = 4;

type
   RGBQuad = packed Record Rd, Gr, Bl, Rs : Byte;End;
   MFRect = packed Record bottom, right, top, left : Integer;End;
   TRect = packed Record left, top, right, bottom : Integer;End;

   Bod = packed record x,y:smallint;end;

   mfHeader = packed Record
      mtType : Word;
      mtHeaderSize : Word;
      mtVersion : Word;
      mtSize : LongInt;
      mtNoObjects : Word;
      mtMaxRecord : LongInt;
      mtNoParameters : Word;
      End;

   AldusmfHeader = packed Record
      key : LongInt;
      hmf : Word;
      bbox : TRect;
      inch : Word;
      reserved : LongInt;
      checksum : Word;
      End;

   MetaRecord = packed Record
      rdSize : LongInt;
      rdFunction : Word;
      rdParm : Array[0..0] Of Word;
      End;


   {PolygonType = Array[1..10000] Of PointType;}


{============================================================================}

Function LoadImageWMF(mystrm:pstream;var dest:VirtualWindow):longint;
const MAX_HRAN = 512;

Var
 Pal,Tool: Array[0..255] Of Byte;
 barva: Array[0..255] Of word;
 cara_styl,cara_sire,vypln_styl:  Array[0..255] Of word;
 MaxPts : Array[0..254] Of Integer;
 Tstr : string;
 CR, R : MFRect;
 RGBN : RGBQuad;
 Poly : Polytype;
 Body : array[1..MAX_HRAN] of Bod;
 WMFHead : File;

 mfRec : MetaRecord;
 mfHdr : mfHeader;
 mfAHdr : AldusmfHeader;
 Rect : TRect;

 mfkey:dword;
 yD, yF, xF, xVE, yVE, L, MFpos : LongInt;
 PSt, xWE, yWE, xWO, yWO, X1, X0, Y0, Gd, Gm : Integer;
 I, F, FF, Rs, Nh, MaxPt:Word;
 Akt_BarvaPopredi, Akt_BarvaPozadi: Word;
 Akt_vyplnstyl, Akt_carastyl, Akt_carasire:word;
 fStyle, N, J, F0, F1, F2, F3, F4, F5, PalReg : Byte;
 BrushColor, PenColor, TXTColor, Pal256 : LongInt;
 konec:boolean;
 wmf_x,wmf_y:longint;

begin
konec:=false;


For I := 0 To 255 Do
   Begin
   cara_styl[I]:=SolidLn; vypln_styl[I]:=EmptyFill;
   cara_sire[i]:=1;
   barva[I]:=0;
   Tool[I]:=0;
   Pal[I]:=0;
   End;


{POZOR, v puvodnim zdrojaku bylo Reset(WMFhead,2!!!)}

mystrm^.read(mfkey,4);
If mfKey = $9AC6CDD7 Then                {Placeable}
   Begin
   mystrm^.seek(0);
   mystrm^.read(mfAHdr,SizeOf(mfAHdr));
   mfKey := 22; {nebo 11?}
   End;

If mfKey = $00090001 Then mfKey := 0;    {NoAldus}

mystrm^.Seek(mfkey);
mystrm^.read(mfHdr,SizeOf(mfHdr));


Nh:=0;
xVE:=dest.breite;
yVE:=xVE * 3 Div 4; {pomer obrazovky?}
yD:=dest.hoehe;
yF:=0;
xF:=0;
MFpos:=18+mfKey;
PalReg:=1;

Repeat
mystrm^.Seek(mfpos);
mystrm^.Read(mfrec,6 {nebo 3???});
If mfRec.rdSize = 0 Then break;

case mfRec.rdFunction Of
  $0F7:Begin                    {CreatePalette}
       barva[Nh]:=255 {65535};
       Tool[Nh]:=3;
       N:=0;
       While Tool[N]<>0 Do Inc(N);
       Nh:=N;
       End;

  $234:mystrm^.Read(i,2);       {SelectPalette}


  {void Create's which are not supported}
  $1F9,$2FD,$6FE,$F8:Begin
                     barva[Nh]:=255;
                     Tool[Nh]:=5;
                     N:=0;
                     While Tool[N]<>0 Do Inc(N);
                     Nh:=N;
                     End;

  $209:Begin                    {SetTextColor}
       mystrm^.Read(RGBN,4);
       txtcolor:=MyRGB2word(rgbn.rd,rgbn.gr,rgbn.bl);{prevodbarvy(dword(rgbn));}  {SetColor(prevodbarvy(rgbn));}
       End;


  $20B:begin                    {SetWindowOrg}
       mystrm^.Read(yWO,2);
       mystrm^.Read(xWO,2);
       end;

  $20C:begin                    {SetWindowExt}
       mystrm^.Read(yWE,2);
       mystrm^.Read(xWE,2);
       xF:=xVE;
       yF:=yVE;

       If Abs(xWE/yWE) < (xVE/yVE) then xF:=xWE * yVE Div yWE
          else   {Stretching Left & Right}
       If Abs(xWE/yWE) > (xVE/yVE) then yF:=yWE * xVE Div xWE;
       {Stretching Up & Down}
       yF:=yF * yD Div yVE;
       xF:=Abs(xF);
       yF:=Abs(yF);
       End;

  $12D:Begin                    {SelectObject}
       mystrm^.Read(i,2);
       Case Tool[I] Of
          1:Begin
            Akt_BarvaPopredi:=barva[i];
            {SetLineStyle(cara_styl[I], 0, cara_sire);}
            Akt_carastyl := cara_styl[I];
            Akt_carasire := cara_sire[i];
            End;
          2:Begin
            Akt_BarvaPozadi:=barva[i];
            {SetfillStyle(Fill[I], Rs);}
            Akt_VyplnStyl:= vypln_styl[I];
            End;
       End{case};
       End;

  $1F0 : Begin                    {void DeleteObject}
         mystrm^.Read(i,2);
         Tool[I] := 0; barva[I] := 0;
         vypln_styl[I] := Emptyfill;
         cara_styl[I] := SolidLn;
         N := 0;
         While Tool[N] <> 0 Do Inc(N); Nh := N;
         End;

  $2FA : Begin                    {void CreatePenIndirect}
         mystrm^.Read(pst,2);
         mystrm^.Read(cara_sire[Nh],2);
         cara_sire[Nh]:=cara_sire[Nh] div 5 + 1;
          Case PSt Of
           $00 : cara_styl[Nh] := SolidLn;
           $01 : cara_styl[Nh] := DashedLn;
           $02 : cara_styl[Nh] := DottedLn;
           $03 : cara_styl[Nh] := CenterLn;
           $04 : cara_styl[Nh] := CenterLn;
           $05 : cara_styl[Nh] := SolidLn;
           $06 : cara_styl[Nh] := SolidLn;
          End;
          L := MFpos + 12;
          mystrm^.Seek(l);
          mystrm^.Read(RGBn,4);
          barva[Nh]:=MyRGB2word(RGBn.rd,RGBn.gr,RGBn.bl);
          Tool[Nh] := 1;
          N := 0;
          While Tool[N] <> 0 Do Inc(N); Nh := N;
         End;

  $2FC : Begin                    {void CreateBrushIndirect}
         mystrm^.Read(x0,2);
         mystrm^.Read(RGBn,4);
         mystrm^.Read(y0,2);

         barva[Nh] := MyRGB2word(RGBn.rd,RGBn.gr,RGBn.bl);
         Tool[Nh] := 2;

         If X0 = 0 Then vypln_styl[Nh] := SolidFill;
         If X0 = 1 Then vypln_styl[Nh] := Emptyfill; {Special Case!}
         If X0 = 2 Then
           Begin
            Case Y0 Of
             0 : vypln_styl[Nh] := LineFill;
             1 : vypln_styl[Nh] := LineFill;
             2 : vypln_styl[Nh] := BkSlashFill;
             3 : vypln_styl[Nh] := LtSlashFill;
             4 : vypln_styl[Nh] := HatchFill;
             5 : vypln_styl[Nh] := xHatchFill;
            End;
           End;
          N := 0;
          While Tool[N] <> 0 Do Inc(N); Nh := N;
         End;

  $2FB : Begin                    {void CreateFontIndirect}
          L := MFpos + 22;
          mystrm^.Seek(L);
          mystrm^.Read(i,2);
          Case (I And $F000) Of
           $0000 : fStyle := SansSerifFont;
           $1000 : fStyle := TriplexFont;
           $2000 : fStyle := SansSerifFont;
           $3000 : fStyle := SmallFont;
           $4000, $5000 : fStyle := GothicFont;
          End;
          {SetTextStyle(fStyle, 0, 4);}
          barva[Nh] := fStyle; {HACK !!! Zde se na misto barvy uklada font}
          Tool[Nh] := 4;
          N := 0;
          While Tool[N] <> 0 Do Inc(N); Nh := N;
         End;

  $324 : Begin                    {void Polygon}
         mystrm^.Read(maxpt,2);
         If MaxPt > MAX_HRAN Then MaxPt := MAX_HRAN;
         poly.num:=MaxPt;
         GetMem(poly.point,(poly.num+1)*8);
         mystrm^.read(body,maxpt*4);
         For I := 1 To MaxPt Do
             Begin
             poly.point^[i].x := (body[i].x - xWO) * xF Div xWE;
             poly.point^[i].y := (body[i].y - yWO) * yF Div yWE;
             End;
         poly.point^[0]:=poly.point^[i];

         If Akt_Vyplnstyl <> Emptyfill
            Then FilledPolygon(dest, poly, Akt_carasire,Akt_carastyl,Akt_BarvaPopredi, Akt_BarvaPozadi)
            Else Polygon(dest, poly, Akt_carasire,Akt_carastyl, Akt_BarvaPopredi);
         Kill_Poly(poly);
         End;

  $538 : Begin                    {void PolyPolygon 3.0}
         mystrm^.Read(i,2);
         For L := 0 To i-1 Do mystrm^.Read(MaxPts[L],2);
         For L := 0 To i-1 Do
             Begin
             If MaxPts[L] > MAX_HRAN Then MaxPts[L] := MAX_HRAN;
             poly.num:=MaxPts[l];
             GetMem(poly.point,(poly.num+1)*8);
             mystrm^.Read(body,MaxPts[L]*4);
             For I := 1 To MaxPts[l] Do
                 Begin
                 poly.point^[i].x := (body[i].x - xWO) * xF Div xWE;
                 poly.point^[i].y := (body[i].y - yWO) * yF Div yWE;
                 End;
             poly.point^[0]:=poly.point^[i];

             If Akt_VyplnStyl <> Emptyfill
                Then FilledPolygon(dest, poly, Akt_carasire, Akt_carastyl,Akt_BarvaPopredi, Akt_BarvaPozadi)
                Else Polygon(dest, poly, Akt_carasire,Akt_carastyl, Akt_BarvaPopredi);
             Kill_Poly(poly);
             End;
         End;

  $325 : Begin                    {void Polyline}
         mystrm^.Read(maxpt,2);
         poly.num:=MaxPt-1;
         GetMem(poly.point,(poly.num+1)*8);
         For I := 1 To MaxPt Do
             Begin
             x0:=0;
             y0:=0;
             mystrm^.Read(X0,2);
             mystrm^.Read(Y0,2);
             poly.point^[i-1].x:=(x0 - xWO) * xF Div xWE;
             poly.point^[i-1].y:=(y0 - yWO) * yF Div yWE;
             End;
         Polygon(dest,poly,Akt_carasire,Akt_carastyl,Akt_BarvaPopredi);
         Kill_Poly(poly);
         End;

  $418 : Begin                    {void Ellipse}
         mystrm^.read(r,8);
         R.left := (R.left - xWO) * xF Div xWE;
         R.right := (R.right - xWO) * xF Div xWE;
         R.top := (R.top - yWO) * yF Div yWE;
         R.bottom := (R.bottom - yWO) * yF Div yWE;
         R.left := R.left + ((R.right - R.left) Div 2);
         R.top := R.top + ((R.bottom - R.top) Div 2);
         If Akt_VyplnStyl <> Emptyfill Then
            FilledEllipse(dest,R.left, R.top, (R.right - R.left), (R.bottom - R.top), Akt_carasire, Akt_BarvaPopredi, Akt_BarvaPozadi)
            Else
            Ellipse(dest,R.left, R.top, (R.right - R.left), (R.bottom - R.top), Akt_carasire, Akt_BarvaPopredi);
         End;

  $41B : Begin                    {void Rectangle}
          mystrm^.Read(R, 8);
          R.left := (R.left - xWO) * xF Div xWE;
          R.right := (R.right - xWO) * xF Div xWE;
          R.top := (R.top - yWO) * yF Div yWE;
          R.bottom := (R.bottom - yWO) * yF Div yWE;
          If Akt_VyplnStyl <> Emptyfill Then
             Bar(dest,R.left, R.top, R.right - 1, R.bottom - 1,akt_BarvaPozadi);
          Rectangle(dest,R.left, R.top, R.right - 1, R.bottom - 1, Akt_carasire, Akt_carastyl, Akt_BarvaPopredi);
         End;

  $61C : Begin                    {void RoundRect}
          L := MFpos + 10;          {preskakuje nejake parametry ohledne}
          mystrm^.seek(L);          {zakriveni rohu?}
          mystrm^.Read(r,8);
          R.left := (R.left - xWO) * xF Div xWE;
          R.right := (R.right - xWO) * xF Div xWE;
          R.top := (R.top - yWO) * yF Div yWE;
          R.bottom := (R.bottom - yWO) * yF Div yWE;
          If Akt_VyplnStyl <> Emptyfill Then
             Bar(dest,R.left, R.top, R.right - 1, R.bottom - 1,akt_barvapozadi);
          Rectangle(dest,R.left, R.top, R.right - 1, R.bottom - 1, akt_barvapopredi);
         End;

  $548 : Begin                    {void FloodFill}
         mystrm^.Read(rgbn,4);
         mystrm^.Read(y0,2);
         mystrm^.Read(x0,2);
         X0 := (X0 - xWO) * xF Div xWE;
         Y0 := (Y0 - yWO) * yF Div yWE;
         FloodFill(dest,X0, Y0,MyRGB2word(RGBn.rd,RGBn.gr,RGBn.bl));
         End;

  $521 : Begin                    {void TextOut}
         mystrm^.Read(i,1);
         mystrm^.Read(TStr[1],I + (I And 1));
         Tstr[0]:=char(I + (I And 1));
         BlockRead(WMFHead, Y0, 2);
         BlockRead(WMFHead, X0, 2);
         X0 := (X0 - xWO) * xF Div xWE;
         Y0 := (Y0 - yWO) * yF Div yWE;
         outtext(dest,X0, Y0, Tstr,Akt_BarvaPopredi);
         End;

  $A32 : Begin                    {void ExtTextOut}
         mystrm^.Read(y0,2);
         mystrm^.Read(x0,2);
         mystrm^.Read(i,2);
         mystrm^.Read(x1,2);
         mystrm^.Read(Tstr[1],I + (I And 1));
         Tstr[0]:=char(I + (I And 1));
         X0 := (X0 - xWO) * xF Div xWE;
         Y0 := (Y0 - yWO) * yF Div yWE;
         outtext(dest,X0, Y0, Tstr,Akt_BarvaPopredi);
         End;

  $416 : Begin
         mystrm^.Read(cr,8);           {void IntersectClipRect}
         End;

  $214 : Begin                    {void MoveTo}
         mystrm^.Read(y0,2);
         mystrm^.Read(x0,2);
{          If (X0 in [CR.Left..CR.Right]) = False Then
          Begin
          If (Abs(X0-CR.Right) < Abs(X0-CR.Left))
          Then X0 := CR.Right else  X0 := CR.Left;
          End;}
 {         If not (Y0 in [CR.Top..CR.Bottom]) Then
          If (Abs(Y0-CR.Top) < Abs(Y0-CR.Bottom))
          Then Y0 := CR.Top else  Y0 := CR.Bottom;}
         X0 := (X0 - xWO) * xF Div xWE;
         Y0 := (Y0 - yWO) * yF Div yWE;
         wmf_x:=x0;
         wmf_y:=y0;
         End;

  $213 : Begin                    {void LineTo}
         mystrm^.Read(y0,2);
         mystrm^.Read(x0,2);
{         If (X0 in [CR.Left..CR.Right]) = False Then
          Begin
          If (Abs(X0-CR.Right) < Abs(X0-CR.Left))
          Then X0 := CR.Right else  X0 := CR.Left;
          End;}
{          If not (Y0 in [CR.Top..CR.Bottom]) Then
          If (Abs(Y0-CR.Top) < Abs(Y0-CR.Bottom))
          Then Y0 := CR.Top else  Y0 := CR.Bottom;}
          X0 := (X0 - xWO) * xF Div xWE;
          Y0 := (Y0 - yWO) * yF Div yWE;
          Line(dest,wmf_x,wmf_y, X0, Y0, Akt_BarvaPopredi);
          wmf_x:=x0;
          wmf_y:=y0;
         End;
  $000 : konec:=true;                {void META_EOF}
 End;


 MFpos := MFpos + mfRec.rdSize*2;

until konec=true;
LoadImageWMF:=0;
End;


Function Load_WMF(s:string;var dest:VirtualWindow):longint;
var h:PGrpStream;
begin
h:=New(PGrpStream,Init(s,stOpenRead));
Load_WMF:=LoadImageWMF(h,dest);
Dispose(h,Done);
end;

end.
