#include <dpmi.h>
#include <pc.h>

_go32_dpmi_seginfo new_keyboard_handler, old_keyboard_handler;
unsigned char key[256];
unsigned char key_extended;

void keyboard_interrupt(void) {
   unsigned char c;
   //asm ("cli; pusha");
   c = inportb(0x60);
   if (key_extended == 0) {
     if (c == 224) key_extended = 1;
     else {
       if (c < 128) key[c] = 1;
       else key[c - 128] = 0;
     }
   }
   else {
     key_extended = 0;
     if (c < 128) key[c + 128] = 1;
     else key[c - 128 + 128] = 0;
   }
   outportb(0x20, 0x20);
   //asm ("popa; sti");
}

void get_keyboard_interrupt(void) {
   new_keyboard_handler.pm_offset = (int)keyboard_interrupt;
   _go32_dpmi_allocate_iret_wrapper(&new_keyboard_handler);
   _go32_dpmi_get_protected_mode_interrupt_vector(0x9, &old_keyboard_handler);
   _go32_dpmi_set_protected_mode_interrupt_vector(0x9, &new_keyboard_handler);
}

void release_keyboard_interrupt(void) {
   _go32_dpmi_set_protected_mode_interrupt_vector(0x9, &old_keyboard_handler);
   _go32_dpmi_free_iret_wrapper(&new_keyboard_handler);
}