--- watt3210/src/tcp_fsm.c	2005-10-20 17:04:18.000000000 +0200
+++ watt32/src/tcp_fsm.c	2020-01-22 17:04:16.546726127 +0100
@@ -1060,7 +1060,8 @@
    * If it's before recv_next, we've seen it all before; if it's after
    * then the peer (or someone else) sent more than we said we could take.
    */
-  if ((unsigned)len - ldiff > s->adv_win)
+  if (((unsigned)len - ldiff > s->max_rx_data - s->rx_datalen) /* patch by Mikulas Patocka: checks that end of packet does not land above the TCP window */
+     || (ldiff > len))                                         /* patch by Mateusz Viste: checks that end of packet does not land below the TCP window (legitimate case when remote peer retransmits an already-received segment that Watt-32 did not acquit due to delayed ack - details at https://github.com/gvanem/Watt-32/issues/2 */
   {
     TCP_TRACE (("tcp_ProcessData (%u): packet ends outside %lu/%lu\n",
                 __LINE__, s->recv_next, s->recv_next + s->adv_win));
