/*
 * four-in-a-row game
 * Copyright (c) 2017 Andreas K. Foerster <info@akfoerster.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "row4.h"

#pragma GCC poison  printf fprintf sprintf snprintf

static byte mode, players, player;

static void help P ((void));
static int ask P ((void));
static int play_round P ((void));

#define cputs(s)  write (STDOUT_FILENO, (s), strlen (s))

static void
help ()
{
  cputs (TITLE "\n");
  cputs (copyright);
  cputs ("\n\n");
  cputs ("Options:\n  -a, --ascii\t\tASCII\n\n");
  cputs (license);
  cputs ("\n");

  exit (EXIT_SUCCESS);
}


/* returns slot or ERROR, or NEW */
static int
ask ()
{
  int r;

  do
    r = ask_slot (player);
  while (r >= 0 && (chips <= 0 || full (r)));

  return r;
}


static int
play_round ()
{
  while (chips)
    {
      int x;

      if (players == 2 || player == 1)
	x = ask ();
      else
	x = compute (player);

      if (ERROR == x)
	return FALSE;
      else if (NEW == x)
	{
	  reset_board ();
	  clear_board ();
	}
      else
	{
	  chip (x, drop (player, x), player);

	  if (wincheck ())
	    {
	      win (player);

	      x = ask ();
	      if (NEW == x)
		{
		  reset_board ();
		  clear_board ();
		}
	      else if (ERROR == x)
		return FALSE;

	      /* the winner starts the next game */
	      continue;
	    }
	}

      /* next player */
      player = (player == 1) ? 2 : 1;
    }

  return TRUE;
}


int
main (argc, argv)
     int argc;
     char **argv;
{
  mode = 0;
  player = 1;

  if (argc > 1)
    {
      if (!strcmp (argv[1], "--help") || !strcmp (argv[1], "-h")
	  || !strcmp (argv[1], "/?") || !strcmp (argv[1], "--version"))
	help ();
      if (!strcmp (argv[1], "-a") || !strcmp (argv[1], "/a")
	  || !strcmp (argv[1], "--ascii"))
	mode = MOD_ASCII;
      else
	{
	  write (STDERR_FILENO, OPTIONERROR ": ", sizeof (OPTIONERROR) + 1);
	  write (STDERR_FILENO, argv[1], strlen (argv[1]));
	  write (STDERR_FILENO, "\n", 1);
	  exit (EXIT_FAILURE);
	}
    }

  initialize (mode);
  players = ask_players ();

  if (players > 0)
    {
      draw_board ();
      reset_board ();

      while (play_round ())
	continue;
    }

  return EXIT_SUCCESS;
}
