// Part of SimCoupe - A SAM Coupe emulator
//
// Font.cpp: Font data used for on-screen text
//
//  Copyright (c) 1999-2006  Simon Owen
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//  Notes:
//      First byte in data contains the extents of the character.
//      The high nibble contains the number of bits to shift the
//      character right to return it to it's original position.
//      The low nibble is the width of the character in bits.

#include "SimCoupe.h"
#include "Font.h"


// The original TurboMON font, still used for profiling/status text
const GUIFONT sOldFont = { 6, 8, 9, 32, 129, abOldFont };

const BYTE abOldFont[] =
{
    0x02,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // <space>
    0x41,  0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x00,  // !
    0x33,  0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // "
    0x25,  0x50, 0x50, 0xf8, 0x50, 0xf8, 0x50, 0x50, 0x00,  // #
    0x25,  0x70, 0xa0, 0xa0, 0x70, 0x28, 0x28, 0x70, 0x00,  // $
    0x25,  0xc8, 0xc8, 0x10, 0x20, 0x40, 0x98, 0x98, 0x00,  // %
    0x25,  0x40, 0xa0, 0xa0, 0x40, 0xa8, 0x90, 0x68, 0x00,  // &
    0x32,  0xc0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,  // '
    0x43,  0x20, 0x40, 0x80, 0x80, 0x80, 0x40, 0x20, 0x00,  // (
    0x23,  0x80, 0x40, 0x20, 0x20, 0x20, 0x40, 0x80, 0x00,  // )
    0x25,  0x20, 0xa8, 0x70, 0xf8, 0x70, 0xa8, 0x20, 0x00,  // *
    0x25,  0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0x00,  // +
    0x32,  0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x40, 0x80,  // ,
    0x25,  0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,  // -
    0x32,  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00,  // .
    0x25,  0x08, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x00,  // /
    0x25,  0x70, 0x88, 0x98, 0xa8, 0xc8, 0x88, 0x70, 0x00,  // 0
    0x33,  0x40, 0xc0, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00,  // 1
    0x25,  0x70, 0x88, 0x08, 0x10, 0x20, 0x40, 0xf8, 0x00,  // 2
    0x25,  0x70, 0x88, 0x08, 0x30, 0x08, 0x88, 0x70, 0x00,  // 3
    0x25,  0x10, 0x30, 0x50, 0x90, 0xf8, 0x10, 0x10, 0x00,  // 4
    0x25,  0xf8, 0x80, 0xf0, 0x08, 0x08, 0x88, 0x70, 0x00,  // 5
    0x25,  0x30, 0x40, 0x80, 0xf0, 0x88, 0x88, 0x70, 0x00,  // 6
    0x25,  0xf8, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x00,  // 7
    0x25,  0x70, 0x88, 0x88, 0x70, 0x88, 0x88, 0x70, 0x00,  // 8
    0x25,  0x70, 0x88, 0x88, 0x78, 0x08, 0x10, 0x60, 0x00,  // 9
    0x42,  0x00, 0x00, 0xc0, 0xc0, 0x00, 0xc0, 0xc0, 0x00,  // :
    0x42,  0x00, 0x00, 0xc0, 0xc0, 0x00, 0xc0, 0x40, 0x80,  // ;
    0x34,  0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x00,  // <
    0x25,  0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00,  // =
    0x24,  0x80, 0x40, 0x20, 0x10, 0x20, 0x40, 0x80, 0x00,  // >
    0x25,  0x70, 0x88, 0x08, 0x10, 0x20, 0x00, 0x20, 0x00,  // ?
    0x25,  0x70, 0x88, 0x98, 0xa8, 0xb8, 0x80, 0x70, 0x00,  // @
    0x25,  0x70, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00,  // A
    0x25,  0xf0, 0x88, 0x88, 0xf0, 0x88, 0x88, 0xf0, 0x00,  // B
    0x25,  0x70, 0x88, 0x80, 0x80, 0x80, 0x88, 0x70, 0x00,  // C
    0x25,  0xf0, 0x88, 0x88, 0x88, 0x88, 0x88, 0xf0, 0x00,  // D
    0x25,  0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0xf8, 0x00,  // E
    0x25,  0xf8, 0x80, 0x80, 0xf0, 0x80, 0x80, 0x80, 0x00,  // F
    0x25,  0x70, 0x88, 0x80, 0x80, 0x98, 0x88, 0x70, 0x00,  // G
    0x25,  0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x00,  // H
    0x33,  0xe0, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00,  // I
    0x25,  0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x70, 0x00,  // J
    0x25,  0x88, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x88, 0x00,  // K
    0x25,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00,  // L
    0x25,  0x88, 0xd8, 0xa8, 0x88, 0x88, 0x88, 0x88, 0x00,  // M
    0x25,  0x88, 0x88, 0xc8, 0xa8, 0x98, 0x88, 0x88, 0x00,  // N
    0x25,  0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00,  // O
    0x25,  0xf0, 0x88, 0x88, 0xf0, 0x80, 0x80, 0x80, 0x00,  // P
    0x25,  0x70, 0x88, 0x88, 0x88, 0xa8, 0x90, 0x68, 0x00,  // Q
    0x25,  0xf0, 0x88, 0x88, 0xf0, 0xa0, 0x90, 0x88, 0x00,  // R
    0x25,  0x70, 0x88, 0x80, 0x70, 0x08, 0x88, 0x70, 0x00,  // S
    0x25,  0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00,  // T
    0x25,  0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00,  // U
    0x25,  0x88, 0x88, 0x88, 0x88, 0x88, 0x50, 0x20, 0x00,  // V
    0x25,  0x88, 0x88, 0x88, 0x88, 0xa8, 0xa8, 0x50, 0x00,  // W
    0x25,  0x88, 0x88, 0x50, 0x20, 0x50, 0x88, 0x88, 0x00,  // X
    0x25,  0x88, 0x88, 0x50, 0x20, 0x20, 0x20, 0x20, 0x00,  // Y
    0x25,  0xf8, 0x08, 0x10, 0x20, 0x40, 0x80, 0xf8, 0x00,  // Z
    0x43,  0xe0, 0x80, 0x80, 0x80, 0x80, 0x80, 0xe0, 0x00,  // [
    0x25,  0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x08, 0x00,  // '\'
    0x23,  0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0xe0, 0x00,  // ]
    0x25,  0x20, 0x70, 0xa8, 0x20, 0x20, 0x20, 0x20, 0x00,  // ^
    0x07,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,  // _
    0x25,  0x30, 0x48, 0x40, 0xe0, 0x40, 0x40, 0xf8, 0x00,  // `
    0x25,  0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x78, 0x00,  // a
    0x25,  0x80, 0x80, 0xf0, 0x88, 0x88, 0x88, 0xf0, 0x00,  // b
    0x25,  0x00, 0x00, 0x78, 0x80, 0x80, 0x80, 0x78, 0x00,  // c
    0x25,  0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x78, 0x00,  // d
    0x25,  0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x78, 0x00,  // e
    0x25,  0x30, 0x48, 0x40, 0xf0, 0x40, 0x40, 0x40, 0x00,  // f
    0x25,  0x00, 0x00, 0x78, 0x88, 0x88, 0x78, 0x08, 0x70,  // g
    0x25,  0x80, 0x80, 0xf0, 0x88, 0x88, 0x88, 0x88, 0x00,  // h
    0x42,  0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x40, 0x00,  // i
    0x32,  0x40, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80,  // j
    0x25,  0x80, 0x80, 0x88, 0x90, 0xe0, 0x90, 0x88, 0x00,  // k
    0x42,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0, 0x00,  // l
    0x25,  0x00, 0x00, 0xd0, 0xa8, 0xa8, 0xa8, 0xa8, 0x00,  // m
    0x25,  0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0x88, 0x00,  // n
    0x25,  0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00,  // o
    0x25,  0x00, 0x00, 0xf0, 0x88, 0x88, 0xf0, 0x80, 0x80,  // p
    0x25,  0x00, 0x00, 0x78, 0x88, 0x88, 0x78, 0x08, 0x08,  // q
    0x25,  0x00, 0x00, 0xb0, 0xc8, 0x80, 0x80, 0x80, 0x00,  // r
    0x25,  0x00, 0x00, 0x78, 0x80, 0x70, 0x08, 0xf0, 0x00,  // s
    0x34,  0x40, 0x40, 0xf0, 0x40, 0x40, 0x40, 0x30, 0x00,  // t
    0x25,  0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00,  // u
    0x25,  0x00, 0x00, 0x88, 0x88, 0x88, 0x50, 0x20, 0x00,  // v
    0x25,  0x00, 0x00, 0x88, 0x88, 0x88, 0xa8, 0x50, 0x00,  // w
    0x25,  0x00, 0x00, 0x88, 0x50, 0x20, 0x50, 0x88, 0x00,  // x
    0x25,  0x00, 0x00, 0x88, 0x88, 0x88, 0x78, 0x08, 0x70,  // y
    0x25,  0x00, 0x00, 0xf8, 0x10, 0x20, 0x40, 0xf8, 0x00,  // z
    0x33,  0x20, 0x40, 0x40, 0x80, 0x40, 0x40, 0x20, 0x00,  // {
    0x41,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,  // |
    0x33,  0x80, 0x40, 0x40, 0x20, 0x40, 0x40, 0x80, 0x00,  // }
    0x34,  0x50, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // ~
    0x16,  0x78, 0x84, 0xb4, 0xa4, 0xb4, 0x84, 0x78, 0x00,  // (c)
    0x16,  0x20, 0x70, 0xa8, 0x20, 0x20, 0x20, 0x20, 0x00,  // arrow up
    0x16,  0x20, 0x20, 0x20, 0x20, 0xa8, 0x70, 0x20, 0x00,  // arrow down
};


// Sans-serif, around 9pt
const GUIFONT sGUIFont = { 8, 11, 12, 32, 127, abGUIFont };

const BYTE abGUIFont[] =
{
    0x02,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // <space>
    0x01,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x00, 0x00,    // !
    0x03,  0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // "
    0x07,  0x14, 0x14, 0x7e, 0x28, 0x28, 0x28, 0xfc, 0x50, 0x50, 0x00, 0x00,    // #
    0x05,  0x20, 0x70, 0xa8, 0xa0, 0xa0, 0x70, 0x28, 0x28, 0xa8, 0x70, 0x20,    // $
    0x08,  0x42, 0xa2, 0xa4, 0x48, 0x10, 0x12, 0x25, 0x45, 0x42, 0x00, 0x00,    // %
    0x06,  0x30, 0x48, 0x48, 0x30, 0x60, 0x94, 0x8c, 0x88, 0x74, 0x00, 0x00,    // &
    0x01,  0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // '
    0x03,  0x20, 0x40, 0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x20,    // (
    0x03,  0x80, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x40, 0x40, 0x80,    // )
    0x05,  0x20, 0xf8, 0x20, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // *
    0x05,  0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,    // +
    0x03,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x80,    // ,
    0x04,  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,    // -
    0x01,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,    // .
    0x03,  0x20, 0x20, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80, 0x80, 0x00, 0x00,    // /
    0x05,  0x70, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00,    // 0
    0x05,  0x20, 0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00,    // 1
    0x05,  0x70, 0x88, 0x08, 0x08, 0x10, 0x20, 0x40, 0x80, 0xf8, 0x00, 0x00,    // 2
    0x05,  0x70, 0x88, 0x08, 0x08, 0x30, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00,    // 3
    0x05,  0x10, 0x10, 0x30, 0x50, 0x50, 0x90, 0xf8, 0x10, 0x10, 0x00, 0x00,    // 4
    0x05,  0xf8, 0x80, 0x80, 0xf0, 0x88, 0x08, 0x08, 0x88, 0x70, 0x00, 0x00,    // 5
    0x05,  0x70, 0x88, 0x80, 0xb0, 0xc8, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00,    // 6
    0x05,  0xf8, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x00, 0x00,    // 7
    0x05,  0x70, 0x88, 0x88, 0x88, 0x70, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00,    // 8
    0x05,  0x70, 0x88, 0x88, 0x88, 0x98, 0x68, 0x08, 0x88, 0x70, 0x00, 0x00,    // 9
    0x01,  0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,    // :
    0x02,  0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x00,    // ;
    0x05,  0x00, 0x08, 0x30, 0x40, 0x80, 0x40, 0x30, 0x08, 0x00, 0x00, 0x00,    // <
    0x05,  0x00, 0x00, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,    // =
    0x05,  0x00, 0x80, 0x60, 0x10, 0x08, 0x10, 0x60, 0x80, 0x00, 0x00, 0x00,    // >
    0x05,  0x70, 0x88, 0x08, 0x08, 0x10, 0x20, 0x20, 0x00, 0x20, 0x00, 0x00,    // ?
    0x08,  0x3c, 0x42, 0x81, 0x9d, 0xa5, 0xa5, 0x9b, 0x80, 0x40, 0x3c, 0x00,    // @
    0x07,  0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x7c, 0x82, 0x82, 0x00, 0x00,    // A
    0x06,  0xf8, 0x84, 0x84, 0x84, 0xf8, 0x84, 0x84, 0x84, 0xf8, 0x00, 0x00,    // B
    0x07,  0x38, 0x44, 0x82, 0x80, 0x80, 0x80, 0x82, 0x44, 0x38, 0x00, 0x00,    // C
    0x07,  0xf8, 0x84, 0x82, 0x82, 0x82, 0x82, 0x82, 0x84, 0xf8, 0x00, 0x00,    // D
    0x06,  0xfc, 0x80, 0x80, 0x80, 0xf8, 0x80, 0x80, 0x80, 0xfc, 0x00, 0x00,    // E
    0x06,  0xfc, 0x80, 0x80, 0x80, 0xf8, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // F
    0x07,  0x38, 0x44, 0x82, 0x80, 0x8e, 0x82, 0x82, 0x46, 0x3a, 0x00, 0x00,    // G
    0x07,  0x82, 0x82, 0x82, 0x82, 0xfe, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00,    // H
    0x01,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // I
    0x05,  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x88, 0x88, 0x70, 0x00, 0x00,    // J
    0x07,  0x84, 0x88, 0x90, 0xa0, 0xe0, 0x90, 0x88, 0x84, 0x82, 0x00, 0x00,    // K
    0x06,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xfc, 0x00, 0x00,    // L
    0x07,  0x82, 0xc6, 0xaa, 0xaa, 0x92, 0x92, 0x82, 0x82, 0x82, 0x00, 0x00,    // M
    0x07,  0x82, 0xc2, 0xa2, 0xa2, 0x92, 0x8a, 0x8a, 0x86, 0x82, 0x00, 0x00,    // N
    0x07,  0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,    // O
    0x07,  0xfc, 0x82, 0x82, 0x82, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // P
    0x07,  0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x8a, 0x44, 0x3a, 0x00, 0x00,    // Q
    0x07,  0xfc, 0x82, 0x82, 0x82, 0xfc, 0x84, 0x82, 0x82, 0x82, 0x00, 0x00,    // R
    0x06,  0x78, 0x84, 0x84, 0x80, 0x78, 0x04, 0x84, 0x84, 0x78, 0x00, 0x00,    // S
    0x07,  0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00,    // T
    0x07,  0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,    // U
    0x07,  0x82, 0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00,    // V
    0x07,  0x82, 0x82, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00,    // W
    0x08,  0x81, 0x42, 0x24, 0x18, 0x18, 0x18, 0x24, 0x42, 0x81, 0x00, 0x00,    // X
    0x07,  0x82, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00,    // Y
    0x05,  0xf8, 0x08, 0x10, 0x10, 0x20, 0x40, 0x40, 0x80, 0xf8, 0x00, 0x00,    // Z
    0x02,  0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,    // [
    0x03,  0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00,    // '\'
    0x02,  0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xc0,    // ]
    0x05,  0x20, 0x50, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // ^
    0x07,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,    // _
    0x02,  0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // `
    0x05,  0x00, 0x00, 0x00, 0x70, 0x08, 0x78, 0x88, 0x88, 0x78, 0x00, 0x00,    // a
    0x05,  0x80, 0x80, 0x80, 0xf0, 0x88, 0x88, 0x88, 0x88, 0xf0, 0x00, 0x00,    // b
    0x05,  0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0x80, 0x88, 0x70, 0x00, 0x00,    // c
    0x05,  0x08, 0x08, 0x08, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x00, 0x00,    // d
    0x05,  0x00, 0x00, 0x00, 0x70, 0x88, 0xf8, 0x80, 0x88, 0x70, 0x00, 0x00,    // e
    0x03,  0x20, 0x40, 0x40, 0xe0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00,    // f
    0x05,  0x00, 0x00, 0x00, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x08, 0xf0,    // g
    0x05,  0x80, 0x80, 0x80, 0xb0, 0xc8, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00,    // h
    0x01,  0x80, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // i
    0x02,  0x40, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80,    // j
    0x05,  0x80, 0x80, 0x80, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x88, 0x00, 0x00,    // k
    0x01,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // l
    0x07,  0x00, 0x00, 0x00, 0xa4, 0xda, 0x92, 0x92, 0x92, 0x92, 0x00, 0x00,    // m
    0x05,  0x00, 0x00, 0x00, 0xb0, 0xc8, 0x88, 0x88, 0x88, 0x88, 0x00, 0x00,    // n
    0x05,  0x00, 0x00, 0x00, 0x70, 0x88, 0x88, 0x88, 0x88, 0x70, 0x00, 0x00,    // o
    0x05,  0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0x88, 0xf0, 0x80, 0x80,    // p
    0x05,  0x00, 0x00, 0x00, 0x78, 0x88, 0x88, 0x88, 0x88, 0x78, 0x08, 0x08,    // q
    0x03,  0x00, 0x00, 0x00, 0xa0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00,    // r
    0x04,  0x00, 0x00, 0x00, 0x60, 0x90, 0x40, 0x20, 0x90, 0x60, 0x00, 0x00,    // s
    0x03,  0x00, 0x40, 0x40, 0xe0, 0x40, 0x40, 0x40, 0x40, 0x20, 0x00, 0x00,    // t
    0x05,  0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0x88, 0x98, 0x68, 0x00, 0x00,    // u
    0x05,  0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x20, 0x00, 0x00,    // v
    0x07,  0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00,    // w
    0x06,  0x00, 0x00, 0x00, 0x84, 0x48, 0x30, 0x30, 0x48, 0x84, 0x00, 0x00,    // x
    0x05,  0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x20, 0x40, 0x80,    // y
    0x04,  0x00, 0x00, 0x00, 0xf0, 0x10, 0x20, 0x40, 0x80, 0xf0, 0x00, 0x00,    // z
    0x03,  0x20, 0x40, 0x40, 0x40, 0x40, 0x80, 0x40, 0x40, 0x40, 0x40, 0x20,    // {
    0x01,  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,    // |
    0x03,  0x80, 0x40, 0x40, 0x40, 0x40, 0x20, 0x40, 0x40, 0x40, 0x40, 0x80,    // }
    0x06,  0x64, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,    // ~
    0x08,  0x3c, 0x42, 0x81, 0x99, 0xa5, 0xa1, 0xa5, 0x99, 0x81, 0x42, 0x3c,    // (c)
};
