#
#   DJGPP makefile for SSHDOS
#

# remove -DCOLOR for B&W mode
CFLAGS	      = -O6 -malign-jumps=2 -malign-loops=2 -malign-functions=2 \
		-fno-strength-reduce -ffast-math -I./include -Wall -DCOLOR

#which command to use to delete a file
RM=del
#RM=rm -f

#################################################################
# In normal cases, no other settings should be changed below!!! #
#################################################################


LDFLAGS	      =

LINKER	      = gcc

all:		sshd386.exe scpd386.exe tel386.exe

sshd386.exe:	sshdos.o sshzlib.o lib/libwatt.a lib/libvt100.a lib/libssh.a lib/libcrypt.a
		@echo "Linking sshd386 ... "
		@$(LINKER) $(LDFLAGS) -o sshd386.exe sshdos.o sshzlib.o lib/libwatt.a lib/libvt100.a lib/libssh.a lib/libcrypt.a
		@echo "done"

scpd386.exe:	scpdos.o sshzlib.o lib/libwatt.a lib/libssh.a lib/libcrypt.a
		@echo "Linking scpd386 ... "
		@$(LINKER) $(LDFLAGS) -o scpd386.exe scpdos.o sshzlib.o lib/libwatt.a lib/libssh.a lib/libcrypt.a
		@echo "done"

tel386.exe:	telnet.o lib/libwatt.a lib/libvt100.a
		@echo "Linking tel386 ... "
		@$(LINKER) $(LDFLAGS) -o tel386.exe telnet.o lib/libwatt.a lib/libvt100.a
		@echo "done"

lib/libvt100.a:	vttio.o vidio.o keyio.o keymap.o
		ar rvs lib/libvt100.a vttio.o vidio.o keyio.o keymap.o

lib/libssh.a:	negotiat.o protocol.o
		ar rvs lib/libssh.a negotiat.o protocol.o

lib/libcrypt.a:	sshcrc.o sshrsa.o sshblowf.o sshdes.o sshmd5.o sshbn.o sshpubk.o
		ar rvs lib/libcrypt.a sshcrc.o sshrsa.o sshblowf.o sshdes.o sshmd5.o sshbn.o sshpubk.o

clean:
		$(RM) *.o
		$(RM) sshd386.exe
		$(RM) scpd386.exe
		$(RM) tel386.exe
		$(RM) lib\libvt100.a
		$(RM) lib\libssh.a
		$(RM) lib\libcrypt.a

###
