/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Header file for TEE.C
 *
 * Author: Alexis Malozemoff
 */

#ifndef TEE_HDR
#define TEE_HDR

#ifndef TRUE
#define TRUE		1
#endif
#ifndef FALSE
#define FALSE		0
#endif

/* User settings */
#define APPEND		0x01
#define INTERRUPT	0x02

/* Types of modes */
#define MODE_WRITE	0
#define MODE_APPEND 1

#ifdef ENABLE_KITTEN
	#include "kitten.h"
	#define MSG_SET				0
	#define ERR_SET				1
#else
	#define kittenopen(A)			1
	#define kittengets(A, B, STR)	STR
	#define kittenclose()			/* empty */
	#define kitten_debug()			/* empty */
#endif

#define PROGNAME		"TEE"
#define VERSION			"v2.0.3"

/* Messages */
#define MSG_DESCRIPTION		(kittengets(MSG_SET, 0, \
			"Saves a copy of the input to a file and prints it."))
#define MSG_USAGE_STR		(kittengets(MSG_SET, 1, "Usage"))
#define MSG_FILE_STR		(kittengets(MSG_SET, 3, "FILE(s)"))
#define MSG_A_OPT 			(kittengets(MSG_SET, 4, "Append to given FILE(s)"))
#define MSG_I_OPT			(kittengets(MSG_SET, 5, \
			"Ignore user generated interrupts"))
#define MSG_HELP_OPT		(kittengets(MSG_SET, 6, \
			"Display this help message"))

/* Errors */
#define ERR_UNKNOWN_OPT		(kittengets(ERR_SET, 0, "Unknown option"))
#define ERR_ALLOC			(kittengets(ERR_SET, 1, \
			"Error allocating space for file handles(s)"))
#define ERR_OPEN			(kittengets(ERR_SET, 2, \
			"Error opening output file"))
#define ERR_WRITE			(kittengets(ERR_SET, 3, "Error writing to file"))
#define	ERR_CLOSE			(kittengets(ERR_SET, 4, "Error closing file"))

/* print macros for error messages */
#define PRINT_ERR_ALLOC												\
		do {														\
			fprintf(stderr, "%s: %s: ", PROGNAME, ERR_ALLOC);		\
			perror(NULL);											\
		} while (0);
#define PRINT_ERR_OPEN(s)											\
		do {														\
			fprintf(stderr, "%s: %s %s: ", PROGNAME, ERR_OPEN, s);	\
			perror(NULL);											\
		} while (0);

// TEE (or DOS or WATCOM C) gets confused when writing to file on a full
// disk.  perror() prints "No file or directory" when it should
// print "No space left on device".  So for now we will not
// use perror(), since the error message is wrong.
#define PRINT_ERR_WRITE(s)											\
		fprintf(stderr, "%s: %s %s", PROGNAME, ERR_WRITE, s);

#define PRINT_ERR_CLOSE(s)											\
		do {														\
			fprintf(stderr, "%s: %s %s: ", PROGNAME, ERR_CLOSE, s);	\
			perror(NULL);											\
		} while (0);

#endif /* TEE_HDR */
