/*
 *  canna.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <dlfcn.h>
#include "canna.h"

static struct rkfuncs *RkFunc;
static void *canna_lib;

int canna_init(void) {
    if(canna_lib) {
	dlclose(canna_lib);
    }

    canna_lib = dlopen("libcanna.so.1", RTLD_LAZY);
    RkFunc = (struct rkfuncs *)dlsym(canna_lib, "RkFuncs");

    if(RkFunc == NULL) {
	dlclose(canna_lib);
	return -1;
    }
    return 0;
}

void canna_close(void) {
    if(canna_lib) {
	dlclose(canna_lib);
    }
}

