/*
 *  cannacontainer.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  This code is based on Anthy's code.
 */

#include <gtk/gtk.h>

#include "cannacontainer.h"

#include "intl.h"

void create_canna_container(CannaContainer *container) {
	/* I changed coding style a little. */
	GtkWidget *notebook;
	CannaAddWordPane *addwordpane;
	CannaDeleteWordPane *deletewordpane;
	GtkWidget *label_addword, *label_deleteword;

	notebook = gtk_notebook_new();
//	gtk_widget_show(notebook);

	addwordpane = canna_addword_pane_new();
	deletewordpane = canna_deleteword_pane_new();

	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
	gtk_container_set_border_width(GTK_CONTAINER(notebook), 10);
	gtk_container_add(GTK_CONTAINER(notebook), addwordpane->pane);
	gtk_widget_show(addwordpane->pane);
	label_addword = gtk_label_new(_("Add word"));
	gtk_widget_show(label_addword);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
								gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 0),
								label_addword);
	gtk_container_add(GTK_CONTAINER(notebook), deletewordpane->pane);
	gtk_widget_show(deletewordpane->pane);
	label_deleteword = gtk_label_new(_("Delete word"));
	gtk_widget_show(label_deleteword);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook),
								gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook), 1),
								label_deleteword);
	
	container->container = notebook;
	container->addwordpane = addwordpane;
	container->deletewordpane = deletewordpane;
}

CannaAddWordPane *canna_addword_pane_new(void) {
	CannaAddWordPane *pane;
	GtkWidget *hbox;
	GtkWidget *vbox1;
	GtkWidget *table1, *table2;
	GtkWidget *label_yomi, *label_kanji, *label_hinshi;
	GtkWidget *entry_yomi, *entry_kanji;

	pane = g_malloc0(sizeof(CannaAddWordPane));
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 15);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_box_pack_start(GTK_BOX(hbox), vbox1, FALSE, FALSE, 0);

	table1 = gtk_table_new(2, 3, FALSE);
	gtk_widget_show(table1);
	gtk_box_pack_start(GTK_BOX(vbox1), table1, FALSE, FALSE, 0);

	label_yomi = gtk_label_new(_("Yomi:"));
	gtk_misc_set_alignment(GTK_MISC(label_yomi), 1.0, 0.5);
	gtk_widget_show(label_yomi);
	gtk_table_attach(GTK_TABLE(table1), label_yomi, 0, 1, 0, 1, GTK_FILL, 0, 5, 5);

	entry_yomi = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table1), entry_yomi, 1, 2, 0, 1, 0, 0, 5, 5);
	gtk_widget_show(entry_yomi);
								
	label_kanji = gtk_label_new(_("Kanji:"));
	gtk_misc_set_alignment(GTK_MISC(label_kanji), 1.0, 0.5);
	gtk_widget_show(label_kanji);
	gtk_table_attach(GTK_TABLE(table1), label_kanji, 0, 1, 1, 2, GTK_FILL, 0, 5, 5);

	entry_kanji = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table1), entry_kanji, 1, 2, 1, 2, 0, 0, 5, 5);
	gtk_widget_show(entry_kanji);

	label_hinshi = gtk_label_new(_("Hinshi:"));
	gtk_misc_set_alignment(GTK_MISC(label_hinshi), 1.0, 0.5);
	gtk_widget_show(label_hinshi);
	gtk_table_attach(GTK_TABLE(table1), label_hinshi, 0, 1, 2, 3, GTK_FILL, 0, 5, 5);
	
	
	
	pane->pane = GTK_WIDGET(hbox);	

	return pane;
}

CannaDeleteWordPane *canna_deleteword_pane_new(void) {
	CannaDeleteWordPane *pane;
	GtkWidget *hbox;
	pane = g_malloc0(sizeof(CannaDeleteWordPane));

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 15);

	pane->pane = hbox;	
	return pane;
}
void show_canna_container(CannaContainer *container, gboolean flags) {
	if(flags) {
		gtk_widget_show(container->container);
	}
}
