/*
 *  anthycontainer.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
                                                                                
#ifndef __CANNA_CONTAINER_H__
#define __CANNA_CONTAINER_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

typedef struct _canna_addwordpane {
	GtkWidget *pane;

	GtkWidget *yomi;
	GtkWidget *kanji;
	GtkWidget *hinshi;
	
	GtkWidget *meishi_options[5];
	GtkWidget *fukushi_options[4];
/*
	GtkWidget *doushi_options[4];
	GtkWidget *keiyoushi_options[4];
*/
	GtkWidget *touroku;
	GtkWidget *clear;
} CannaAddWordPane;

typedef struct _canna_deletewordpane {
	GtkWidget *pane;
} CannaDeleteWordPane;

typedef struct _canna_viewwordpane {
	GtkWidget *pane;

	GtkWidget *treeview_wordlist;
	GtkWidget *button_load;
} CannaViewWordPane;

typedef struct _cannacontainer {
	GtkWidget *container; /* GtkNotebook */
	CannaAddWordPane *addwordpane;
	CannaDeleteWordPane *deletewordpane;
} CannaContainer;

CannaAddWordPane *canna_addword_pane_new(void);
CannaDeleteWordPane *canna_deleteword_pane_new(void);
#endif /* __CANNA_CONTAINER_H__ */
