/*
 *  plugin.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include <gmodule.h>

typedef enum {
	PLUGIN_CONTAINER,
	PLUGIN_IMPORT,
	PLUGIN_EXPORT
}

typedef struct _Plugin_Info {
	const PluginType type;
	const gchar * const name;
	const gchar * const version;
	const gchar * const author;
	const gchar * const description;
	GtkWidget *about;
	GtkWidget *config;
	gpointer init;
} PluginInfo;

void plugin_init(void);
void plugin_get_module_name(GModule *module);
void plugin_get_module_version(GModule *module);
void plugin_get_module_author(GModule *module);
void plugin_get_module_description(GModule *module);

void   plugin_create_search_dir_list   (void);
GList *plugin_get_search_dir_list      (void);

#endif /* __PLUGIN_H__ */
