/*
 *  cannadic.h
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  This code is based on canna's code. For more information about canna,
 *  visit http://canna.sourceforge.jp/ . Canna license is as follows,
 *
 * Copyright (c) 2002 Canna Project. All rights reserved.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of the
 * author and contributors not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The author and contributors no representations
 * about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 *
 * THE AUTHOR AND CONTRIBUTORS DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHOR AND CONTRIBUTORS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Copyright 1994 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.	NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

typedef struct _category_code {
    char *code;
    char *desc;
    int   flag;
} category_code;

category_code substantive_code[]= {
    { "#T00", "", 31 },
//	{ "#T01", "", 31 },
    { "#T02", "", 30 },
//	{ "#T03", "", 29 },
    { "#T04", "", 28 },
    { "#T05", "", 27 },
//	{ "#T06", "", 27 },
    { "#T07", "", 26 },
//	{ "#T08", "", 25 },
    { "#T09", "", 24 },
    { "#T10", "", 23 },
//	{ "#T11", "", 23 },
    { "#T12", "", 22 },
//	{ "#T13", "", 21 },
    { "#T14", "", 20 },
    { "#T15", "", 19 },
//	{ "#T16", "", 19 },
    { "#T17", "", 18 },
//	{ "#T18", "", 17 },
    { "#T19", "", 16 },
    { "#T20", "", 15 },
//	{ "#T21", "", 15 },
    { "#T22", "", 14 },
//	{ "#T23", "", 13 },
    { "#T24", "", 12 },
    { "#T25", "", 11 },
//	{ "#T26", "", 11 },
    { "#T27", "", 10 },
//	{ "#T28", "", 9 },
    { "#T29", "", 8 },
    { "#T30", "", 7 },
//	{ "#T31", "", 7 },
    { "#T32", "", 6 },
//	{ "#T33", "", 5 },
    { "#T34", "", 4 },
    { "#T35", "", 3 },
//	{ "#T36", "", 3 },
    { "#T37", "", 2 },
//	{ "#T38", "", 1 },
    { "#T39", "", 0 }
};

static category_code adverb_code[] = {
    { "#F00", "", 15 },
    { "#F01", "", 14 },
    { "#F02", "", 13 },
    { "#F03", "", 12 },
    { "#F04", "", 11 },
    { "#F05", "", 10 },
    { "#F06", "",  9 },
    { "#F07", "",  8 },
    { "#F08", "",  7 },
    { "#F09", "",  6 },
    { "#F10", "",  5 },
    { "#F11", "",  4 },
    { "#F12", "",  3 },
    { "#F13", "",  2 },
    { "#F14", "",  1 },
    { "#F15", "",  0 },
};

category_code verb_code[]= {
    { "#K5",  "5"       , 26 },  /* K5,  5,              ֤   */
    { "#K5r", "5:Ϣ̾"  , 25 },  /* K5r, 5:Ϣѷ̾,    */
    { "#C5r", "Ԥ5"       , 24 },  /* C5r, Ԥ5:Ϣѷ̾, Ԥ   */
    { "#G5" , "5"       , 23 },  /* G5,  5,              Ĥ   */
    { "#G5r", "5:Ϣ̾"  , 22 },  /* G5r, 5:Ϣѷ̾, ޤ   */
    { "#S5" , "5"       , 21 },  /* S5,  5,                 */
    { "#S5r", "5:Ϣ̾"  , 20 },  /* S5r, 5:Ϣѷ̾, ܤ   */
    { "#T5" , "5"       , 19 },  /* T5,  5,                 */
    { "#T5r", "5:Ϣ̾"  , 18 },  /* T5r, 5:Ϣѷ̾, Ǥ   */
    { "#N5",  "ʹ5"       , 17 },  /* N5,  ʹ5,                 */
    { "#B5",  "й5"       , 16 },  /* B5,  й5,              ž   */
    { "#B5r", "й5:Ϣ̾"  , 15 },  /* B5r, й5:Ϣѷ̾, ͷ   */
    { "#M5",  "޹5"       , 14 },  /* M5,  ޹5,                 */
    { "#M5r", "޹5:Ϣ̾"  , 13 },  /* M5r, ޹5:Ϣѷ̾, Ԥ   */
    { "#R5" , "5"       , 12 },  /* R5,  5,              ĥ */
    { "#R5r", "5:Ϣ̾"  , 11 },  /* R5r, 5:Ϣѷ̾, դ   */
    { "#L5",  "5:̿ᥤ", 10 },  /* L5,  5:̿,          */
                                       /*                      ä */
    { "#W5",  "5"       ,  9 },  /* W5,  5,                 */
    { "#W5r", "5:Ϣ̾"  ,  8 },  /* W5r, 5:Ϣѷ̾,    */
    { "#U5" , "5"       ,  7 },  /* U5,  5,                 */
    { "#U5r", "5:Ϣ̾"  ,  6 },  /* U5r, 5:Ϣѷ̾, 䤦   */
    { "#KS",  "岼1"       ,  5 },  /* KS,  岼1,              ߤ */
                                       /*                            Ϳ */
    { "#KSr", "岼1:촴̾",  4 },  /* KSr, 岼1:촴̾,    */
                                       /*                            ¤ */
    { "#KX",  "ѳư"  ,  3 },  /* KX,  ѳư,            */
    { "#SX",  "ѳư"  ,  2 },  /* SX,  ѳư,         ؤ */
    { "#ZX",  "ѳư"  ,  1 },  /* ZX,  ѳư,          */
    { "#NZX", "ѳư",  0 },  /* NZX, ѳư      Ť󤺤 */
};

category_code adjective_code[] = {
    { "#KY",     "ƻ",         6}, /* KY,                        */
    { "#KYT",    "ƻ:̾ʥ",  5}, /* KYT,   ̾ʥΡ    ͳѤ, */
    { "#KYna","ƻ:Ϣˡ", 4}, /* KYna,              ,礭 */
				       /*(Ѥ[(Ϣˡ]ƻ) */
    { "#KYmi",   "ƻ:",      3}, /* KYmi,              Ť    */
				       /*  (ߤǽ̾žƻ)  */
    { "#KYme",   "ƻ:",      2}, /* KYme,              ᡢĹ    */
                                       /*(ǽȷưžƻ)*/
    { "#KYmime", "ƻ:ߤ",    1}, /* KYmime,            ߡ    */
				       /* KYmi, KYme ξ碌*/
    { "#KYU",    "ƻ:",  0}, /* KYU,   :     夦      */
};

category_code etc_code[] = {
    { "#KJ",  "ʸ",           0 },
    { "#CN",  "̾",                 0 },
    { "#CNS", "̾()",         0 },
    { "#JCN", "̾()",         0 },
    { "#JN",  "̾",                 0 },
    { "#KK",  "/",            0 },
    { "#CJ",  "³/ư/Ϣ",   0 },
    { "#RT",  "Ϣλ",               0 },
    { "#OKX", "ưǫɽθ촴", 0 },
};
