/*
 *  anthy.c
 *  Copyright(C) 2003- Masahito Omote <omote@utyuuzin.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  This code is based on Anthy's code.
 */

#include <dlfcn.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "anthy.h"
#include "cannadic.h"
/* #include "intl.h" */

struct _anthy_dic_api {
    void (*util_init)();
    void (*util_set_personality)(char *);
    const char *(*util_get_anthydir)(void);

    void (*priv_dic_delete)(void);
    int (*priv_dic_select_first_entry)(void);
    int (*priv_dic_select_next_entry)(void);
    int (*priv_dic_select_entry)(char *);

    char *(*priv_dic_get_index)(char *, int);
    int (*priv_dic_get_freq)(void);
    char *(*priv_dic_get_wtype)(char *, int);
    char *(*priv_dic_get_word)(char *, int);

    int (*priv_dic_add_entry)(char *, char *, char *, int);
};
static struct _anthy_dic_api anthy_dic_api;
static void *anthy_dic_lib;

static int get_anthydic_api() {
    anthy_dic_lib = dlopen("libanthydic.so.0", RTLD_GLOBAL |RTLD_NOW);
    if(anthy_dic_lib == NULL) {
	return -1;
    }

    anthy_dic_api.util_init = dlsym(anthy_dic_lib, "anthy_dic_util_init");
    anthy_dic_api.util_set_personality = dlsym(anthy_dic_lib, "anthy_dic_util_set_personality");
    anthy_dic_api.util_get_anthydir = dlsym(anthy_dic_lib, "anthy_dic_util_get_anthydir");

    anthy_dic_api.priv_dic_delete = dlsym(anthy_dic_lib, "anthy_priv_dic_delete");
    anthy_dic_api.priv_dic_select_first_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_first_entry");
    anthy_dic_api.priv_dic_select_next_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_next_entry");
    anthy_dic_api.priv_dic_select_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_select_entry");

    anthy_dic_api.priv_dic_get_index = dlsym(anthy_dic_lib, "anthy_priv_dic_get_index");
    anthy_dic_api.priv_dic_get_freq = dlsym(anthy_dic_lib, "anthy_priv_dic_get_freq");
    anthy_dic_api.priv_dic_get_wtype = dlsym(anthy_dic_lib, "anthy_priv_dic_get_wtype");
    anthy_dic_api.priv_dic_get_word = dlsym(anthy_dic_lib, "anthy_priv_dic_get_word");

    anthy_dic_api.priv_dic_add_entry = dlsym(anthy_dic_lib, "anthy_priv_dic_add_entry");

    if(!anthy_dic_api.util_init && !anthy_dic_api.util_set_personality
       && !anthy_dic_api.util_get_anthydir && !anthy_dic_api.priv_dic_delete
       && !anthy_dic_api.priv_dic_select_first_entry
       && !anthy_dic_api.priv_dic_select_next_entry
       && !anthy_dic_api.priv_dic_select_entry
       && !anthy_dic_api.priv_dic_get_index
       && !anthy_dic_api.priv_dic_get_freq
       && !anthy_dic_api.priv_dic_get_wtype
       && !anthy_dic_api.priv_dic_get_word
       && !anthy_dic_api.priv_dic_add_entry) {
	dlclose(anthy_dic_lib);
	return -1;
    }
    return 0;
}

int anthydic_init(void) {
    if(get_anthydic_api() == -1)
	return -1;
    anthy_dic_api.util_init();
    return 0;
}

int anthydic_close(void) {
    if(anthy_dic_lib)
	return dlclose(anthy_dic_lib);
    else
	return -1;
}

int read_anthy_priv_dic_list(word **head) {
    char phon[100], desc[100], cclass_code[100];
    int ret = 0;

    if(anthy_dic_api.priv_dic_select_first_entry() == -1) {
	*head = NULL;
	return -1;
    }

    while(ret == 0) {
	if(anthy_dic_api.priv_dic_get_index(phon, 100)
	   && anthy_dic_api.priv_dic_get_wtype(cclass_code, 100)
	   && anthy_dic_api.priv_dic_get_word(desc, 100)) {

	    word_append(head, WORD_TYPE_ANTHY,
			phon, desc, cclass_code, 
			anthy_dic_api.priv_dic_get_freq(),
			0, NULL);
	}
	ret = anthy_dic_api.priv_dic_select_next_entry();
    }
    return 0;
}

char *find_substantive_code_from_flag(const int flag) {
    int substantive_code_num;
    int i;
    char *code = NULL;

    substantive_code_num = sizeof(substantive_code)/sizeof(substantive_code[0]);
    for(i = 0; i < substantive_code_num; i++) {
	if(flag == substantive_code[i].flag) {
	    code = strdup(substantive_code[i].code);
	    break;
	}
    }

    return code;
}

char *find_adverb_code_from_flag(const int flag) {
    int adverb_code_num;
    int i;
    char *code = NULL;

    adverb_code_num = sizeof(adverb_code) / sizeof(adverb_code[0]);
    for(i = 0; i < adverb_code_num; i++) {
	if(flag == adverb_code[i].flag) {
	    code = strdup(adverb_code[i].code);
	    break;
	}
    }
    return code;
}

char *find_hinshi_name_from_code(const char *code) {
    char *hinshi = NULL;
/* Need to be more smart */
    if(strncmp(code, "#JNM", 4) == 0) {
	hinshi = strdup("\xbf\xcd\xcc\xbe"); /* Zinmei */
	return hinshi;
    } else if(strncmp(code, "#CN", 3) == 0) {
	hinshi = strdup("\xc3\xcf\xcc\xbe"); /* Chimei */
	return hinshi;
    }

    switch(code[1]) {
    case 'T':
	hinshi = strdup("\xcc\xbe\xbb\xec"); /* Meishi */
	break;
    case 'F':
	hinshi = strdup("\xc9\xfb\xbb\xec"); /* Fukushi */
	break;
    case 'K':
	hinshi = strdup("\xb7\xc1\xcd\xc6\xbb\xec"); /* Keiyoushi */
	break;
    default:
	hinshi = strdup("\xc6\xb0\xbb\xec"); /* Doushi */
	break;
    }
    return hinshi;
}

int add_anthy_priv_dic_with_flags(char *phon, char *desc,
				  char *cclass_code, int freq)
{
    if((strlen(phon) == 0) ||
       (strlen(desc) == 0) ||
       (strlen(cclass_code) == 0)) {
	return -1;
    }

    return anthy_dic_api.priv_dic_add_entry(phon, desc,
					    cclass_code, freq);
}

int delete_anthy_priv_dic(char *phon, char *desc, char *cclass_code) {
    return anthy_dic_api.priv_dic_add_entry(phon, desc,
					    cclass_code, 0);
}
