/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.security.action.LoadLibraryAction;

public class JPEGImageReader
extends ImageReader {
    private boolean debug = false;
    private long structPointer = 0L;
    private ImageInputStream iis = null;
    private List imagePositions = null;
    private int numImages = 0;
    protected static final int WARNING_NO_EOI = 0;
    protected static final int WARNING_NO_JFIF_IN_THUMB = 1;
    protected static final int WARNING_IGNORE_INVALID_ICC = 2;
    private static final int MAX_WARNING = 2;
    private int currentImage = -1;
    private int width;
    private int height;
    private int colorSpaceCode;
    private int outColorSpaceCode;
    private int numComponents;
    private ColorSpace iccCS = null;
    private ColorConvertOp convert = null;
    private BufferedImage image = null;
    private WritableRaster raster = null;
    private WritableRaster target = null;
    private DataBufferByte buffer = null;
    private Rectangle destROI = null;
    private int[] destinationBands = null;
    private JPEGMetadata streamMetadata = null;
    private JPEGMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private boolean haveSeeked = false;
    private JPEGQTable[] abbrevQTables = null;
    private JPEGHuffmanTable[] abbrevDCHuffmanTables = null;
    private JPEGHuffmanTable[] abbrevACHuffmanTables = null;
    private int minProgressivePass = 0;
    private int maxProgressivePass = Integer.MAX_VALUE;
    private static final int UNKNOWN = -1;
    private static final int MIN_ESTIMATED_PASSES = 10;
    private int knownPassCount = -1;
    private int pass = 0;
    private float percentToDate = 0.0f;
    private float previousPassPercentage = 0.0f;
    private int progInterval = 0;
    private boolean tablesOnlyChecked = false;
    private Object disposerReferent = new Object();
    private DisposerRecord disposerRecord;
    private static final ImageTypeSpecifier[] defaultTypes;

    private static native void initReaderIDs(Class var0, Class var1, Class var2);

    public JPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
        this.structPointer = this.initJPEGImageReader();
        this.disposerRecord = new JPEGReaderDisposerRecord(this.structPointer);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    private native long initJPEGImageReader();

    protected void warningOccurred(int n) {
        if (n < 0 || n > 2) {
            throw new InternalError("Invalid warning index");
        }
        this.processWarningOccurred("com.sun.imageio.plugins.jpeg.JPEGImageReaderResources", Integer.toString(n));
    }

    protected void warningWithMessage(String string) {
        this.processWarningOccurred(string);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.ignoreMetadata = bl2;
        this.resetInternalState();
        this.iis = (ImageInputStream)object;
        this.setSource(this.structPointer, this.iis);
    }

    private native void setSource(long var1, ImageInputStream var3);

    private void checkTablesOnly() throws IOException {
        boolean bl;
        if (this.debug) {
            System.out.println("Checking for tables-only image");
        }
        long l = this.iis.getStreamPosition();
        if (this.debug) {
            System.out.println("saved pos is " + l);
            System.out.println("length is " + this.iis.length());
        }
        if (bl = this.readNativeHeader(true)) {
            long l2;
            if (this.debug) {
                System.out.println("tables-only image found");
                l2 = this.iis.getStreamPosition();
                System.out.println("pos after return from native is " + l2);
            }
            if (!this.ignoreMetadata) {
                this.iis.seek(l);
                this.haveSeeked = true;
                this.streamMetadata = new JPEGMetadata(true, false, this.iis, this);
                l2 = this.iis.getStreamPosition();
                if (this.debug) {
                    System.out.println("pos after constructing stream metadata is " + l2);
                }
            }
            if (this.hasNextImage()) {
                this.imagePositions.add(new Long(this.iis.getStreamPosition()));
            }
        } else {
            this.imagePositions.add(new Long(l));
            this.currentImage = 0;
        }
        if (this.seekForwardOnly) {
            Long l3 = (Long)this.imagePositions.get(this.imagePositions.size() - 1);
            this.iis.flushBefore(l3);
        }
        this.tablesOnlyChecked = true;
    }

    public int getNumImages(boolean bl) throws IOException {
        if (this.numImages != 0) {
            return this.numImages;
        }
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        if (bl) {
            if (this.seekForwardOnly) {
                throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
            }
            if (!this.tablesOnlyChecked) {
                this.checkTablesOnly();
            }
            this.iis.mark();
            this.gotoImage(0);
            JPEGBuffer jPEGBuffer = new JPEGBuffer(this.iis);
            jPEGBuffer.loadBuf(0);
            boolean bl2 = false;
            block4: while (!bl2) {
                bl2 = jPEGBuffer.scanForFF(this);
                switch (jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF) {
                    case 216: {
                        ++this.numImages;
                    }
                    case 0: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 217: {
                        --jPEGBuffer.bufAvail;
                        ++jPEGBuffer.bufPtr;
                        continue block4;
                    }
                }
                --jPEGBuffer.bufAvail;
                ++jPEGBuffer.bufPtr;
                jPEGBuffer.loadBuf(2);
                int n = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8 | jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
                jPEGBuffer.bufAvail -= 2;
                jPEGBuffer.skipData(n -= 2);
            }
            this.iis.reset();
            return this.numImages;
        }
        return -1;
    }

    private void gotoImage(int n) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("Input not set");
        }
        if (n < this.minIndex) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.tablesOnlyChecked) {
            this.checkTablesOnly();
        }
        if (n < this.imagePositions.size()) {
            this.iis.seek((Long)this.imagePositions.get(n));
        } else {
            Long l = (Long)this.imagePositions.get(this.imagePositions.size() - 1);
            this.iis.seek(l);
            this.skipImage();
            for (int i = this.imagePositions.size(); i <= n; ++i) {
                if (!this.hasNextImage()) {
                    throw new IndexOutOfBoundsException();
                }
                l = new Long(this.iis.getStreamPosition());
                this.imagePositions.add(l);
                if (this.seekForwardOnly) {
                    this.iis.flushBefore(l);
                }
                if (i >= n) continue;
                this.skipImage();
            }
        }
        if (this.seekForwardOnly) {
            this.minIndex = n;
        }
        this.haveSeeked = true;
    }

    private void skipImage() throws IOException {
        if (this.debug) {
            System.out.println("skipImage called");
        }
        boolean bl = false;
        int n = this.iis.read();
        while (n != -1) {
            if (bl && n == 217) {
                return;
            }
            bl = n == 255;
            n = this.iis.read();
        }
        throw new IndexOutOfBoundsException();
    }

    private boolean hasNextImage() throws IOException {
        if (this.debug) {
            System.out.print("hasNextImage called; returning ");
        }
        this.iis.mark();
        boolean bl = false;
        int n = this.iis.read();
        while (n != -1) {
            if (bl && n == 216) {
                this.iis.reset();
                if (this.debug) {
                    System.out.println("true");
                }
                return true;
            }
            bl = n == 255;
            n = this.iis.read();
        }
        this.iis.reset();
        if (this.debug) {
            System.out.println("false");
        }
        return false;
    }

    private void pushBack(int n) throws IOException {
        if (this.debug) {
            System.out.println("pushing back " + n + " bytes");
        }
        this.iis.seek(this.iis.getStreamPosition() - (long)n);
    }

    private void readHeader(int n, boolean bl) throws IOException {
        this.gotoImage(n);
        this.readNativeHeader(bl);
        this.currentImage = n;
    }

    private boolean readNativeHeader(boolean bl) throws IOException {
        boolean bl2 = false;
        bl2 = this.readImageHeader(this.structPointer, this.haveSeeked, bl);
        this.haveSeeked = false;
        return bl2;
    }

    private native boolean readImageHeader(long var1, boolean var3, boolean var4) throws IOException;

    private void setImageData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.width = n;
        this.height = n2;
        this.colorSpaceCode = n3;
        this.outColorSpaceCode = n4;
        this.numComponents = n5;
        this.iccCS = null;
        if (byArray == null) {
            this.iccCS = null;
            return;
        }
        ICC_Profile iCC_Profile = null;
        try {
            iCC_Profile = ICC_Profile.getInstance(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.iccCS = null;
            this.warningOccurred(2);
            return;
        }
        byte[] byArray2 = iCC_Profile.getData();
        ICC_Profile iCC_Profile2 = null;
        if (this.iccCS instanceof ICC_ColorSpace) {
            iCC_Profile2 = ((ICC_ColorSpace)this.iccCS).getProfile();
        }
        byte[] byArray3 = null;
        if (iCC_Profile2 != null) {
            byArray3 = iCC_Profile2.getData();
        }
        if (byArray3 == null || !Arrays.equals(byArray3, byArray2)) {
            this.iccCS = new ICC_ColorSpace(iCC_Profile);
        }
    }

    public int getWidth(int n) throws IOException {
        if (this.currentImage != n) {
            this.readHeader(n, true);
        }
        return this.width;
    }

    public int getHeight(int n) throws IOException {
        if (this.currentImage != n) {
            this.readHeader(n, true);
        }
        return this.height;
    }

    private ImageTypeSpecifier getImageType(int n) {
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (n > 0 && n < 12) {
            imageTypeSpecifier = defaultTypes[n];
        }
        return imageTypeSpecifier;
    }

    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        if (this.currentImage != n) {
            this.readHeader(n, true);
        }
        return this.getImageType(this.colorSpaceCode);
    }

    public Iterator getImageTypes(int n) throws IOException {
        if (this.currentImage != n) {
            this.readHeader(n, true);
        }
        ImageTypeSpecifier imageTypeSpecifier = this.getImageType(this.colorSpaceCode);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        switch (this.colorSpaceCode) {
            case 1: {
                arrayList.add(imageTypeSpecifier);
                arrayList.add(this.getImageType(2));
                break;
            }
            case 2: {
                arrayList.add(imageTypeSpecifier);
                arrayList.add(this.getImageType(1));
                if (JPEG.YCC == null) break;
                arrayList.add(this.getImageType(5));
                break;
            }
            case 6: {
                arrayList.add(imageTypeSpecifier);
                break;
            }
            case 5: {
                if (imageTypeSpecifier == null) break;
                arrayList.add(imageTypeSpecifier);
                arrayList.add(this.getImageType(2));
                break;
            }
            case 10: {
                if (imageTypeSpecifier == null) break;
                arrayList.add(imageTypeSpecifier);
                break;
            }
            case 3: {
                if (this.iccCS != null) {
                    arrayList.add(ImageTypeSpecifier.createInterleaved(this.iccCS, JPEG.bOffsRGB, 0, false, false));
                }
                arrayList.add(this.getImageType(2));
                arrayList.add(this.getImageType(1));
                if (JPEG.YCC == null) break;
                arrayList.add(this.getImageType(5));
                break;
            }
            case 7: {
                arrayList.add(this.getImageType(6));
            }
        }
        return arrayList.iterator();
    }

    private void checkColorConversion(BufferedImage bufferedImage, ImageReadParam imageReadParam) throws IIOException {
        if (imageReadParam != null && (imageReadParam.getSourceBands() != null || imageReadParam.getDestinationBands() != null)) {
            return;
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            throw new IIOException("IndexColorModel not supported");
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = colorSpace.getType();
        this.convert = null;
        switch (this.outColorSpaceCode) {
            case 1: {
                if (n == 5) {
                    this.setOutColorSpace(this.structPointer, 2);
                    break;
                }
                if (n == 6) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 2: {
                if (n == 6) {
                    if (this.colorSpaceCode != 3) break;
                    this.setOutColorSpace(this.structPointer, 1);
                    break;
                }
                if (this.iccCS != null && colorModel.getNumComponents() == this.numComponents && colorSpace != this.iccCS) {
                    this.convert = new ColorConvertOp(this.iccCS, colorSpace, null);
                    break;
                }
                if (!colorSpace.isCS_sRGB() && colorModel.getNumComponents() == this.numComponents) {
                    this.convert = new ColorConvertOp(JPEG.sRGB, colorSpace, null);
                    break;
                }
                if (n == 5) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 6: {
                if (n == 5 && colorModel.getNumComponents() == this.numComponents) break;
                throw new IIOException("Incompatible color conversion");
            }
            case 5: {
                if (JPEG.YCC == null) {
                    throw new IIOException("Incompatible color conversion");
                }
                if (colorSpace == JPEG.YCC || colorModel.getNumComponents() != this.numComponents) break;
                this.convert = new ColorConvertOp(JPEG.YCC, colorSpace, null);
                break;
            }
            case 10: {
                if (JPEG.YCC != null && colorSpace == JPEG.YCC && colorModel.getNumComponents() == this.numComponents) break;
                throw new IIOException("Incompatible color conversion");
            }
            default: {
                throw new IIOException("Incompatible color conversion");
            }
        }
    }

    private native void setOutColorSpace(long var1, int var3);

    public ImageReadParam getDefaultReadParam() {
        return new JPEGImageReadParam();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        if (!this.tablesOnlyChecked) {
            this.checkTablesOnly();
        }
        return this.streamMetadata;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        if (this.imageMetadataIndex == n && this.imageMetadata != null) {
            return this.imageMetadata;
        }
        this.gotoImage(n);
        this.imageMetadata = new JPEGMetadata(false, false, this.iis, this);
        this.imageMetadataIndex = n;
        return this.imageMetadata;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        try {
            this.readInternal(n, imageReadParam, false);
        }
        catch (RuntimeException runtimeException) {
            this.resetLibraryState(this.structPointer);
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.resetLibraryState(this.structPointer);
            throw iOException;
        }
        BufferedImage bufferedImage = this.image;
        this.image = null;
        return bufferedImage;
    }

    private Raster readInternal(int n, ImageReadParam imageReadParam, boolean bl) throws IOException {
        Object object;
        Object object2;
        this.readHeader(n, false);
        WritableRaster writableRaster = null;
        int n2 = 0;
        if (!bl) {
            object2 = this.getImageTypes(n);
            if (!object2.hasNext()) {
                throw new IIOException("Unsupported Image Type");
            }
            this.image = JPEGImageReader.getDestination(imageReadParam, (Iterator<ImageTypeSpecifier>)object2, this.width, this.height);
            writableRaster = this.image.getRaster();
            n2 = this.image.getSampleModel().getNumBands();
            this.checkColorConversion(this.image, imageReadParam);
            JPEGImageReader.checkReadParamBandSettings(imageReadParam, this.numComponents, n2);
        } else {
            this.setOutColorSpace(this.structPointer, this.colorSpaceCode);
            this.image = null;
        }
        object2 = JPEG.bandOffsets[this.numComponents - 1];
        int n3 = bl ? this.numComponents : n2;
        this.destinationBands = null;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        this.destROI = new Rectangle(0, 0, 0, 0);
        JPEGImageReader.computeRegions(imageReadParam, this.width, this.height, this.image, rectangle, this.destROI);
        int n4 = 1;
        int n5 = 1;
        this.minProgressivePass = 0;
        this.maxProgressivePass = Integer.MAX_VALUE;
        if (imageReadParam != null) {
            n4 = imageReadParam.getSourceXSubsampling();
            n5 = imageReadParam.getSourceYSubsampling();
            int[] nArray = imageReadParam.getSourceBands();
            if (nArray != null) {
                object2 = nArray;
                n3 = ((Object)object2).length;
            }
            if (!bl) {
                this.destinationBands = imageReadParam.getDestinationBands();
            }
            this.minProgressivePass = imageReadParam.getSourceMinProgressivePass();
            this.maxProgressivePass = imageReadParam.getSourceMaxProgressivePass();
            if (imageReadParam instanceof JPEGImageReadParam && ((JPEGImageReadParam)(object = (Object)((JPEGImageReadParam)imageReadParam))).areTablesSet()) {
                this.abbrevQTables = ((JPEGImageReadParam)object).getQTables();
                this.abbrevDCHuffmanTables = ((JPEGImageReadParam)object).getDCHuffmanTables();
                this.abbrevACHuffmanTables = ((JPEGImageReadParam)object).getACHuffmanTables();
            }
        }
        int n6 = this.destROI.width * n3;
        this.buffer = new DataBufferByte(n6);
        object = JPEG.bandOffsets[n3 - 1];
        this.raster = Raster.createInterleavedRaster(this.buffer, this.destROI.width, 1, n6, n3, (int[])object, null);
        this.target = bl ? Raster.createInterleavedRaster(0, this.destROI.width, this.destROI.height, n6, n3, (int[])object, null) : writableRaster;
        int[] nArray = this.target.getSampleModel().getSampleSize();
        boolean bl2 = this.updateListeners != null || this.progressListeners != null;
        this.initProgressData();
        if (n == this.imageMetadataIndex) {
            this.knownPassCount = 0;
            Iterator iterator = this.imageMetadata.markerSequence.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof SOSMarkerSegment)) continue;
                ++this.knownPassCount;
            }
        }
        this.progInterval = Math.max((this.target.getHeight() - 1) / 20, 1);
        if (this.knownPassCount > 0) {
            this.progInterval *= this.knownPassCount;
        } else if (this.maxProgressivePass != Integer.MAX_VALUE) {
            this.progInterval *= this.maxProgressivePass - this.minProgressivePass + 1;
        }
        if (this.debug) {
            int n7;
            System.out.println("**** Read Data *****");
            System.out.println("numRasterBands is " + n3);
            System.out.print("srcBands:");
            for (n7 = 0; n7 < ((Object)object2).length; ++n7) {
                System.out.print(" " + (int)object2[n7]);
            }
            System.out.println();
            System.out.println("destination bands is " + this.destinationBands);
            if (this.destinationBands != null) {
                for (n7 = 0; n7 < this.destinationBands.length; ++n7) {
                    System.out.print(" " + this.destinationBands[n7]);
                }
                System.out.println();
            }
            System.out.println("sourceROI is " + rectangle);
            System.out.println("destROI is " + this.destROI);
            System.out.println("periodX is " + n4);
            System.out.println("periodY is " + n5);
            System.out.println("minProgressivePass is " + this.minProgressivePass);
            System.out.println("maxProgressivePass is " + this.maxProgressivePass);
            System.out.println("callbackUpdates is " + bl2);
        }
        this.processImageStarted(this.currentImage);
        boolean bl3 = false;
        bl3 = this.readImage(this.structPointer, this.buffer.getData(), n3, (int[])object2, nArray, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n4, n5, this.abbrevQTables, this.abbrevDCHuffmanTables, this.abbrevACHuffmanTables, this.minProgressivePass, this.maxProgressivePass, bl2);
        if (bl3) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.target;
    }

    private void acceptPixels(int n, boolean bl) {
        if (this.convert != null) {
            this.convert.filter(this.raster, this.raster);
        }
        this.target.setRect(this.destROI.x, this.destROI.y + n, this.raster);
        this.processImageUpdate(this.image, this.destROI.x, this.destROI.y + n, this.raster.getWidth(), 1, 1, 1, this.destinationBands);
        if (n > 0 && n % this.progInterval == 0) {
            int n2 = this.target.getHeight() - 1;
            float f = (float)n / (float)n2;
            if (bl) {
                if (this.knownPassCount != -1) {
                    this.processImageProgress(((float)this.pass + f) * 100.0f / (float)this.knownPassCount);
                } else if (this.maxProgressivePass != Integer.MAX_VALUE) {
                    this.processImageProgress(((float)this.pass + f) * 100.0f / (float)(this.maxProgressivePass - this.minProgressivePass + 1));
                } else {
                    int n3 = Math.max(2, 10 - this.pass);
                    int n4 = this.pass + n3 - 1;
                    this.progInterval = Math.max(n2 / 20 * n4, n4);
                    if (n % this.progInterval == 0) {
                        this.percentToDate = this.previousPassPercentage + (1.0f - this.previousPassPercentage) * f / (float)n3;
                        if (this.debug) {
                            System.out.print("pass= " + this.pass);
                            System.out.print(", y= " + n);
                            System.out.print(", progInt= " + this.progInterval);
                            System.out.print(", % of pass: " + f);
                            System.out.print(", rem. passes: " + n3);
                            System.out.print(", prev%: " + this.previousPassPercentage);
                            System.out.print(", %ToDate: " + this.percentToDate);
                            System.out.print(" ");
                        }
                        this.processImageProgress(this.percentToDate * 100.0f);
                    }
                }
            } else {
                this.processImageProgress(f * 100.0f);
            }
        }
    }

    private void initProgressData() {
        this.knownPassCount = -1;
        this.pass = 0;
        this.percentToDate = 0.0f;
        this.previousPassPercentage = 0.0f;
        this.progInterval = 0;
    }

    private void passStarted(int n) {
        this.pass = n;
        this.previousPassPercentage = this.percentToDate;
        this.processPassStarted(this.image, n, this.minProgressivePass, this.maxProgressivePass, 0, 0, 1, 1, this.destinationBands);
    }

    private void passComplete() {
        this.processPassComplete(this.image);
    }

    void thumbnailStarted(int n) {
        this.processThumbnailStarted(this.currentImage, n);
    }

    void thumbnailProgress(float f) {
        this.processThumbnailProgress(f);
    }

    void thumbnailComplete() {
        this.processThumbnailComplete();
    }

    private native boolean readImage(long var1, byte[] var3, int var4, int[] var5, int[] var6, int var7, int var8, int var9, int var10, int var11, int var12, JPEGQTable[] var13, JPEGHuffmanTable[] var14, JPEGHuffmanTable[] var15, int var16, int var17, boolean var18);

    public void abort() {
        super.abort();
        this.abortRead(this.structPointer);
    }

    private native void abortRead(long var1);

    private native void resetLibraryState(long var1);

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        Raster raster = null;
        try {
            Point point = null;
            if (imageReadParam != null) {
                point = imageReadParam.getDestinationOffset();
                imageReadParam.setDestinationOffset(new Point(0, 0));
            }
            raster = this.readInternal(n, imageReadParam, true);
            if (point != null) {
                this.target = this.target.createWritableTranslatedChild(point.x, point.y);
            }
        }
        catch (RuntimeException runtimeException) {
            this.resetLibraryState(this.structPointer);
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.resetLibraryState(this.structPointer);
            throw iOException;
        }
        return raster;
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public int getNumThumbnails(int n) throws IOException {
        this.getImageMetadata(n);
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
        int n2 = 0;
        if (jFIFMarkerSegment != null) {
            n2 = jFIFMarkerSegment.thumb == null ? 0 : 1;
            n2 += jFIFMarkerSegment.extSegments.size();
        }
        return n2;
    }

    public int getThumbnailWidth(int n, int n2) throws IOException {
        if (n2 < 0 || n2 >= this.getNumThumbnails(n)) {
            throw new IndexOutOfBoundsException("No such thumbnail");
        }
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
        return jFIFMarkerSegment.getThumbnailWidth(n2);
    }

    public int getThumbnailHeight(int n, int n2) throws IOException {
        if (n2 < 0 || n2 >= this.getNumThumbnails(n)) {
            throw new IndexOutOfBoundsException("No such thumbnail");
        }
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
        return jFIFMarkerSegment.getThumbnailHeight(n2);
    }

    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        if (n2 < 0 || n2 >= this.getNumThumbnails(n)) {
            throw new IndexOutOfBoundsException("No such thumbnail");
        }
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.imageMetadata.findMarkerSegment(JFIFMarkerSegment.class, true);
        return jFIFMarkerSegment.getThumbnail(this.iis, n2, this);
    }

    private void resetInternalState() {
        this.resetReader(this.structPointer);
        this.numImages = 0;
        this.imagePositions = new ArrayList();
        this.currentImage = -1;
        this.image = null;
        this.raster = null;
        this.target = null;
        this.buffer = null;
        this.destROI = null;
        this.destinationBands = null;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        this.haveSeeked = false;
        this.tablesOnlyChecked = false;
        this.iccCS = null;
        this.initProgressData();
    }

    private native void resetReader(long var1);

    public void dispose() {
        if (this.structPointer != 0L) {
            this.disposerRecord.dispose();
            this.structPointer = 0L;
        }
    }

    private static native void disposeReader(long var0);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageReader.initReaderIDs(ImageInputStream.class, JPEGQTable.class, JPEGHuffmanTable.class);
        defaultTypes = new ImageTypeSpecifier[12];
        JPEGImageReader.defaultTypes[1] = ImageTypeSpecifier.createFromBufferedImageType(10);
        JPEGImageReader.defaultTypes[2] = ImageTypeSpecifier.createInterleaved(JPEG.sRGB, JPEG.bOffsRGB, 0, false, false);
        JPEGImageReader.defaultTypes[6] = ImageTypeSpecifier.createPacked(JPEG.sRGB, -16777216, 0xFF0000, 65280, 255, 3, false);
        if (JPEG.YCC != null) {
            JPEGImageReader.defaultTypes[5] = ImageTypeSpecifier.createInterleaved(JPEG.YCC, JPEG.bandOffsets[2], 0, false, false);
            JPEGImageReader.defaultTypes[10] = ImageTypeSpecifier.createInterleaved(JPEG.YCC, JPEG.bandOffsets[3], 0, true, false);
        }
    }

    private static class JPEGReaderDisposerRecord
    extends DisposerRecord {
        private long pData;

        public JPEGReaderDisposerRecord(long l) {
            this.pData = l;
        }

        public synchronized void dispose() {
            if (this.pData != 0L) {
                JPEGImageReader.disposeReader(this.pData);
                this.pData = 0L;
            }
        }
    }
}

