/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CAccept;
import com.sun.jlex.internal.CAlloc;
import com.sun.jlex.internal.CError;
import com.sun.jlex.internal.CInput;
import com.sun.jlex.internal.CLexGen;
import com.sun.jlex.internal.CNfa;
import com.sun.jlex.internal.CNfaPair;
import com.sun.jlex.internal.CSet;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.CUtility;
import com.sun.jlex.internal.SparseBitSet;
import java.io.IOException;
import java.util.Vector;

class CMakeNfa {
    private CSpec m_spec;
    private CLexGen m_lexGen;
    private CInput m_input;

    CMakeNfa() {
        this.reset();
    }

    private void reset() {
        this.m_input = null;
        this.m_lexGen = null;
        this.m_spec = null;
    }

    private void set(CLexGen cLexGen, CSpec cSpec, CInput cInput) {
        CUtility._assert(null != cInput);
        CUtility._assert(null != cLexGen);
        CUtility._assert(null != cSpec);
        this.m_input = cInput;
        this.m_lexGen = cLexGen;
        this.m_spec = cSpec;
    }

    void allocate_BOL_EOF(CSpec cSpec) {
        CUtility._assert(true);
        cSpec.BOL = cSpec.m_dtrans_ncols++;
        cSpec.EOF = cSpec.m_dtrans_ncols++;
    }

    void thompson(CLexGen cLexGen, CSpec cSpec, CInput cInput) throws IOException {
        int n;
        this.reset();
        this.set(cLexGen, cSpec, cInput);
        int n2 = this.m_spec.m_states.size();
        this.m_spec.m_state_rules = new Vector[n2];
        for (n = 0; n < n2; ++n) {
            this.m_spec.m_state_rules[n] = new Vector();
        }
        this.m_spec.m_nfa_start = this.machine();
        n2 = this.m_spec.m_nfa_states.size();
        n = 0;
        while (n < n2) {
            CNfa cNfa = (CNfa)this.m_spec.m_nfa_states.elementAt(n);
            cNfa.m_label = n++;
        }
        if (this.m_spec.m_verbose) {
            System.out.println("NFA comprised of " + (this.m_spec.m_nfa_states.size() + 1) + " states.");
        }
        this.reset();
    }

    private void discardCNfa(CNfa cNfa) {
        this.m_spec.m_nfa_states.removeElement(cNfa);
    }

    private void processStates(SparseBitSet sparseBitSet, CNfa cNfa) {
        int n = this.m_spec.m_states.size();
        for (int i = 0; i < n; ++i) {
            if (!sparseBitSet.get(i)) continue;
            this.m_spec.m_state_rules[i].addElement(cNfa);
        }
    }

    private CNfa machine() throws IOException {
        CNfa cNfa;
        CNfa cNfa2 = cNfa = CAlloc.newCNfa(this.m_spec);
        SparseBitSet sparseBitSet = this.m_lexGen.getStates();
        this.m_spec.m_current_token = 1;
        this.m_lexGen.advance();
        if (11 != this.m_spec.m_current_token) {
            cNfa2.m_next = this.rule();
            this.processStates(sparseBitSet, cNfa2.m_next);
        }
        while (true) {
            if (11 == this.m_spec.m_current_token) break;
            sparseBitSet = this.m_lexGen.getStates();
            this.m_lexGen.advance();
            if (11 == this.m_spec.m_current_token) break;
            cNfa2 = cNfa2.m_next2 = CAlloc.newCNfa(this.m_spec);
            cNfa2.m_next = this.rule();
            this.processStates(sparseBitSet, cNfa2.m_next);
        }
        SparseBitSet sparseBitSet2 = new SparseBitSet();
        for (int i = 0; i < this.m_spec.m_states.size(); ++i) {
            sparseBitSet2.set(i);
        }
        cNfa2 = cNfa2.m_next2 = CAlloc.newCNfa(this.m_spec);
        cNfa2.m_next = CAlloc.newCNfa(this.m_spec);
        cNfa2.m_next.m_edge = -1;
        cNfa2.m_next.m_next = CAlloc.newCNfa(this.m_spec);
        cNfa2.m_next.m_set = new CSet();
        cNfa2.m_next.m_set.add(this.m_spec.BOL);
        cNfa2.m_next.m_set.add(this.m_spec.EOF);
        cNfa2.m_next.m_next.m_accept = new CAccept(new char[0], 0, this.m_input.m_line_number + 1);
        this.processStates(sparseBitSet2, cNfa2.m_next);
        return cNfa;
    }

    private CNfa rule() throws IOException {
        CNfa cNfa = null;
        CNfa cNfa2 = null;
        int n = 0;
        CNfaPair cNfaPair = CAlloc.newCNfaPair();
        if (3 == this.m_spec.m_current_token) {
            n |= 1;
            this.m_lexGen.advance();
            this.expr(cNfaPair);
            cNfa = CAlloc.newCNfa(this.m_spec);
            cNfa.m_edge = this.m_spec.BOL;
            cNfa.m_next = cNfaPair.m_start;
            cNfa2 = cNfaPair.m_end;
        } else {
            this.expr(cNfaPair);
            cNfa = cNfaPair.m_start;
            cNfa2 = cNfaPair.m_end;
        }
        if (4 == this.m_spec.m_current_token) {
            this.m_lexGen.advance();
            CNfaPair cNfaPair2 = CAlloc.newNLPair(this.m_spec);
            cNfa2.m_next = CAlloc.newCNfa(this.m_spec);
            cNfa2.m_next.m_next = cNfaPair2.m_start;
            cNfa2.m_next.m_next2 = CAlloc.newCNfa(this.m_spec);
            cNfa2.m_next.m_next2.m_edge = this.m_spec.EOF;
            cNfa2.m_next.m_next2.m_next = cNfaPair2.m_end;
            cNfa2 = cNfaPair2.m_end;
            n |= 2;
        }
        if (cNfa2 == null) {
            CError.parse_error(19, this.m_input.m_line_number);
        }
        cNfa2.m_accept = this.m_lexGen.packAccept();
        cNfa2.m_anchor = n;
        return cNfa;
    }

    private void expr(CNfaPair cNfaPair) throws IOException {
        CUtility._assert(null != cNfaPair);
        CNfaPair cNfaPair2 = CAlloc.newCNfaPair();
        this.cat_expr(cNfaPair);
        while (true) {
            if (16 != this.m_spec.m_current_token) break;
            this.m_lexGen.advance();
            this.cat_expr(cNfaPair2);
            CNfa cNfa = CAlloc.newCNfa(this.m_spec);
            cNfa.m_next2 = cNfaPair2.m_start;
            cNfa.m_next = cNfaPair.m_start;
            cNfaPair.m_start = cNfa;
            cNfaPair.m_end.m_next = cNfa = CAlloc.newCNfa(this.m_spec);
            cNfaPair2.m_end.m_next = cNfa;
            cNfaPair.m_end = cNfa;
        }
    }

    private void cat_expr(CNfaPair cNfaPair) throws IOException {
        CUtility._assert(null != cNfaPair);
        CNfaPair cNfaPair2 = CAlloc.newCNfaPair();
        if (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(cNfaPair);
        }
        while (this.first_in_cat(this.m_spec.m_current_token)) {
            this.factor(cNfaPair2);
            cNfaPair.m_end.mimic(cNfaPair2.m_start);
            this.discardCNfa(cNfaPair2.m_start);
            cNfaPair.m_end = cNfaPair2.m_end;
        }
    }

    private boolean first_in_cat(int n) {
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                return false;
            }
            case 9: 
            case 15: 
            case 17: {
                CError.parse_error(5, this.m_input.m_line_number);
                return false;
            }
            case 5: {
                CError.parse_error(3, this.m_input.m_line_number);
                return false;
            }
            case 3: {
                CError.parse_error(4, this.m_input.m_line_number);
                return false;
            }
        }
        return true;
    }

    private void factor(CNfaPair cNfaPair) throws IOException {
        block5: {
            CNfa cNfa;
            CNfa cNfa2;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                cNfa2 = null;
                                cNfa = null;
                                this.term(cNfaPair);
                                if (9 == this.m_spec.m_current_token) break block4;
                                if (17 == this.m_spec.m_current_token) break block4;
                                if (15 != this.m_spec.m_current_token) break block5;
                            }
                            cNfa2 = CAlloc.newCNfa(this.m_spec);
                            cNfa = CAlloc.newCNfa(this.m_spec);
                            cNfa2.m_next = cNfaPair.m_start;
                            cNfaPair.m_end.m_next = cNfa;
                            if (9 == this.m_spec.m_current_token) break block6;
                            if (15 != this.m_spec.m_current_token) break block7;
                        }
                        cNfa2.m_next2 = cNfa;
                    }
                    if (9 == this.m_spec.m_current_token) break block8;
                    if (17 != this.m_spec.m_current_token) break block9;
                }
                cNfaPair.m_end.m_next2 = cNfaPair.m_start;
            }
            cNfaPair.m_start = cNfa2;
            cNfaPair.m_end = cNfa;
            this.m_lexGen.advance();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void term(CNfaPair var1_1) throws IOException {
        block13: {
            block12: {
                if (14 != this.m_spec.m_current_token) break block12;
                this.m_lexGen.advance();
                this.expr(var1_1);
                if (8 == this.m_spec.m_current_token) {
                    this.m_lexGen.advance();
                } else {
                    CError.parse_error(16, this.m_input.m_line_number);
                }
                break block13;
            }
            var1_1.m_start = var2_2 = CAlloc.newCNfa(this.m_spec);
            var1_1.m_end = var2_2.m_next = CAlloc.newCNfa(this.m_spec);
            var3_3 = 12 == this.m_spec.m_current_token && Character.isLetter(this.m_spec.m_lexeme) != false;
            if (2 == this.m_spec.m_current_token) ** GOTO lbl-1000
            if (6 == this.m_spec.m_current_token || this.m_spec.m_ignorecase && var3_3) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) {
                var2_2.m_edge = this.m_spec.m_lexeme;
                this.m_lexGen.advance();
            } else {
                var2_2.m_edge = -1;
                var2_2.m_set = new CSet();
                if (this.m_spec.m_ignorecase && var3_3) {
                    var2_2.m_set.addncase(this.m_spec.m_lexeme);
                } else if (2 == this.m_spec.m_current_token) {
                    var2_2.m_set.add(10);
                    var2_2.m_set.add(13);
                    var2_2.m_set.add(this.m_spec.BOL);
                    var2_2.m_set.add(this.m_spec.EOF);
                    var2_2.m_set.complement();
                } else {
                    this.m_lexGen.advance();
                    if (3 == this.m_spec.m_current_token) {
                        this.m_lexGen.advance();
                        var2_2.m_set.add(this.m_spec.BOL);
                        var2_2.m_set.add(this.m_spec.EOF);
                        var2_2.m_set.complement();
                    }
                    if (!(5 == this.m_spec.m_current_token)) {
                        this.dodash(var2_2.m_set);
                    }
                }
                this.m_lexGen.advance();
            }
        }
    }

    private void dodash(CSet cSet) throws IOException {
        int n = -1;
        while (true) {
            if (1 == this.m_spec.m_current_token) break;
            if (5 == this.m_spec.m_current_token) break;
            if (10 == this.m_spec.m_current_token && -1 != n) {
                this.m_lexGen.advance();
                if (this.m_spec.m_current_token == 5) {
                    cSet.add(45);
                    break;
                }
                while (n <= this.m_spec.m_lexeme) {
                    if (this.m_spec.m_ignorecase) {
                        cSet.addncase((char)n);
                    } else {
                        cSet.add(n);
                    }
                    ++n;
                }
            } else {
                n = this.m_spec.m_lexeme;
                if (this.m_spec.m_ignorecase) {
                    cSet.addncase(this.m_spec.m_lexeme);
                } else {
                    cSet.add(this.m_spec.m_lexeme);
                }
            }
            this.m_lexGen.advance();
        }
    }
}

