/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.Node;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.ParserTreeConstants;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.util.Hashtable;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Parser parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Parser parser2, int n) {
        this(n);
        this.parser = parser2;
    }

    public static Node jjtCreate(int n) {
        return new SimpleNode(n);
    }

    public static Node jjtCreate(Parser parser2, int n) {
        return new SimpleNode(parser2, n);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void buildTrapEntries(Hashtable hashtable) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.buildTrapEntries(hashtable);
            }
        }
    }

    public void buildInformEntries(Hashtable hashtable) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.buildInformEntries(hashtable);
            }
        }
    }

    public void buildAclEntries(PrincipalImpl principalImpl, AclImpl aclImpl) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.buildAclEntries(principalImpl, aclImpl);
            }
        }
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }
}

