/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    private int readTimeout;
    private Object pauseLock = new Object();
    private boolean paused = false;

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, int n2, int n3, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        this.readTimeout = n3;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n, string2, n2);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Object createInetSocketAddress(String string, int n) throws NoSuchMethodException {
        try {
            Class<?> clazz = Class.forName("java.net.InetSocketAddress");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            return constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchMethodException();
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchMethodException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchMethodException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchMethodException();
        }
    }

    private Socket createSocket(String string, int n, String string2, int n2) throws Exception {
        Socket socket = null;
        if (string2 != null) {
            Class clazz = Obj.helper.loadClass(string2);
            Method method = clazz.getMethod("getDefault", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = null;
            if (n2 > 0) {
                try {
                    method2 = clazz.getMethod("createSocket", new Class[0]);
                    Method method3 = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object2 = this.createInetSocketAddress(string, n);
                    socket = (Socket)method2.invoke(object, new Object[0]);
                    method3.invoke(socket, object2, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                method2 = clazz.getMethod("createSocket", String.class, Integer.TYPE);
                socket = (Socket)method2.invoke(object, string, new Integer(n));
            }
        } else {
            if (n2 > 0) {
                try {
                    Constructor constructor = Socket.class.getConstructor(new Class[0]);
                    Method method = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object = this.createInetSocketAddress(string, n);
                    socket = (Socket)constructor.newInstance(new Object[0]);
                    method.invoke(socket, object, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(string, n);
            }
        }
        return socket;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        return this.writeRequest(berEncoder, n, false, -1);
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl) throws IOException {
        return this.writeRequest(berEncoder, n, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl, int n2) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n, bl, n2);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            this.cleanup(null, true);
            this.closureReason = iOException;
            throw this.closureReason;
        }
        return ldapRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        boolean bl = false;
        while ((berDecoder = ldapRequest.getReplyBer()) == null && !bl) {
            try {
                Object object = this;
                synchronized (object) {
                    if (this.sock == null) {
                        throw new ServiceUnavailableException(this.host + ":" + this.port + "; socket closed");
                    }
                }
                object = ldapRequest;
                synchronized (object) {
                    berDecoder = ldapRequest.getReplyBer();
                    if (berDecoder != null) {
                        break;
                    }
                    if (this.readTimeout > 0) {
                        ldapRequest.wait(this.readTimeout);
                        bl = true;
                    } else {
                        ldapRequest.wait(15000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        this.unpauseReader();
        if (berDecoder == null && bl) {
            this.removeRequest(ldapRequest);
            throw new NamingException("LDAP response read timed out, timeout used:" + this.readTimeout + "ms.");
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void cleanup(Control[] controlArray, boolean bl) {
        boolean bl2;
        block16: {
            bl2 = false;
            Connection connection = this;
            synchronized (connection) {
                block17: {
                    block15: {
                        this.useable = false;
                        if (this.sock == null) break block16;
                        if (!bl) {
                            this.abandonOutstandingReqs(controlArray);
                        }
                        if (!this.bound) break block15;
                        this.ldapUnbind(controlArray);
                    }
                    try {
                        this.outStream.flush();
                        this.sock.close();
                        this.unpauseReader();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!bl) {
                        LdapRequest ldapRequest = this.pendingRequests;
                        while (ldapRequest != null) {
                            ldapRequest.cancel();
                            ldapRequest = ldapRequest.next;
                        }
                    }
                    break block17;
                    catch (Throwable throwable) {
                        try {
                            this.outStream.flush();
                            this.sock.close();
                            this.unpauseReader();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!bl) {
                            LdapRequest ldapRequest = this.pendingRequests;
                            while (ldapRequest != null) {
                                ldapRequest.cancel();
                                ldapRequest = ldapRequest.next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                }
                this.sock = null;
                bl2 = bl;
            }
        }
        if (bl2) {
            this.parent.processConnectionClosure();
        }
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block27: {
            InputStream inputStream = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                int n;
                                int n2;
                                byte[] byArray = new byte[2048];
                                int n3 = 0;
                                int n4 = 0;
                                int n5 = 0;
                                inputStream = this.getInputStream();
                                int n6 = inputStream.read(byArray, n3, 1);
                                if (n6 < 0) {
                                    if (inputStream != this.getInputStream()) {
                                        continue;
                                    }
                                    break block27;
                                }
                                if (byArray[n3++] != 48) continue;
                                n6 = inputStream.read(byArray, n3, 1);
                                if (n6 < 0) {
                                    break block27;
                                }
                                if (((n4 = byArray[n3++]) & 0x80) == 128) {
                                    int n7;
                                    n5 = n4 & 0x7F;
                                    boolean bl = false;
                                    for (n6 = 0; n6 < n5; n6 += n7) {
                                        n7 = inputStream.read(byArray, n3 + n6, n5 - n6);
                                        if (n7 >= 0) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) {
                                        break block27;
                                    }
                                    n4 = 0;
                                    for (n2 = 0; n2 < n5; ++n2) {
                                        n4 = (n4 << 8) + (byArray[n3 + n2] & 0xFF);
                                    }
                                    n3 += n6;
                                }
                                if (n3 + (n = n4) > byArray.length) {
                                    byte[] byArray2 = new byte[n3 + n];
                                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                                    byArray = byArray2;
                                }
                                while (n > 0 && (n6 = inputStream.read(byArray, n3, n)) >= 0) {
                                    n3 += n6;
                                    n -= n6;
                                }
                                try {
                                    BerDecoder berDecoder = new BerDecoder(byArray, 0, n3);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n3);
                                    }
                                    berDecoder.parseSeq(null);
                                    int n8 = berDecoder.parseInt();
                                    berDecoder.reset();
                                    n2 = 0;
                                    if (n8 == 0) {
                                        this.parent.processUnsolicited(berDecoder);
                                        continue block12;
                                    }
                                    LdapRequest ldapRequest = this.findRequest(n8);
                                    if (ldapRequest == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        n2 = ldapRequest.addReplyBer(berDecoder) ? 1 : 0;
                                        if (n2 != 0) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (inputStream != this.getInputStream()) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.closureReason = iOException;
                    break block27;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }
}

