/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class StreamTokenizer {
    private Reader reader = null;
    private InputStream input = null;
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private boolean pushedBack;
    private boolean forceLower;
    private int LINENO = 1;
    private boolean eolIsSignificantP = false;
    private boolean slashSlashCommentsP = false;
    private boolean slashStarCommentsP = false;
    private byte[] ctype = new byte[256];
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    public int ttype = -4;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_NOTHING = -4;
    public String sval;
    public double nval;

    private StreamTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    @Deprecated
    public StreamTokenizer(InputStream inputStream) {
        this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.input = inputStream;
    }

    public StreamTokenizer(Reader reader) {
        this();
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public void resetSyntax() {
        int n = this.ctype.length;
        while (--n >= 0) {
            this.ctype[n] = 0;
        }
    }

    public void wordChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            int n3 = n++;
            this.ctype[n3] = (byte)(this.ctype[n3] | 4);
        }
    }

    public void whitespaceChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            this.ctype[n++] = 1;
        }
    }

    public void ordinaryChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            this.ctype[n++] = 0;
        }
    }

    public void ordinaryChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 0;
        }
    }

    public void commentChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 16;
        }
    }

    public void quoteChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 8;
        }
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            this.ctype[n2] = (byte)(this.ctype[n2] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    public void eolIsSignificant(boolean bl) {
        this.eolIsSignificantP = bl;
    }

    public void slashStarComments(boolean bl) {
        this.slashStarCommentsP = bl;
    }

    public void slashSlashComments(boolean bl) {
        this.slashSlashCommentsP = bl;
    }

    public void lowerCaseMode(boolean bl) {
        this.forceLower = bl;
    }

    private int read() throws IOException {
        if (this.reader != null) {
            return this.reader.read();
        }
        if (this.input != null) {
            return this.input.read();
        }
        throw new IllegalStateException();
    }

    public int nextToken() throws IOException {
        int n;
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        byte[] byArray = this.ctype;
        this.sval = null;
        int n2 = this.peekc;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 == 0x7FFFFFFE) {
            n2 = this.read();
            if (n2 < 0) {
                this.ttype = -1;
                return -1;
            }
            if (n2 == 10) {
                n2 = Integer.MAX_VALUE;
            }
        }
        if (n2 == Integer.MAX_VALUE && (n2 = this.read()) < 0) {
            this.ttype = -1;
            return -1;
        }
        this.ttype = n2;
        this.peekc = Integer.MAX_VALUE;
        int n3 = n = n2 < 256 ? byArray[n2] : 4;
        while ((n & 1) != 0) {
            if (n2 == 13) {
                ++this.LINENO;
                if (this.eolIsSignificantP) {
                    this.peekc = 0x7FFFFFFE;
                    this.ttype = 10;
                    return 10;
                }
                n2 = this.read();
                if (n2 == 10) {
                    n2 = this.read();
                }
            } else {
                if (n2 == 10) {
                    ++this.LINENO;
                    if (this.eolIsSignificantP) {
                        this.ttype = 10;
                        return 10;
                    }
                }
                n2 = this.read();
            }
            if (n2 < 0) {
                this.ttype = -1;
                return -1;
            }
            n = n2 < 256 ? byArray[n2] : 4;
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            if (n2 == 45) {
                n2 = this.read();
                if (n2 != 46 && (n2 < 48 || n2 > 57)) {
                    this.peekc = n2;
                    this.ttype = 45;
                    return 45;
                }
                bl = true;
            }
            double d = 0.0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                if (n2 == 46 && n5 == 0) {
                    n5 = 1;
                } else {
                    if (48 > n2 || n2 > 57) break;
                    d = d * 10.0 + (double)(n2 - 48);
                    n4 += n5;
                }
                n2 = this.read();
            }
            this.peekc = n2;
            if (n4 != 0) {
                double d2 = 10.0;
                --n4;
                while (n4 > 0) {
                    d2 *= 10.0;
                    --n4;
                }
                d /= d2;
            }
            this.nval = bl ? -d : d;
            this.ttype = -2;
            return -2;
        }
        if ((n & 4) != 0) {
            int n6 = 0;
            do {
                if (n6 >= this.buf.length) {
                    char[] cArray = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                }
                this.buf[n6++] = (char)n2;
            } while (((n = (n2 = this.read()) < 0 ? 1 : (n2 < 256 ? byArray[n2] : 4)) & 6) != 0);
            this.peekc = n2;
            this.sval = String.copyValueOf(this.buf, 0, n6);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return -3;
        }
        if ((n & 8) != 0) {
            this.ttype = n2;
            int n7 = 0;
            int n8 = this.read();
            while (n8 >= 0 && n8 != this.ttype && n8 != 10 && n8 != 13) {
                if (n8 == 92) {
                    int n9 = n2 = this.read();
                    if (n2 >= 48 && n2 <= 55) {
                        n2 -= 48;
                        int n10 = this.read();
                        if (48 <= n10 && n10 <= 55) {
                            n2 = (n2 << 3) + (n10 - 48);
                            n10 = this.read();
                            if (48 <= n10 && n10 <= 55 && n9 <= 51) {
                                n2 = (n2 << 3) + (n10 - 48);
                                n8 = this.read();
                            } else {
                                n8 = n10;
                            }
                        } else {
                            n8 = n10;
                        }
                    } else {
                        switch (n2) {
                            case 97: {
                                n2 = 7;
                                break;
                            }
                            case 98: {
                                n2 = 8;
                                break;
                            }
                            case 102: {
                                n2 = 12;
                                break;
                            }
                            case 110: {
                                n2 = 10;
                                break;
                            }
                            case 114: {
                                n2 = 13;
                                break;
                            }
                            case 116: {
                                n2 = 9;
                                break;
                            }
                            case 118: {
                                n2 = 11;
                            }
                        }
                        n8 = this.read();
                    }
                } else {
                    n2 = n8;
                    n8 = this.read();
                }
                if (n7 >= this.buf.length) {
                    char[] cArray = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                }
                this.buf[n7++] = (char)n2;
            }
            this.peekc = n8 == this.ttype ? Integer.MAX_VALUE : n8;
            this.sval = String.copyValueOf(this.buf, 0, n7);
            return this.ttype;
        }
        if (n2 == 47 && (this.slashSlashCommentsP || this.slashStarCommentsP)) {
            n2 = this.read();
            if (n2 == 42 && this.slashStarCommentsP) {
                int n11 = 0;
                while ((n2 = this.read()) != 47 || n11 != 42) {
                    if (n2 == 13) {
                        ++this.LINENO;
                        n2 = this.read();
                        if (n2 == 10) {
                            n2 = this.read();
                        }
                    } else if (n2 == 10) {
                        ++this.LINENO;
                        n2 = this.read();
                    }
                    if (n2 < 0) {
                        this.ttype = -1;
                        return -1;
                    }
                    n11 = n2;
                }
                return this.nextToken();
            }
            if (n2 == 47 && this.slashSlashCommentsP) {
                while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
                }
                this.peekc = n2;
                return this.nextToken();
            }
            if ((byArray[47] & 0x10) != 0) {
                while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
                }
                this.peekc = n2;
                return this.nextToken();
            }
            this.peekc = n2;
            this.ttype = 47;
            return 47;
        }
        if ((n & 0x10) != 0) {
            while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
            }
            this.peekc = n2;
            return this.nextToken();
        }
        this.ttype = n2;
        return this.ttype;
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.LINENO;
    }

    public String toString() {
        String string;
        switch (this.ttype) {
            case -1: {
                string = "EOF";
                break;
            }
            case 10: {
                string = "EOL";
                break;
            }
            case -3: {
                string = this.sval;
                break;
            }
            case -2: {
                string = "n=" + this.nval;
                break;
            }
            case -4: {
                string = "NOTHING";
                break;
            }
            default: {
                if (this.ttype < 256 && (this.ctype[this.ttype] & 8) != 0) {
                    string = this.sval;
                    break;
                }
                char[] cArray = new char[3];
                cArray[2] = 39;
                cArray[0] = 39;
                cArray[1] = (char)this.ttype;
                string = new String(cArray);
                break;
            }
        }
        return "Token[" + string + "], line " + this.LINENO;
    }
}

