/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.LoginUtility;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;

public class Krb5Util {
    static final boolean DEBUG = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));

    private Krb5Util() {
    }

    public static KerberosTicket getTicketFromSubjectAndTgs(String string, String string2, String string3, String string4, AccessControlContext accessControlContext) throws LoginException, KrbException, IOException {
        Credentials credentials;
        Credentials credentials2;
        boolean bl;
        KerberosTicket kerberosTicket;
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket2 = (KerberosTicket)SubjectComber.find(subject, string3, string2, KerberosTicket.class);
        if (kerberosTicket2 != null) {
            return kerberosTicket2;
        }
        Subject subject2 = null;
        if (!LoginUtility.useSubjectCredsOnly()) {
            try {
                subject2 = LoginUtility.login(string);
                kerberosTicket2 = (KerberosTicket)SubjectComber.find(subject2, string3, string2, KerberosTicket.class);
                if (kerberosTicket2 != null) {
                    return kerberosTicket2;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if ((kerberosTicket = (KerberosTicket)SubjectComber.find(subject, string4, string2, KerberosTicket.class)) == null && subject2 != null) {
            kerberosTicket = (KerberosTicket)SubjectComber.find(subject2, string4, string2, KerberosTicket.class);
            bl = false;
        } else {
            bl = true;
        }
        if (kerberosTicket != null && (credentials2 = Credentials.acquireServiceCreds(string3, credentials = Krb5Util.ticketToCreds(kerberosTicket))) != null) {
            kerberosTicket2 = Krb5Util.credsToTicket(credentials2);
            if (bl && subject != null && !subject.isReadOnly()) {
                subject.getPrivateCredentials().add(kerberosTicket2);
            }
        }
        return kerberosTicket2;
    }

    static KerberosTicket getTicketFromSubject(String string, String string2, String string3, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket = (KerberosTicket)SubjectComber.find(subject, string3, string2, KerberosTicket.class);
        if (kerberosTicket == null && !LoginUtility.useSubjectCredsOnly()) {
            Subject subject2 = LoginUtility.login(string);
            kerberosTicket = (KerberosTicket)SubjectComber.find(subject2, string3, string2, KerberosTicket.class);
        }
        return kerberosTicket;
    }

    public static Subject getSubject(String string, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null && !LoginUtility.useSubjectCredsOnly()) {
            subject = LoginUtility.login(string);
        }
        return subject;
    }

    public static KerberosKey[] getKeysFromSubject(String string, String string2, AccessControlContext accessControlContext) throws LoginException {
        int n;
        Subject subject = Subject.getSubject(accessControlContext);
        List list = (List)SubjectComber.findMany(subject, string2, null, KerberosKey.class);
        if (list == null && !LoginUtility.useSubjectCredsOnly()) {
            Subject subject2 = LoginUtility.login(string);
            list = (List)SubjectComber.findMany(subject2, string2, null, KerberosKey.class);
        }
        if (list != null && (n = list.size()) > 0) {
            KerberosKey[] kerberosKeyArray = new KerberosKey[n];
            list.toArray(kerberosKeyArray);
            return kerberosKeyArray;
        }
        return null;
    }

    public static KerberosTicket credsToTicket(Credentials credentials) {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        return new KerberosTicket(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName()), encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    public static Credentials ticketToCreds(KerberosTicket kerberosTicket) throws KrbException, IOException {
        return new Credentials(kerberosTicket.getEncoded(), kerberosTicket.getClient().getName(), kerberosTicket.getServer().getName(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }
}

