/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;

public final class DeployClientAuthCertStore
implements CertStore {
    private static JDialog myParent = null;
    private static String _filenameUser = null;
    private static String _filenameSys = null;
    private char[] savePassword = null;
    private KeyStore _deploymentUserClientCerts = null;
    private KeyStore _deploymentSystemClientCerts = null;

    public DeployClientAuthCertStore() {
    }

    public DeployClientAuthCertStore(JDialog jDialog) {
        myParent = jDialog;
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this._deploymentUserClientCerts = this.load(_filenameUser);
        this._deploymentSystemClientCerts = this.load(_filenameSys);
    }

    private KeyStore load(final String string) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loading", new Object[]{string});
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(string);
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        keyStore.load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saving", new Object[]{_filenameUser});
        final char[] cArray = this.getPasswordDialog("clientauth.password.dialog.text");
        if (cArray != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                        File file = new File(_filenameUser);
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        DeployClientAuthCertStore.this._deploymentUserClientCerts.store(bufferedOutputStream, cArray);
                        bufferedOutputStream.close();
                        fileOutputStream.close();
                        DeployClientAuthCertStore.this.setPassword(null);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                if (exception instanceof KeyStoreException) {
                    throw (KeyStoreException)exception;
                }
                if (exception instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)exception;
                }
                Trace.securityPrintException(privilegedActionException);
            }
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saved", new Object[]{_filenameUser});
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.adding");
        String string = this._deploymentUserClientCerts.getCertificateAlias(certificate);
        if (string == null) {
            Random random = new Random();
            boolean bl = false;
            String string2 = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentUserClientCerts.getCertificate(string2 = "clientauthcert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._deploymentUserClientCerts.setCertificateEntry(string2, certificate);
            Trace.msgSecurityPrintln("clientauthcertstore.cert.added", new Object[]{string2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addCertKey(Certificate[] certificateArray, Key key) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        Object object;
        if (this.contains(certificateArray[0])) {
            return false;
        }
        Random random = new Random();
        boolean bl = false;
        String string = null;
        do {
            if ((object = this._deploymentUserClientCerts.getCertificate(string = "clientauthcert" + random.nextLong())) != null) continue;
            bl = true;
        } while (!bl);
        object = this.getPasswordDialog("clientauth.password.dialog.text");
        if (object == null) {
            return false;
        }
        File file = new File(_filenameUser);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(_filenameUser);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                try {
                    this._deploymentUserClientCerts.load(bufferedInputStream, (char[])object);
                    this._deploymentUserClientCerts.setKeyEntry(string, key, (char[])object, certificateArray);
                }
                catch (Exception exception) {
                    Trace.securityPrintException(exception);
                    boolean bl2 = false;
                    Object var13_11 = null;
                    bufferedInputStream.close();
                    fileInputStream.close();
                    return bl2;
                }
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                bufferedInputStream.close();
                fileInputStream.close();
                throw throwable;
            }
            bufferedInputStream.close();
            fileInputStream.close();
        } else {
            this._deploymentUserClientCerts.setKeyEntry(string, key, (char[])object, certificateArray);
        }
        this.setPassword((char[])object);
        return true;
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removing");
        String string = null;
        char[] cArray = this.getPasswordDialog("clientauth.password.dialog.text");
        if (cArray != null) {
            try {
                File file = new File(_filenameUser);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new BufferedInputStream(new FileInputStream(file)), cArray);
                string = this._deploymentUserClientCerts.getCertificateAlias(certificate);
                if (string != null) {
                    this._deploymentUserClientCerts.deleteEntry(string);
                }
                this.setPassword(cArray);
                this.save();
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof KeyStoreException) {
                    throw (KeyStoreException)exception;
                }
                Trace.securityPrintException(exception);
                return false;
            }
        } else {
            return false;
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removed", new Object[]{string});
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.instore");
        String string = null;
        string = this._deploymentSystemClientCerts.getCertificateAlias(certificate);
        if (string != null) {
            return true;
        }
        string = this._deploymentUserClientCerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.canverify");
        return false;
    }

    public Iterator iterator(int n) throws KeyStoreException {
        return null;
    }

    public Iterator iteratorChain(int n) throws KeyStoreException {
        Object object;
        Trace.msgSecurityPrintln("clientauthcertstore.cert.iterator");
        KeyStore keyStore = this.getKeyStore(n);
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)object)) continue;
            treeSet.add(object);
        }
        object = new LinkedHashSet();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            if (certificateArray == null) continue;
            ((HashSet)object).add(certificateArray);
        }
        return ((HashSet)object).iterator();
    }

    private KeyStore getKeyStore(int n) {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.getkeystore");
        return n == 0 ? this._deploymentUserClientCerts : this._deploymentSystemClientCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getPasswordDialog(String string) {
        LookAndFeel lookAndFeel;
        block4: {
            char[] cArray;
            if (this.getPassword() != null) {
                return this.getPassword();
            }
            lookAndFeel = null;
            try {
                lookAndFeel = DeployUIManager.setLookAndFeel();
                String string2 = DeployClientAuthCertStore.getMessage(string);
                JPasswordField jPasswordField = new JPasswordField();
                Object[] objectArray = new Object[]{string2.toString(), jPasswordField};
                JButton jButton = new JButton(DeployClientAuthCertStore.getMessage("cert.dialog.password.okButton"));
                JButton jButton2 = new JButton(DeployClientAuthCertStore.getMessage("cert.dialog.password.cancelButton"));
                String string3 = DeployClientAuthCertStore.getMessage("cert.dialog.password.caption");
                Object[] objectArray2 = new Object[]{jButton, jButton2};
                int n = DialogFactory.showOptionDialog(myParent, 4, objectArray, string3, objectArray2, objectArray2[0]);
                char[] cArray2 = jPasswordField.getPassword();
                if (n != 0) break block4;
                cArray = cArray2;
                Object var14_14 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                DeployUIManager.restoreLookAndFeel(lookAndFeel);
                throw throwable;
            }
            DeployUIManager.restoreLookAndFeel(lookAndFeel);
            return cArray;
        }
        char[] cArray = null;
        Object var14_15 = null;
        DeployUIManager.restoreLookAndFeel(lookAndFeel);
        return cArray;
    }

    private void setPassword(char[] cArray) {
        this.savePassword = cArray;
    }

    private char[] getPassword() {
        return this.savePassword;
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    static {
        _filenameUser = Config.getUserClientAuthCertFile();
        _filenameSys = Config.getSystemClientAuthCertFile();
    }
}

