/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import jp.sourceforge.swf2bmp2avi.util.DDD;

public class BinaryFileWriter {
    protected ByteBuffer buffer_;
    private boolean isLittleEndian_;
    private File file_;
    private FileOutputStream stream_ = null;
    private FileChannel channel_ = null;
    private static final int C_BUFF_APPEND_BROCK_SIZE = 1024;

    public BinaryFileWriter() {
        this(true);
    }

    public BinaryFileWriter(boolean pIsLittelEndian) {
        this.isLittleEndian_ = pIsLittelEndian;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void dbgDipsBuff() {
        this.buffer_.clear();
        byte[] bytes = new byte[this.buffer_.capacity()];
        this.buffer_.get(bytes);
        System.out.println("==\u30d0\u30c3\u30d5\u30a1\u5185\u5bb9\u51fa\u529b===\u5b9f\u30b5\u30a4\u30ba( " + this.buffer_.limit() + " / " + this.buffer_.capacity() + " )");
        DDD.dumpHex(bytes);
    }

    public void open(File pAviFile) throws IOException {
        this.file_ = pAviFile;
        this.stream_ = new FileOutputStream(this.file_);
        this.channel_ = this.stream_.getChannel();
    }

    public void close() {
        if (this.channel_ != null && this.channel_.isOpen()) {
            try {
                this.channel_.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.channel_ = null;
        }
        if (this.stream_ != null) {
            try {
                this.stream_.flush();
                this.stream_.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.stream_ = null;
        }
    }

    public int writeBuffer() throws IOException {
        this.buffer_.flip();
        int cnt = this.channel_.write(this.buffer_);
        this.buffer_ = null;
        return cnt;
    }

    protected ByteBuffer checkBuffer(int pAddSize) {
        int oversize;
        if (this.buffer_ == null) {
            this.buffer_ = ByteBuffer.allocate(1024);
            if (this.isLittleEndian_) {
                this.buffer_.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        if ((oversize = pAddSize - (this.buffer_.capacity() - this.buffer_.position())) <= 0) {
            return this.buffer_;
        }
        int newSize = 1024 * (oversize / 1024 + 1) + this.buffer_.capacity();
        ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
        if (this.isLittleEndian_) {
            newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int pos = this.buffer_.position();
        newBuffer.put(this.buffer_.array(), 0, pos);
        this.buffer_ = newBuffer;
        this.buffer_.position(pos);
        return this.buffer_;
    }

    public final ByteBuffer order(ByteOrder bo) {
        return this.buffer_.order(bo);
    }

    public ByteBuffer put(byte b) {
        this.checkBuffer(1);
        return this.buffer_.put(b);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        this.checkBuffer(length);
        return this.buffer_.put(src, offset, length);
    }

    public final ByteBuffer put(byte[] src) {
        this.checkBuffer(src.length);
        return this.buffer_.put(src);
    }

    public ByteBuffer put(ByteBuffer src) {
        this.checkBuffer(src.limit());
        return this.buffer_.put(src);
    }

    public ByteBuffer put(int index, byte b) {
        return this.buffer_.put(index, b);
    }

    public ByteBuffer putChar(char value) {
        this.checkBuffer(2);
        return this.buffer_.putChar(value);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.buffer_.putChar(index, value);
    }

    public ByteBuffer putDouble(double value) {
        this.checkBuffer(8);
        return this.buffer_.putDouble(value);
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.buffer_.putDouble(index, value);
    }

    public ByteBuffer putFloat(float value) {
        this.checkBuffer(4);
        return this.buffer_.putFloat(value);
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.buffer_.putFloat(index, value);
    }

    public ByteBuffer putInt(int index, int value) {
        return this.buffer_.putInt(index, value);
    }

    public ByteBuffer putInt(int value) {
        this.checkBuffer(4);
        return this.buffer_.putInt(value);
    }

    public ByteBuffer putLong(int index, long value) {
        return this.buffer_.putLong(index, value);
    }

    public ByteBuffer putLong(long value) {
        this.checkBuffer(8);
        return this.buffer_.putLong(value);
    }

    public ByteBuffer putShort(int index, short value) {
        return this.buffer_.putShort(index, value);
    }

    public ByteBuffer putShort(short value) {
        this.checkBuffer(2);
        return this.buffer_.putShort(value);
    }

    public final int position() {
        return this.buffer_.position();
    }

    public final Buffer position(int newPosition) {
        return this.buffer_.position(newPosition);
    }

    public final Buffer mark() {
        return this.buffer_.mark();
    }

    public final Buffer reset() {
        return this.buffer_.reset();
    }

    public final Buffer clear() {
        return this.buffer_.clear();
    }

    public final Buffer flip() {
        return this.buffer_.flip();
    }

    public final Buffer rewind() {
        return this.buffer_.rewind();
    }

    public final int capacity() {
        return this.buffer_.capacity();
    }

    public final int limit() {
        return this.buffer_.limit();
    }

    public final Buffer limit(int pNewLimit) {
        return this.buffer_.limit(pNewLimit);
    }

    protected ByteBuffer getBuffer() {
        return this.buffer_;
    }

    protected ByteBuffer slice() {
        return this.buffer_.slice();
    }

    protected ByteBuffer slice(int pPosition, int pSize) {
        this.clear();
        this.buffer_.position(pPosition);
        this.buffer_.limit(pPosition + pSize);
        return this.buffer_.slice();
    }

    public String getReadFileName() {
        return this.file_.getAbsolutePath();
    }
}

