/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import jp.sourceforge.swf2bmp2avi.io.BinaryFileAccess;

public class BmpBinaryAccess
extends BinaryFileAccess {
    private char[] typeCd_;
    private int size_;
    private int reserved1_;
    private int reserved2_;
    private int offsetBits_;
    private int infoHeaderSize_;
    private int width_;
    private int height_;
    private int bitCount_;
    private int biPlanes_;
    private int compression_;
    private int imageSize_;
    private int pixelsPerMeterX_;
    private int pixelsPerMeterY_;
    private int colorsUsed_;
    private int colorsImportant_;
    private byte[] sourceImage_;
    private boolean isDataRead_;

    public BmpBinaryAccess(String pFileName) throws FileNotFoundException, IOException {
        this(pFileName, true);
    }

    public BmpBinaryAccess(String pFileName, boolean pIsDataRead) throws FileNotFoundException, IOException {
        super(true);
        this.isDataRead_ = pIsDataRead;
        this.read(pFileName);
    }

    public void read(String pFileName) throws IOException {
        super.read(pFileName);
        this.clear();
        this.typeCd_ = new char[2];
        this.typeCd_[0] = (char)this.get();
        this.typeCd_[1] = (char)this.get();
        this.size_ = this.getInt();
        this.reserved1_ = this.getShort();
        this.reserved2_ = this.getShort();
        this.offsetBits_ = this.getInt();
        this.infoHeaderSize_ = this.getInt();
        if (this.infoHeaderSize_ == 12) {
            this.width_ = this.getShort();
            this.height_ = this.getShort();
            this.biPlanes_ = this.getShort();
            this.bitCount_ = this.getShort();
            if (!this.isDataRead_) {
                return;
            }
        } else {
            this.width_ = this.getInt();
            this.height_ = this.getInt();
            this.biPlanes_ = this.getShort();
            this.bitCount_ = this.getShort();
            if (!this.isDataRead_) {
                return;
            }
            this.compression_ = this.getInt();
            this.imageSize_ = this.getInt();
            this.pixelsPerMeterX_ = this.getInt();
            this.pixelsPerMeterY_ = this.getInt();
            this.colorsUsed_ = this.getInt();
            this.colorsImportant_ = this.getInt();
            if (this.infoHeaderSize_ > 40) {
                if (this.infoHeaderSize_ >= 52) {
                    this.getInt();
                    this.getInt();
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 56) {
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 60) {
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 96) {
                    int[] bV4Endpoints = new int[9];
                    int i = 0;
                    while (i < 9) {
                        bV4Endpoints[i] = this.getInt();
                        ++i;
                    }
                }
                if (this.infoHeaderSize_ >= 108) {
                    this.getInt();
                    this.getInt();
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 112) {
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 120) {
                    this.getInt();
                    this.getInt();
                }
                if (this.infoHeaderSize_ >= 124) {
                    this.getInt();
                }
            }
            if (this.infoHeaderSize_ == 40 && (this.bitCount_ == 16 || this.bitCount_ == 32) && this.bitCount_ == 3) {
                this.getInt();
                this.getInt();
                this.getInt();
            }
        }
        if (this.bitCount_ == 1 || this.bitCount_ == 4 || this.bitCount_ == 8 || this.infoHeaderSize_ != 12 && this.colorsUsed_ >= 1) {
            int i = 0;
            while (i < this.colorsUsed_) {
                if (this.infoHeaderSize_ == 12) {
                    this.get();
                    this.get();
                    this.get();
                } else {
                    this.get();
                    this.get();
                    this.get();
                    this.get();
                }
                ++i;
            }
        }
        int colormapSize = this.getColorMapSize();
        byte[] colormap = new byte[colormapSize];
        this.get(colormap);
        if (this.isDataRead_) {
            int imageBufferSize = this.getImageBufferSize();
            this.sourceImage_ = new byte[imageBufferSize];
            if (this.getBitCount() == 1) {
                this.loadBufferWithConvert1BitTo24Bit(colormap, this.sourceImage_);
            } else {
                this.get(this.sourceImage_);
            }
        }
    }

    public int getImageBufferSize() {
        return BmpBinaryAccess.getImageBufferSize(this.getWidth(), this.getHeight(), this.getBitCount());
    }

    public static int getImageBufferSize(int w, int h, int pbitCount) {
        int wk = (w * pbitCount + 31) / 32;
        int scanLinePadSize = wk * 4;
        return scanLinePadSize * h;
    }

    public int getColorMapSize() {
        int bitCount = this.getBitCount();
        int colormapSize = bitCount == 1 ? 8 : (bitCount == 8 ? 1024 : 0);
        return colormapSize;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getBitCount() {
        return this.bitCount_;
    }

    private byte[] loadBufferWithConvert1BitTo24Bit(byte[] colormap, byte[] pImageBuffer) throws IOException {
        int rgbIdx;
        int imageWidth = this.getWidth();
        int imageHeight = this.getHeight();
        byte[][] rgbQuad = new byte[2][4];
        int colormapIdx = 0;
        int rgbColorIdx = 0;
        while (rgbColorIdx < 2) {
            rgbIdx = 0;
            while (rgbIdx < 3) {
                rgbQuad[rgbColorIdx][rgbIdx] = colormap[colormapIdx++];
                ++rgbIdx;
            }
            ++rgbColorIdx;
        }
        int scanLinePadSize = 3 - (imageWidth - 1) % 32 / 8;
        int outputPadSize = imageWidth % 4;
        int imageIdx = 0;
        int heightIdx = 0;
        while (heightIdx < imageHeight) {
            int widthIdx = 0;
            block3: while (widthIdx < imageWidth) {
                if (widthIdx % 8 != 0) continue;
                byte dataByte = this.get();
                int bitIdx = 0;
                while (bitIdx < 8) {
                    rgbColorIdx = (dataByte & 128 >> bitIdx) == 0 ? 0 : 1;
                    rgbIdx = 0;
                    while (rgbIdx < 3) {
                        pImageBuffer[imageIdx++] = rgbQuad[rgbColorIdx][rgbIdx];
                        ++rgbIdx;
                    }
                    if (++widthIdx == imageWidth) continue block3;
                    ++bitIdx;
                }
            }
            int i = 0;
            while (i < scanLinePadSize) {
                this.get();
                ++i;
            }
            i = 0;
            while (i < outputPadSize) {
                pImageBuffer[imageIdx++] = 0;
                ++i;
            }
            ++heightIdx;
        }
        return pImageBuffer;
    }

    public byte[] getSourceImage() {
        return this.sourceImage_;
    }
}

