/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.io.swf;

import java.util.Set;
import java.util.TreeSet;
import jp.sourceforge.swf2bmp2avi.io.swf.ISoundPosition;
import jp.sourceforge.swf2bmp2avi.io.swf.SwfTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwfTagDefineSound
extends SwfTag
implements ISoundPosition {
    public static final int SOUND_FORMAT_uncompressed = 0;
    public static final int SOUND_FORMAT_ADPCM = 1;
    public static final int SOUND_FORMAT_MP3 = 2;
    public static final int SOUND_FORMAT_Nellymoser_8kHz_mono = 5;
    public static final int SOUND_FORMAT_Nellymoser = 6;
    public static final int SOUND_RATE_0_5p5kHz = 0;
    public static final int SOUND_RATE_1_11kHz = 1;
    public static final int SOUND_RATE_2_22kHz = 2;
    public static final int SOUND_RATE_3_44kHz = 3;
    public static final int SOUND_SIZE_8Bit = 0;
    public static final int SOUND_SIZE_16Bit = 1;
    public static final int SOUND_TYPE_Mono = 0;
    public static final int SOUND_TYPE_Stereo = 1;
    public int sound_id;
    public int sound_format;
    public int sound_rate;
    public int sound_is_16bits;
    public int sound_is_stereo;
    public int sound_samples_count;
    public int soundDataStartPos;
    private String outputFileName_;
    private Set<Integer> startFramePossions = new TreeSet<Integer>();

    public SwfTagDefineSound(SwfTag pBaseSwfTag) {
        super(pBaseSwfTag);
    }

    public int getSoundDataSiz() {
        return this.dataSize - (this.soundDataStartPos - this.dataPosition);
    }

    public int getSampleRateValue() {
        return (int)(5512.5 * (double)((2 << this.sound_rate) / 2));
    }

    public int getDataTransRate() {
        int sampleRate = this.getSampleRateValue();
        if (this.sound_is_stereo == 1) {
            sampleRate *= 2;
        }
        if (this.sound_is_16bits == 1) {
            sampleRate *= 2;
        }
        return sampleRate;
    }

    public boolean isStereo() {
        return this.sound_is_stereo == 1;
    }

    public boolean is16bits() {
        return this.sound_is_16bits == 1;
    }

    @Override
    public String getOutputFileName() {
        return this.outputFileName_;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName_ = outputFileName;
    }

    @Override
    public void addStartFrame(int pFrame) {
        this.startFramePossions.add(pFrame);
    }

    @Override
    public Set<Integer> getStartFramePossions() {
        return this.startFramePossions;
    }
}

