/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jp.sourceforge.swf2bmp2avi.plugin.SwfCaptureParams;
import jp.sourceforge.swf2bmp2avi.util.DDD;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.sourceforge.swf2bmp2avi.plugin";
    private static Activator plugin;
    private MessageConsoleStream stream_;
    private SwfCaptureParams swCapturefParam_;
    private boolean isDebugMode_;
    private File tmpDir_;

    public void logMsg(String pMessage) {
        if (this.isDebugMode_ && this.stream_ != null) {
            this.stream_.println(pMessage);
        }
    }

    public static void msg(String pMessage) {
        String msg = String.valueOf(DDD.getFreeMem()) + pMessage;
        Activator self = Activator.getDefault();
        if (self != null) {
            Activator.getDefault().logMsg(msg);
        }
        System.out.println(msg);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.init();
    }

    private void init() {
        this.isDebugMode_ = this.getPreferenceStore().getBoolean("swf2avi.is_debug_mode");
        this.tmpDir_ = new File(this.getPreferenceStore().getString("swf2avi.work_path"));
        if (!this.tmpDir_.exists() || !this.tmpDir_.isDirectory()) {
            this.tmpDir_.mkdir();
        }
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pEvent) {
                if (pEvent.getProperty().equals("swf2avi.is_debug_mode")) {
                    Activator.this.isDebugMode_ = Activator.this.getPreferenceStore().getBoolean("swf2avi.is_debug_mode");
                }
            }
        });
        MessageConsole console = new MessageConsole("\u30c7\u30d0\u30c3\u30b0\u7528\u30b3\u30f3\u30bd\u30fc\u30eb", null);
        this.stream_ = console.newMessageStream();
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{console});
        this.swCapturefParam_ = new SwfCaptureParams(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.swCapturefParam_.save(this.getPreferenceStore());
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public SwfCaptureParams getSwCapturefParam() {
        return this.swCapturefParam_;
    }

    public File getTmpDir() throws IOException {
        return this.tmpDir_;
    }

    public static Image getImage(String pName) {
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        Image img = imgReg.get(pName);
        if (img != null) {
            return img;
        }
        ImageDescriptor desc = Activator.getImageDescriptor(pName);
        if (desc == null) {
            return null;
        }
        imgReg.put(pName, desc);
        img = imgReg.get(pName);
        return img;
    }

    public String toAbsolutePath(String pRelativePath) {
        Path path = new Path(pRelativePath);
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
        try {
            return FileLocator.resolve((URL)url).getFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getStateLocationFileAsCopyFromJar(String pFileName) {
        File f;
        block30: {
            f = this.getStateLocation().append(pFileName).toFile();
            if (!f.exists()) {
                InputStream in;
                block31: {
                    byte[] buff = new byte[1024];
                    FileOutputStream fo = null;
                    in = null;
                    try {
                        int len;
                        f.getParentFile().mkdirs();
                        fo = new FileOutputStream(f);
                        URL u = this.getBundle().getResource(pFileName);
                        in = u.openStream();
                        BufferedInputStream bin = new BufferedInputStream(in);
                        while ((len = bin.read(buff)) != -1) {
                            fo.write(buff, 0, len);
                        }
                        fo.flush();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                        if (fo != null) {
                            try {
                                fo.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        break block30;
                    }
                    catch (IOException ex) {
                        try {
                            ex.printStackTrace();
                            break block30;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (fo != null) {
                                try {
                                    fo.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (fo == null) break block31;
                    try {
                        fo.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return f.getAbsolutePath();
    }
}

