/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sourceforge.swf2bmp2avi.process.ProcessRunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRunner {
    private List<ProcessRunListener> listeners = new ArrayList<ProcessRunListener>();
    private String directory_;

    public void addProcessRunEventListener(ProcessRunListener pListener) {
        this.listeners.add(pListener);
    }

    public void removeProcessRunEventListener(ProcessRunListener pListener) {
        this.listeners.remove(pListener);
    }

    protected void fireSysoutEvent(String pMessage) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (ProcessRunListener listener : this.listeners) {
            listener.onSysoutMessage(pMessage);
        }
    }

    protected void fireErroutEvent(String pMessage) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (ProcessRunListener listener : this.listeners) {
            listener.onErroutMessage(pMessage);
        }
    }

    protected void dumpParams(List<String> pParams) {
        Iterator<String> ite = pParams.iterator();
        String cmdStr = "";
        while (ite.hasNext()) {
            cmdStr = String.valueOf(cmdStr) + ite.next() + " ";
        }
        System.out.println(cmdStr);
    }

    protected int execProcess(List<String> params) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(params);
        if (this.directory_ != null) {
            Map<String, String> env = builder.environment();
            System.out.println("\u74b0\u5883\u5909\u6570");
            System.out.println(env.get("Path"));
            env.put("Path", this.directory_);
            System.out.println(env.get("Path"));
            builder.directory(new File(this.directory_));
            System.out.println("\u8a2d\u5b9a\u6e08\u307f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff1a" + builder.directory());
        }
        Process process = builder.start();
        this.threadExecSysout(process.getInputStream());
        this.threadExecSyserr(process.getErrorStream());
        return process.waitFor();
    }

    public static int execSimple(String ... pCommands) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(pCommands);
        Process process = builder.start();
        return process.exitValue();
    }

    public static int openExplorer(String pPath) {
        try {
            return ProcessRunner.execSimple("explorer", pPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void threadExecSysout(InputStream is) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(is));
        new Thread(){

            public void run() {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        ProcessRunner.this.fireSysoutEvent(line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void threadExecSyserr(InputStream is) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(is));
        new Thread(){

            public void run() {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        ProcessRunner.this.fireErroutEvent(line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public String getDirectory() {
        return this.directory_;
    }

    public void setDirectory(String pDirectory) {
        this.directory_ = pDirectory;
    }
}

