/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.MovieCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AviPartCtrl {
    public static final String EVENT_ON_CLICK_BOTTON_EXEC = "on_click_create_avi_exec";
    public static final String EVENT_ON_CHANGE_AVI_FILE_PATH = "on_change_avi_file_path";
    private boolean isSynchro_ = false;
    private Composite parent_;
    private Label lblAreaDisp_;
    private Button chkIsAttachSound_;
    private Text txtAttachSoundFile_;
    private Button btnSoundFile_;
    private Text textAviFilePath_;
    private Button btnSelectAviFile_;
    private Combo cmbMovieCompressSelect_;
    private Text textAviFps_;
    private Text textBitRate_;
    private Button btnAviPreview_;
    private Button btnAviDelete_;
    private Button btnExec_;
    private PropertyChangeSupport listeners_ = new PropertyChangeSupport(this);

    public AviPartCtrl(Composite pParent) {
        this.parent_ = pParent;
        this.createAviPartControl(pParent);
    }

    private void showMessage(String pMsg) {
        MessageDialog.openInformation((Shell)this.parent_.getShell(), (String)"Bmp\u2192Avi", (String)pMsg);
    }

    private boolean showConfirm(String pMsg) {
        return MessageDialog.openConfirm((Shell)this.parent_.getShell(), (String)"Bmp\u2192Avi", (String)pMsg);
    }

    public void createAviPartControl(Composite parent) {
        this.lblAreaDisp_ = new Label(parent, 0x1000000);
        this.lblAreaDisp_.setText("");
        this.lblAreaDisp_.setBackground(parent.getShell().getDisplay().getSystemColor(12));
        Label l = null;
        l = new Label(parent, 0);
        l.setText("\u6620\u50cf\u5727\u7e2e");
        this.cmbMovieCompressSelect_ = new Combo(parent, 8);
        this.cmbMovieCompressSelect_.setItems(MovieCreator.SELECT_MOVIE_COMPRESS);
        this.cmbMovieCompressSelect_.select(Activator.getDefault().getPreferenceStore().getInt("swf2avi.avi.movier_compless_select"));
        l = new Label(parent, 0);
        l.setText("FPS");
        this.textAviFps_ = new Text(parent, 133120);
        this.textAviFps_.setToolTipText("AVI\u306e\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\u901a\u5e38\u306f\u5143\u306eSWF\u306eFPS\u3068\u540c\u3058\u5024\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("BitRate");
        this.textBitRate_ = new Text(parent, 133120);
        this.textBitRate_.setToolTipText("AVI\u306e\u30d3\u30c3\u30c8\u30ec\u30fc\u30c8\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("");
        l = new Label(parent, 0);
        l.setText("\u97f3\u58f0");
        this.chkIsAttachSound_ = new Button(parent, 32);
        this.chkIsAttachSound_.setText("\u97f3\u58f0\u4ed8\u52a0\u3042\u308a");
        this.chkIsAttachSound_.setToolTipText("AVI\u30d5\u30a1\u30a4\u30eb\u306b\u97f3\u58f0\u30c7\u30fc\u30bf\u3092\u4ed8\u52a0\u3059\u3059\u3070\u3042\u3044\u30c1\u30a7\u30c3\u30af\u3057\u307e\u3059");
        this.txtAttachSoundFile_ = new Text(parent, 2048);
        this.txtAttachSoundFile_.setText("");
        this.btnSoundFile_ = new Button(parent, 0x1000000);
        this.btnSoundFile_.setText("\u97f3\u58f0\u9078\u629e");
        this.btnSoundFile_.setToolTipText("\u4ed8\u52a0\u3059\u308b\u97f3\u58f0\u30c7\u30fc\u30bf\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("\u51fa\u529bAVI");
        this.textAviFilePath_ = new Text(parent, 2048);
        this.btnSelectAviFile_ = new Button(parent, 0x1000000);
        this.btnSelectAviFile_.setText("\u9078 \u629e");
        this.btnSelectAviFile_.setToolTipText("AVI\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u5148\u3092\u9078\u629e\u3057\u307e\u3059\u3002");
        this.btnExec_ = new Button(parent, 0x1000000);
        this.btnExec_.setText("\u5b9f \u884c");
        this.btnExec_.setImage(Activator.getImage("icons/bmp2avi_32.png"));
        this.btnExec_.setToolTipText("BMP\u304b\u3089AVI\u3092\u751f\u6210\u3059\u308b\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        l = new Label(parent, 0);
        l.setText("\u64cd\u4f5c");
        this.btnAviPreview_ = new Button(parent, 0x1000000);
        this.btnAviPreview_.setText("AVI\u30d7\u30ec\u30d3\u30e5\u30fc");
        this.btnAviPreview_.setToolTipText("\u6a19\u6e96\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u3092\u4f7f\u7528\u3057\u3066AVI\u30d5\u30a1\u30a4\u30eb\u306e\u518d\u751f\u3092\u884c\u3044\u307e\u3059\u3002");
        this.btnAviDelete_ = new Button(parent, 0x1000000);
        this.btnAviDelete_.setText("AVI\u524a\u9664");
        this.btnAviDelete_.setToolTipText("AVI\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u3092\u884c\u3044\u307e\u3059\u3002");
        this.initAviLayout(parent);
        this.initListener();
        this.checkAviFileexist();
        this.checkChangeCompressSelect();
    }

    public void initAviLayout(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 10;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = null;
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 4;
        gridData.grabExcessVerticalSpace = true;
        this.lblAreaDisp_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbMovieCompressSelect_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 50;
        gridData.horizontalSpan = 1;
        this.textAviFps_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalSpan = 1;
        this.textBitRate_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.chkIsAttachSound_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        this.txtAttachSoundFile_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.btnSoundFile_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textAviFilePath_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        gridData.horizontalAlignment = 4;
        this.btnSelectAviFile_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.btnExec_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalSpan = 1;
        this.btnAviPreview_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalSpan = 1;
        this.btnAviDelete_.setLayoutData((Object)gridData);
    }

    private void initListener() {
        this.cmbMovieCompressSelect_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                AviPartCtrl.this.checkChangeCompressSelect();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.btnSoundFile_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pArg0) {
                AviPartCtrl.this.openSoundFile();
            }
        });
        this.btnSelectAviFile_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent pArg0) {
            }

            public void widgetSelected(SelectionEvent pArg0) {
                AviPartCtrl.this.openAviFile();
            }
        });
        this.btnAviPreview_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                AviPartCtrl.this.previewAvi();
                AviPartCtrl.this.checkAviFileexist();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.btnAviDelete_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                AviPartCtrl.this.deleteAvi();
                AviPartCtrl.this.checkAviFileexist();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.btnExec_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                AviPartCtrl.this.firePropertyChange(AviPartCtrl.EVENT_ON_CLICK_BOTTON_EXEC, null, null);
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
    }

    private void checkChangeCompressSelect() {
        if (this.cmbMovieCompressSelect_.getSelectionIndex() == 0) {
            this.chkIsAttachSound_.setSelection(false);
            this.chkIsAttachSound_.setEnabled(false);
            this.txtAttachSoundFile_.setEnabled(false);
            this.btnSoundFile_.setEnabled(false);
        } else {
            this.chkIsAttachSound_.setEnabled(true);
            this.txtAttachSoundFile_.setEnabled(true);
            this.btnSoundFile_.setEnabled(true);
        }
    }

    private void openAviFile() {
        String path = this.textAviFilePath_.getText();
        FileDialog dialog = new FileDialog(this.parent_.getShell(), 8192);
        if (path != null) {
            dialog.setFileName(path);
        }
        String[] filterExt = new String[]{"*.avi", "*.*"};
        String[] filterNames = new String[]{"AVI\u30d5\u30a1\u30a4\u30eb(*.avi)", "\u5168\u3066(*.*)"};
        dialog.setFilterExtensions(filterExt);
        dialog.setFilterNames(filterNames);
        path = dialog.open();
        if (path != null) {
            this.textAviFilePath_.setText(path);
            this.firePropertyChange(EVENT_ON_CHANGE_AVI_FILE_PATH, null, path);
        }
    }

    private void openSoundFile() {
        String path = this.txtAttachSoundFile_.getText();
        FileDialog dialog = new FileDialog(this.parent_.getShell(), 4096);
        if (path != null) {
            dialog.setFileName(path);
        }
        String[] filterExt = new String[]{"*.timeinfo.txt;*.mp3;*.wav", "*.timeinfo.txt", "*.mp3", "*.wav", "*.*"};
        String[] filterNames = new String[]{"\u97f3\u58f0\u5b9a\u7fa9(*.timeinfo.txt),MP3\u30d5\u30a1\u30a4\u30eb(*.mp3),WAV\u30d5\u30a1\u30a4\u30eb(*.wav)", "\u97f3\u58f0\u5b9a\u7fa9(*.timeinfo.txt)", "MP3\u30d5\u30a1\u30a4\u30eb(*.mp3)", "WAV\u30d5\u30a1\u30a4\u30eb(*.wav)", "\u5168\u3066(*.*)"};
        dialog.setFilterExtensions(filterExt);
        dialog.setFilterNames(filterNames);
        path = dialog.open();
        if (path != null) {
            this.txtAttachSoundFile_.setText(path);
            this.chkIsAttachSound_.setSelection(true);
        }
    }

    public void previewAvi() {
        String aviPath = this.textAviFilePath_.getText();
        if (aviPath == null || aviPath.length() <= 0) {
            this.showMessage("AVI\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
            return;
        }
        File f = new File(aviPath);
        if (!f.exists()) {
            this.showMessage("\u6307\u5b9aAVI\u30d5\u30a1\u30a4\u30eb\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        Program program = Program.findProgram((String)"avi");
        program.execute(aviPath);
    }

    private void deleteAvi() {
        String aviPath = this.textAviFilePath_.getText();
        if (aviPath == null || aviPath.length() <= 0) {
            this.showMessage("\u524a\u9664\u5bfe\u8c61AVI\u30d5\u30a1\u30a4\u30eb\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
            return;
        }
        File f = new File(aviPath);
        if (!f.exists() || !f.isFile()) {
            this.showMessage("\u524a\u9664\u5bfe\u8c61AVI\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return;
        }
        if (!this.showConfirm("\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b\uff1f")) {
            return;
        }
        if (!f.delete()) {
            this.showMessage("AVI\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        this.showMessage("AVI\u30d5\u30a1\u30a4\u30eb\u306f\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002");
    }

    public void checkAviFileexist() {
        File aviFile;
        this.btnAviPreview_.setEnabled(false);
        this.btnAviDelete_.setEnabled(false);
        String aviFilePath = this.textAviFilePath_.getText();
        if (aviFilePath != null && aviFilePath.length() > 0 && (aviFile = new File(aviFilePath)).exists()) {
            this.btnAviPreview_.setEnabled(true);
            this.btnAviDelete_.setEnabled(true);
        }
    }

    public void setSynchro(boolean pIsSynchro) {
        this.isSynchro_ = pIsSynchro;
    }

    public String getFps() {
        return this.textAviFps_.getText();
    }

    public void setFps(int pFps) {
        String fpsStr = "";
        if (pFps > 0) {
            fpsStr = "" + pFps;
        }
        this.setFps(fpsStr);
    }

    public void setFps(String pFps) {
        this.textAviFps_.setText(pFps);
    }

    public void setSwfFilePath(String pSwfFilePath) {
        String path = pSwfFilePath;
        if (path != null) {
            if (path.toLowerCase().endsWith(".swf")) {
                path = path.substring(0, path.length() - 4);
            }
            if (path.length() > 0) {
                path = String.valueOf(path) + ".avi";
            }
            this.setAviFilePath(path);
        } else {
            this.setAviFilePath("");
        }
    }

    public void setAviFilePath(String pAviFilePath) {
        this.textAviFilePath_.setText(pAviFilePath);
    }

    public String getAviFilePath() {
        return this.textAviFilePath_.getText();
    }

    public int getMovieCompressIndex() {
        return this.cmbMovieCompressSelect_.getSelectionIndex();
    }

    public boolean isAttachSound() {
        return this.chkIsAttachSound_.getSelection();
    }

    public String getAttachSoundFile() {
        return this.txtAttachSoundFile_.getText();
    }

    public void setAttachSoundFile(String pFilePath) {
        this.txtAttachSoundFile_.setText(pFilePath);
    }

    public String getBitRate() {
        return this.textBitRate_.getText();
    }

    public void addPropertyChangeListener(PropertyChangeListener pListener) {
        this.listeners_.addPropertyChangeListener(pListener);
    }

    public void firePropertyChange(String pPropertyName, Object pOldValue, Object pNewValue) {
        this.listeners_.firePropertyChange(pPropertyName, pOldValue, pNewValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener pListener) {
        this.listeners_.removePropertyChangeListener(pListener);
    }
}

