/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.swf2bmp2avi.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import jp.sourceforge.swf2bmp2avi.plugin.Activator;
import jp.sourceforge.swf2bmp2avi.plugin.BmpInfo;
import jp.sourceforge.swf2bmp2avi.plugin.MovieCreator;
import jp.sourceforge.swf2bmp2avi.plugin.SwfCaptureParams;
import jp.sourceforge.swf2bmp2avi.views.AviPartCtrl;
import jp.sourceforge.swf2bmp2avi.views.BmpPartCtrl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class Bmp2AviView
extends ViewPart
implements PropertyChangeListener {
    public static final String ID = "jp.sourceforge.swf2bmp2avi.bmp2aviview";
    private Button chkAutobtnSynchro_;
    private Composite bmpPartComposit_;
    private BmpPartCtrl bmpPartCtrl_;
    private Composite aviPartComposit_;
    private AviPartCtrl aviPartCtrl_;
    private SwfCaptureParams swfCapturefParam_;

    protected void log(String pMsg) {
        Activator.msg("[" + this.getClass().getSimpleName() + "]" + pMsg);
    }

    public void init(IViewSite pSite) throws PartInitException {
        super.init(pSite);
        this.swfCapturefParam_ = Activator.getDefault().getSwCapturefParam();
        this.swfCapturefParam_.addPropertyChangeListener(this);
    }

    public void dispose() {
        this.swfCapturefParam_.removePropertyChangeListener(this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.chkAutobtnSynchro_ = new Button(parent, 32);
        this.chkAutobtnSynchro_.setText("[SWF\u2192BMP]\u306e\u5185\u5bb9\u3068\u540c\u671f");
        boolean isSynchro = Activator.getDefault().getPreferenceStore().getBoolean("swf2avi.bmpavi.auto_synchro");
        this.chkAutobtnSynchro_.setSelection(isSynchro);
        this.chkAutobtnSynchro_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent pE) {
                Activator.getDefault().getPreferenceStore().setValue("swf2avi.bmpavi.auto_synchro", Bmp2AviView.this.chkAutobtnSynchro_.getSelection());
                Bmp2AviView.this.synchroToSwfParam();
            }

            public void widgetDefaultSelected(SelectionEvent pE) {
            }
        });
        this.bmpPartComposit_ = new Composite(parent, 2048);
        this.bmpPartCtrl_ = new BmpPartCtrl(this.bmpPartComposit_);
        this.bmpPartCtrl_.setBmpDirPath(Activator.getDefault().getPreferenceStore().getString("swf2avi.bmpInputDirPath"));
        this.bmpPartCtrl_.setSynchro(isSynchro);
        this.aviPartComposit_ = new Composite(parent, 2048);
        this.aviPartCtrl_ = new AviPartCtrl(this.aviPartComposit_);
        this.aviPartCtrl_.setAviFilePath(Activator.getDefault().getPreferenceStore().getString("swf2avi.avi.output_filepath"));
        this.aviPartCtrl_.setFps(Activator.getDefault().getPreferenceStore().getString("swf2avi.avi.output_fps"));
        this.aviPartCtrl_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pEvt) {
                if (pEvt.getPropertyName().equals("on_click_create_avi_exec")) {
                    try {
                        Bmp2AviView.this.saveBmpToAvi();
                    }
                    catch (Exception ex) {
                        Bmp2AviView.this.showMessage(ex.getMessage());
                    }
                } else if (pEvt.getPropertyName().equals("on_change_avi_file_path")) {
                    Activator.getDefault().getPreferenceStore().setValue("swf2avi.avi.output_filepath", Bmp2AviView.this.aviPartCtrl_.getAviFilePath());
                }
            }
        });
        this.aviPartCtrl_.setSynchro(isSynchro);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 6;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.bmpPartComposit_.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.aviPartComposit_.setLayoutData((Object)gridData);
        this.synchroToSwfParam();
    }

    private void synchroToSwfParam() {
        boolean isSynchro = this.chkAutobtnSynchro_.getSelection();
        if (isSynchro) {
            this.bmpPartCtrl_.setBmpDirPath(this.swfCapturefParam_.getCaptureOutputPath());
            int fps = this.swfCapturefParam_.getBaseFps();
            this.aviPartCtrl_.setFps(fps);
            String aviPath = this.swfCapturefParam_.getSwfFileName();
            if (aviPath == null) {
                aviPath = "";
            }
            this.aviPartCtrl_.setSwfFilePath(aviPath);
            String soundfile = this.swfCapturefParam_.getOutputSoundConfFile();
            if (soundfile == null) {
                soundfile = "";
            }
            this.aviPartCtrl_.setAttachSoundFile(soundfile);
        }
        this.aviPartCtrl_.setSynchro(isSynchro);
        this.bmpPartCtrl_.setSynchro(isSynchro);
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent pEvt) {
        if (pEvt.getPropertyName().equals("fws_chnaged") || pEvt.getPropertyName().equals("change_some_propety") || pEvt.getPropertyName().equals("created_sound_conf") || pEvt.getPropertyName().equals("created_capture_image")) {
            this.synchroToSwfParam();
            this.aviPartCtrl_.checkAviFileexist();
        }
    }

    public void saveBmpToAvi() {
        String fpsStr;
        int movieCompressIndex = this.aviPartCtrl_.getMovieCompressIndex();
        String bmpDir = this.bmpPartCtrl_.getBmpDirPath();
        if (bmpDir == null || bmpDir.length() == 0) {
            this.showMessage("BMP\u30d5\u30a9\u30eb\u30c0\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        ArrayList<BmpInfo> bmpList = this.bmpPartCtrl_.getBmpList();
        if (bmpList == null || bmpList.isEmpty()) {
            this.showMessage("\u5bfe\u8c61\u3068\u306a\u308bBMP\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        String aviFilePath = this.aviPartCtrl_.getAviFilePath();
        if (aviFilePath == null || aviFilePath.length() == 0) {
            this.showMessage("\u51fa\u529b\u5148AVI\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        File aviFile = new File(aviFilePath);
        if (aviFile.exists()) {
            if (!aviFile.canWrite()) {
                this.showMessage("\u6307\u5b9a\u3055\u308c\u305fAVI\u30d5\u30a1\u30a4\u30eb\u306f\u66f8\u304d\u8fbc\u307f\u4e0d\u80fd\u3067\u3059\u3002");
                return;
            }
            if (!this.showConfirm("\u6307\u5b9a\u3055\u308c\u305fAVI\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f")) {
                return;
            }
            if (!aviFile.delete()) {
                this.showMessage("\u6307\u5b9a\u3055\u308c\u305fAVI\u30d5\u30a1\u30a4\u30eb\u306f\u66f8\u304d\u8fbc\u307f\u4e0d\u80fd\u3067\u3059\u3002");
                return;
            }
        }
        if ((fpsStr = this.aviPartCtrl_.getFps()) == null || fpsStr.length() <= 0) {
            this.showMessage("AVI\u306e\u51fa\u529bFPS\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        int fps = 0;
        try {
            fps = Integer.parseInt(fpsStr);
        }
        catch (NumberFormatException numberFormatException) {
            this.showMessage("AVI\u306e\u51fa\u529bFPS\u306e\u6307\u5b9a\u5024\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        if (fps <= 0) {
            this.showMessage("AVI\u306e\u51fa\u529bFPS\u306b\u306f\uff11\u4ee5\u4e0a\u306e\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            return;
        }
        boolean isAttachSound = this.aviPartCtrl_.isAttachSound();
        File soundDataFile = null;
        if (isAttachSound) {
            String soundDataPath = this.aviPartCtrl_.getAttachSoundFile();
            soundDataFile = new File(soundDataPath);
            if (soundDataFile == null || soundDataFile.length() == 0L) {
                this.showMessage("\u97f3\u58f0\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            if (!soundDataFile.exists() || !soundDataFile.isFile()) {
                this.showMessage("\u6307\u5b9a\u3055\u308c\u305f\u97f3\u58f0\u30d5\u30a1\u30a4\u30eb\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                return;
            }
        }
        MovieCreator movieCreator = new MovieCreator(this.getSite().getShell());
        movieCreator.setMovieCompressIndex(movieCompressIndex);
        movieCreator.setBmpDir(bmpDir);
        movieCreator.setBmpList(bmpList);
        movieCreator.setFps(fps);
        movieCreator.setIsAttachSound(isAttachSound);
        movieCreator.setAttachSoundFile(soundDataFile);
        movieCreator.setAviFile(aviFile);
        movieCreator.setBitRate(this.aviPartCtrl_.getBitRate());
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, true, (IRunnableWithProgress)movieCreator);
            boolean isAutoPrevie = Activator.getDefault().getPreferenceStore().getBoolean("swf2avi.avi_auto_preview");
            if (isAutoPrevie && aviFile.exists()) {
                this.aviPartCtrl_.previewAvi();
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.showMessage("\u51e6\u7406\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f \n" + e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.showMessage("\u51e6\u7406\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\n" + e.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage(e.toString());
            return;
        }
        this.aviPartCtrl_.checkAviFileexist();
    }

    private void showMessage(String pMsg) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Bmp\u2192Avi", (String)pMsg);
    }

    private boolean showConfirm(String pMsg) {
        return MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Bmp\u2192Avi", (String)pMsg);
    }
}

