<?php

if ($argc < 4) {
    fprintf(STDERR, "Usage: swfreplacebitmapdata <swf_file> <image_id> <bitmap_file>\n");
    exit(1);
}

if ($argc > 3) {
    $swf_filename = $argv[1];
    $image_id = $argv[2];
    $bitmap_filename = $argv[3];
}

$swfdata = file_get_contents($swf_filename);
$bitmapdata = file_get_contents($bitmap_filename);


$obj = new SWFEditor();

 $obj->setShapeAdjustMode(SWFEditor::SHAPE_BITMAP_RECT_RESIZE);
// $obj->setShapeAdjustMode(SWFEditor::SHAPE_BITMAP_MATRIX_RESCALE);
// $obj->setShapeAdjustMode(SWFEditor::SHAPE_BITMAP_TYPE_TILLED);

if ($obj->input($swfdata) == false) {
    fprintf(STDERR, "input failed\n");
    exit(1);
}


$result = $obj->replaceBitmapData($image_id, $bitmapdata, null, true);


if ($result == false) {
    fprintf(STDERR, "replaceBitmapData($image_id, ...) failed\n");
    exit(1);
}

echo $obj->output();
