<?php
$ctrlpoints = array(
   -1.5, -1.5, 4.0,-0.5, -1.5, 2.0,
     0.5, -1.5, -1.0,
     1.5, -1.5, 2.0,-1.5, -0.5, 1.0,
     -0.5, -0.5, 3.0,
     0.5, -0.5, 0.0,
     1.5, -0.5, -1.0,
   -1.5, 0.5, 4.0,
     -0.5, 0.5, 0.0,
     0.5, 0.5, 3.0,
     1.5, 0.5, 4.0,
   -1.5, 1.5, -2.0,
     -0.5, 1.5, -2.0,
     0.5, 1.5, 0.0,
     1.5, 1.5, -1.0);

function initlights()
{
   $ambient = array(0.2, 0.2, 0.2, 1.0);
   $position = array(0.0, 0.0, 2.0, 1.0);
   $mat_diffuse = array(0.6, 0.6, 0.6, 1.0);
   $mat_specular = array(1.0, 1.0, 1.0, 1.0);
   $mat_shininess = array(50.0);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);

   glLightfv(GL_LIGHT0, GL_AMBIENT, $ambient);
   glLightfv(GL_LIGHT0, GL_POSITION, $position);

   glMaterialfv(GL_FRONT, GL_DIFFUSE, $mat_diffuse);
   glMaterialfv(GL_FRONT, GL_SPECULAR, $mat_specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, $mat_shininess);
}

function display()
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glPushMatrix();
   glRotatef(85.0, 1.0, 1.0, 1.0);
   glEvalMesh2(GL_FILL, 0, 20, 0, 20);
   glPopMatrix();
   glFlush();
}

function init()
{
   global $ctrlpoints;
   glClearColor(0.0, 0.0, 0.0, 0.0);
   glEnable(GL_DEPTH_TEST);
   glMap2f(GL_MAP2_VERTEX_3, 0, 1, 3, 4,
           0, 1, 12, 4, $ctrlpoints);
   glEnable(GL_MAP2_VERTEX_3);
   glEnable(GL_AUTO_NORMAL);
   glMapGrid2f(20, 0.0, 1.0, 20, 0.0, 1.0);
   initlights();       /* for lighted version only */
}

function reshape($w, $h)
{
   glViewport(0, 0, $w, $h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if ($w <= $h)
      glOrtho(-4.0, 4.0, -4.0*$h/$w,
              4.0*$h/$w, -4.0, 4.0);
   else
      glOrtho(-4.0*$w/$h,
              4.0*$w/$h, -4.0, 4.0, -4.0, 4.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}

function keyboard($key, $x, $y)
{
   switch (ord($key)) {
      case 27:
         exit(0);
         break;
   }
}

glutInit($argv);
glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
glutInitWindowSize (500, 500);
glutInitWindowPosition (100, 100);
glutCreateWindow($argv[0]);
init();
glutReshapeFunc('reshape');
glutDisplayFunc('display');
glutKeyboardFunc('keyboard');
glutMainLoop();
