package jp.ac.do_johodai.j314.xhtml2scorm;

import java.io.*;
import java.net.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.*;

import org.w3c.dom.*;
import org.w3c.dom.bootstrap.*;
import org.w3c.dom.ls.*;

class InputXHTML {
    File file = null;
    MetaData parentMD;
    MetaData myMD;
    Document doc;
    String errMessage = null;
    AnsData ansData = null;

    // 定数
    static final String xhtmlNS = "http://www.w3.org/1999/xhtml";

    InputXHTML(File f) {
        ansData = new AnsData();
        file = f;
        if (!loadFile(f))
            return;
        if (!makeMyMetaData())
            return;
    }

    DOMImplementationLS getDomImpl() {
        try {
            DOMImplementationRegistry dir = DOMImplementationRegistry
                    .newInstance();
            DOMImplementationLS di = (DOMImplementationLS) dir
                    .getDOMImplementation("LS 3.0");
            return di;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
    boolean loadFile(File f) {
        try {
            DOMImplementationLS di = getDomImpl();
            FileInputStream fin = new FileInputStream(f);
            LSInput input = di.createLSInput();
            input.setByteStream(fin);
            LSParser parser = di.createLSParser(DOMImplementationLS.MODE_SYNCHRONOUS, null);
            DOMConfiguration c = parser.getDomConfig();
            //c.setParameter("validate", true);
            c.setParameter("resource-resolver",new MyLSResourceResolver());
            doc = parser.parse(input);
            fin.close();
            return true;
        } catch(Exception e) {
            errMessage = "XHTMLの読み込みに失敗しました。";
            e.printStackTrace();
            return false;
        }
    }*/

    boolean loadFile(File f) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            // dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new MyEntityResolver());
            doc = db.parse(f);
            return true;
        } catch (Exception e) {
            errMessage = "XHTMLの読み込みに失敗しました。";
            e.printStackTrace();
            return false;
        }
    }

    boolean makeMyMetaData() {
        try {
            // RDFデータからメタデータ抽出
            String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            NodeList nl = doc.getElementsByTagNameNS(rdfNS, "RDF");
            Node n = nl.item(0);
            DOMImplementationLS di = getDomImpl();
            LSOutput out = di.createLSOutput();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            out.setByteStream(baos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(n, out);
            String s = new String(baos.toByteArray(), "UTF-8");
            s = s.trim();
            baos.close();
            String base = file.toURI().toURL().toExternalForm();
            if (s.equals("")) {
                myMD = new MetaData(base);
            } else {
                myMD = new MetaData(s, base);
            }
        } catch (Exception e) {
            String base = file.toString();
            myMD = new MetaData(base);
        }

        // id属性のmetadataからデータ抽出
        // myMd.setkeyword
        String ul = "/:html/:body/:ul[@id='metadata']/:li/text()";
        Node ul0[] = xpath(ul, doc);

        String[] metaTagName = new String[ul0.length];
        String[] tmpString = null;

        for (int metaCount = 0; metaCount < ul0.length; metaCount++) {
            tmpString = ul0[metaCount].getTextContent().split(": ");
            // metaTagName[metaCount] = tmpString[0].replaceAll("\n", "");
            // metaTagName[metaCount] = metaTagName[metaCount].replaceAll(" ",
            // "");
            metaTagName[metaCount] = tmpString[0].trim();
            // System.out.println(metaTagName[metaCount]);
            if (metaTagName[metaCount].equals("title")) {
                // System.out.println(metaTagName[metaCount]);
                myMD.setTitle(tmpString[1]);
            } else if (metaTagName[metaCount].equals("keywords")) {
                // System.out.println(metaTagName[metaCount]);
                myMD.setKeywords(tmpString[1]);
            } else if (metaTagName[metaCount].equals("description")) {
                // System.out.println(metaTagName[metaCount]);
                myMD.setDescription(tmpString[1]);
            } else if (metaTagName[metaCount].equals("difficuly")) {
                // System.out.println(metaTagName[metaCount]);
                myMD.setDifficulty(tmpString[1]);
            } else if (metaTagName[metaCount].equals("learningtime")) {
                // System.out.println(metaTagName[metaCount]);
                myMD.setLearningtime(tmpString[1]);
            } else if (metaTagName[metaCount].equals("kind")){
                // System.out.println(metaTagName[metaCount]);
                myMD.setKind(tmpString[1]);                
            } else if (metaTagName[metaCount].equals("catalog")){
                // System.out.println(metaTagName[metaCount]);
                myMD.setCatalog(tmpString[1]);
            } else if (metaTagName[metaCount].equals("entry")){
                // System.out.println(metaTagName[metaCount]);
                myMD.setEntry(tmpString[1]);
            } else if (metaTagName[metaCount].equals("requires")){
                // System.out.println(metaTagName[metaCount]);
                myMD.setEntry(tmpString[1]);
            } else if (metaTagName[metaCount].equals("creator")) {
                //System.out.println(metaTagName[metaCount]);
                myMD.setCreator(tmpString[1]);
            } else if (metaTagName[metaCount].equals("created")) {
                //System.out.println(metaTagName[metaCount]);
                myMD.setCreated(tmpString[1]);
            }

        }

        try {
            String mdFName = file.getName();
            mdFName = mdFName.substring(0,mdFName.lastIndexOf('.'))+".md";
            File f = new File(file.getParentFile(),mdFName);
            if (f.exists()) {
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader(fis,"UTF-8");
                BufferedReader fr = new BufferedReader(isr);
                String line;
                int metaCount = 0;
                while ((line=fr.readLine())!=null) {
                    System.out.println(line);
                    tmpString = line.split(": ");
                    // metaTagName[metaCount] = tmpString[0].replaceAll("\n", "");
                    // metaTagName[metaCount] = metaTagName[metaCount].replaceAll(" ",
                    // "");
                    //metaTagName[metaCount] = tmpString[0].trim();
                    // System.out.println(metaTagName[metaCount]);
                    
                    if (tmpString[0].trim().equals("title")) {
                        // System.out.println(tmpString[0].trim(););
                        myMD.setTitle(tmpString[1]);
                    } else if (tmpString[0].trim().equals("keywords")) {
                        // System.out.println(tmpString[0].trim(););
                        myMD.setKeywords(tmpString[1]);
                    } else if (tmpString[0].trim().equals("description")) {
                        // System.out.println(tmpString[0].trim(););
                        myMD.setDescription(tmpString[1]);
                    } else if (tmpString[0].trim().equals("difficulty")) {
                        // System.out.println(tmpString[0].trim(););
                        myMD.setDifficulty(tmpString[1]);
                    } else if (tmpString[0].trim().equals("learningtime")) {
                        // System.out.println(tmpString[0].trim(););
                        myMD.setLearningtime(tmpString[1]);
                    } else if (tmpString[0].trim().equals("kind")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setKind(tmpString[1]);                
                    } else if (tmpString[0].trim().equals("catalog")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setCatalog(tmpString[1]);
                    } else if (tmpString[0].trim().equals("entry")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setEntry(tmpString[1]);
                    } else if (tmpString[0].trim().equals("requires")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setEntry(tmpString[1]);
                    } else if (tmpString[0].trim().equals("creator")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setCreator(tmpString[1]);
                    } else if (tmpString[0].trim().equals("created")){
                        // System.out.println(tmpString[0].trim(););
                        myMD.setCreated(tmpString[1]);
                    }
                    metaCount++;
                }
            }
        } catch(Exception e) {
            e.printStackTrace();
        }
        return true;

    }

    void setParentMetaData(MetaData m) {
        parentMD = m;
        myMD.setParent(parentMD);
    }

    boolean isValid() {
        if (errMessage == null)
            return true;
        else
            return false;
    }

    String getErrMessage() {
        return errMessage;
    }

    /*
    Node[] xpath(String xpath,Document d) {
        XPathEvaluator evaluator=new XPathEvaluatorImpl(d);
        XPathNSResolver xpathNSResolver=evaluator.createNSResolver(d);
        XPathResult nodeSet=(XPathResult)evaluator.evaluate(xpath,d,xpathNSResolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
        ArrayList<Node> al = new ArrayList<Node>();
        Node n = nodeSet.iterateNext();
        while (n!=null) {
            al.add(n);
            n = nodeSet.iterateNext(); 
        }
        return al.toArray(new Node[0]);
    }*/

    Node[] xpath(String query, Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(new MyNamespaceContext());
            XPathExpression expr = xpath.compile(query);
            NodeList nl = (NodeList) expr.evaluate(doc, XPathConstants.NODESET);
            Node ret[] = new Node[nl.getLength()];
            for (int i = 0; i < nl.getLength(); i++) {
                ret[i] = nl.item(i);
            }
            return ret;
        } catch (XPathExpressionException e) {
            return null;
        }
    }

    void convert() {
        Node n[] = xpath("/:html/:body/:ul[@class='sentakuInfo']", doc);
        for (int i = 0; i < n.length; i++)
            convertSentaku((Element) n[i]);
    }

    void convertSentaku(Element e) {
        Node p = e.getParentNode();
        Element ee = doc.createElement("gaha");
        p.replaceChild(ee, e);
    }

    boolean writeSCORM(File f) {
        try {
            // convert();

            Y.convert(doc, this);
            DOMImplementationLS di = getDomImpl();
            LSOutput out = di.createLSOutput();
            FileOutputStream fos = new FileOutputStream(f);
            out.setByteStream(fos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(doc, out);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean writeMetaData(File f) {
        try {
            URL url = getClass()
                    .getResource(
                            "/jp/ac/do_johodai/j314/xhtml2scorm/resources/default_lom.xml");
            InputStream is = url.openStream();
            DOMImplementationLS di = getDomImpl();
            LSInput in = di.createLSInput();
            in.setByteStream(is);
            LSParser parser = di.createLSParser(
                    DOMImplementationLS.MODE_SYNCHRONOUS, null);
            DOMConfiguration c = parser.getDomConfig();
            // c.setParameter("validate", true);
            c.setParameter("resource-resolver", new MyLSResourceResolver());
            Document d = parser.parse(in);
            is.close();

            d = Y.makeMetaDoc(d, myMD);
            FileOutputStream fos = new FileOutputStream(f);
            LSOutput out = di.createLSOutput();
            out.setByteStream(fos);
            out.setEncoding("UTF-8");
            LSSerializer serializer = di.createLSSerializer();
            serializer.write(d, out);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isNeededAnsData() {
        return ansData.isNeededAnsData();
    }

    boolean writeAnsData(File f) {
        return ansData.writeAnsData(f);
    }
}
