package jp.ac.do_johodai.j314.xhtml2scorm;

import java.util.*;
import java.io.*;

import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.util.FileManager;

/**
 * 教材メタデータを保存するためのクラス。 このメタデータは階層構造を取ることが可能で、 あるメタデータに必要なデータが無い場合は親のメタデータに
 * 自動的に問合せして必要なデータを得ることができるように している。
 */
class MetaData {
    File file = null;
    String fileName = null;
    Model model = null;
    MetaData parent = null;
    ArrayList<MetaData> children = new ArrayList<MetaData>();
    MD1General general = null;
    MD2LifeCycle lifeCycle = null;
    MD3MetaMetadata metaMetadata = null;
    MD4Technical technical = null;
    MD5Educational educational = null;
    MD6Rights rights = null;
    MD7Relation relation = null;
    ArrayList<MD8Annotation> annotation = null;
    ArrayList<MD9Classification> classification = null;

    MetaData(File f) {
        file = f;
        fileName = f.getName();
        if (f.exists())
            readFile(f);
        if (model != null)
            make();
    }

    MetaData(String s, String base) {
        readString(s, base);
        fileName = base.substring(base.lastIndexOf('/') + 1);
        if (fileName.endsWith(".xhtml")) {
            fileName = fileName.substring(0, fileName.length() - 6)
                    + ".S.xhtml";
        } else if (fileName.endsWith(".html")) {
            fileName = fileName.substring(0, fileName.length() - 5)
                    + ".S.xhtml";
        } else {
            System.out.println("???gaha???");
        }
        if (model != null)
            make();
    }

    MetaData(String base) {
        fileName = base.substring(base.lastIndexOf('/') + 1);
        if (fileName.endsWith(".xhtml")) {
            fileName = fileName.substring(0, fileName.length() - 6)
                    + ".S.xhtml";
        } else if (fileName.endsWith(".html")) {
            fileName = fileName.substring(0, fileName.length() - 5)
                    + ".S.xhtml";
        } else {
            System.out.println("???gaha???");
        }
        makeEmpty();
    }

    void readFile(File f) {
        try {
            String url = f.toURI().toURL().toExternalForm();
            model = FileManager.get().loadModel(url);
        } catch (Exception e) {
            e.printStackTrace();
            model = null;
        }
    }

    void readString(String s, String base) {
        try {
            model = ModelFactory.createDefaultModel();
            ByteArrayInputStream bais = new ByteArrayInputStream(s
                    .getBytes("UTF-8"));
            model.read(bais, base);
        } catch (Exception e) {
            e.printStackTrace();
            model = null;
        }
    }

    void makeEmpty() {
        general = new MD1General();
        lifeCycle = new MD2LifeCycle();
        metaMetadata = new MD3MetaMetadata();
        technical = new MD4Technical();
        educational = new MD5Educational();
        rights = new MD6Rights();
        relation = new MD7Relation();
        annotation = new ArrayList<MD8Annotation>();
        classification = new ArrayList<MD9Classification>();
    }

    void make() {
        makeEmpty();

        String pre = "http://x314.do-johodai.ac.jp/scormmeta/";
        Property p = model.getProperty(pre + "title");
        NodeIterator ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            general.title = ni.next().toString();
        }
        p = model.getProperty(pre + "description");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            general.description = ni.next().toString();
        }
        p = model.getProperty(pre + "keywords");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            general.keywords = ni.next().toString();
        }
        p = model.getProperty(pre + "author");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            lifeCycle.contribute = ni.next().toString();
        }
        p = model.getProperty(pre + "difficulty");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            educational.difficulty = ni.next().toString();
        }
        p = model.getProperty(pre + "learningtime");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            educational.typicallearningtime = ni.next().toString();
        }
        p = model.getProperty(pre + "rights");
        ni = model.listObjectsOfProperty(p);
        if (ni.hasNext()) {
            rights.description = ni.next().toString();
        }

    }

    void setParent(MetaData m) {
        parent = m;
        if (!m.children.contains(this))
            m.children.add(this);
    }

    boolean hasChild() {
        if (children.size() == 0)
            return false;
        else
            return true;
    }

    String getFileName() {
        return fileName;
    }

    ArrayList<MetaData> getChildren() {
        return new ArrayList<MetaData>(children);
    }

    MetaData makeParentMetaData() {
        if (parent != null)
            return parent;
        File pFile = file.getParentFile().getParentFile();
        if (pFile == null)
            return null;
        pFile = new File(pFile, "mutial_metadata.n3");
        MetaData pm = new MetaData(pFile);
        setParent(pm);
        return pm;
    }

    String getTitle() {
        if (general.title != null)
            return general.title;
        return null;
    }

    void setTitle(String titleName) {
        general.title = titleName.trim();
        // System.out.println(general.title);
    }

    String getDescription() {
        if (general.description != null)
            return general.description;
        return null;
    }

    void setDescription(String Description) {
        general.description = Description.trim();
        // System.out.println(general.description);
    }

    String getKeywords() {
        if (general.keywords != null)
            return general.keywords;
        return null;
    }

    void setKeywords(String keywords) {
        general.keywords = keywords.trim();
        // System.out.println(general.keywords);
    }

    String getAuthor() {
        if (lifeCycle.contribute != null)
            return lifeCycle.contribute;
        if (parent != null)
            return parent.getAuthor();
        return null;
    }

    String getDifficulty() {
        if (educational.difficulty != null)
            return educational.difficulty;
        return null;
    }

    void setDifficulty(String difficulty) {
        educational.difficulty = difficulty.trim();
        // System.out.println(educational.difficulty);
    }

    String getLearningtime() {
        if (educational.typicallearningtime != null)
            return educational.typicallearningtime;
        return null;
    }

    void setLearningtime(String learningtime) {
        String[] tmp = new String[3];
        tmp = learningtime.split(":");
        tmp[0] = "PT" + tmp[0] + "H";
        tmp[1] = tmp[1] + "M";
        tmp[2] = tmp[2].trim() + "S";
        learningtime = tmp[0] + tmp[1] + tmp[2];
        educational.typicallearningtime = learningtime;
        // System.out.println(educational.typicallearningtime);
    }

    String getKind() {
        if (relation.kind != null)
            return relation.kind;
        return null;
    }

    void setKind(String kind) {
        relation.kind = kind.trim();
        // System.out.println(relation.kind);
    }

    String getEntry() {
        if (relation.entry != null)
            return relation.entry;
        return null;
    }

    void setEntry(String entry) {
        relation.entry = entry.trim();
        // System.out.println(relation.entry);
    }

    String getCatalog() {
        if (relation.catalog != null)
            return relation.catalog;
        return null;
    }

    void setCatalog(String catalog) {
        relation.catalog = catalog.trim();
        // System.out.println(relation.catalog);
    }

    String getRights() {
        if (rights.description != null)
            return rights.description;
        if (parent != null)
            return parent.getRights();
        return null;
    }

    String getCreator() {
        if (lifeCycle.Author != null)
            return lifeCycle.Author;
        return null;
    }

    void setCreator(String creator) {
        lifeCycle.Author = creator.trim();
        // System.out.println(relation.catalog);
    }

    String getCreated() {
        if (lifeCycle.date != null)
            return lifeCycle.date;
        return null;
    }

    void setCreated(String created) {
        lifeCycle.date = created.trim();
        // System.out.println(relation.catalog);
    }
}
