package jp.ac.do_johodai.j314.xhtml2scorm;

import java.io.*;
import java.util.*;

import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.*;

//これを作らないと、DOCTYPE宣言のsystemIdの値のところに
//DTDを読みにいってしまう。
//ちゃんとスキーマを読むようにもできるのですが，
//いろいろ面倒なことになってしまいそうなので，
//空のスキーマを返してます．
//
//ただ，以前つくった部分は残しておきます．
//getElementByIdを使うにはスキーマが必要．
//SCORMとかLOMとかのスキーマも入れてある。
//でもSCORMのほうは検証が上手く通らない。
//それとRDFも普通に入れたのでは検証が通らないらしい。
//XHTMLのDTDを変更すれば通るらしいのだが、とりあえずやめとく。
//http://jx-study.net/D3pF/D3p005.html
//http://jx-study.net/D3pF/D3p015.html
//http://infomesh.net/2002/rdfinhtml/
public class MyLSResourceResolver implements LSResourceResolver {
    static final String schemaRepository = "/jp/ac/do_johodai/j314/xhtml2scorm/schemas/";
    static HashMap<String, String> catalog = null;

    MyLSResourceResolver() {
        if (catalog == null)
            makeCatalog();
    }

    void makeCatalog() {
        try {
            catalog = new HashMap<String, String>();
            InputStream is = getClass().getResourceAsStream(
                    schemaRepository + "catalog.txt");
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (line.equals(""))
                    continue;
                if (line.startsWith("#"))
                    continue;
                int i = line.indexOf(" @@@ ");
                String key = line.substring(0, i);
                String value = line.substring(i + 5);
                // System.out.println("key :'"+key+"'");
                // System.out.println("value:'"+value+"'");
                // System.out.println();
                catalog.put(key, value);
            }
        } catch (Exception e) {
            e.printStackTrace();
            catalog = null;
        }
    }

    public LSInput resolveResource(String type, String namespaceURI,
            String publicId, String systemId, String baseURI) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream("".getBytes());
            DOMImplementationRegistry dir = DOMImplementationRegistry
                    .newInstance();
            DOMImplementationLS di = (DOMImplementationLS) dir
                    .getDOMImplementation("LS 3.0");
            LSInput in = di.createLSInput();
            in.setByteStream(bais);
            return in;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public LSInput resolveResource_BAK(String type, String namespaceURI,
            String publicId, String systemId, String baseURI) {
        String id = null;
        // たぶんpublicIdとnamespaceURIがバッティングすることはないと思うので…
        if (type.equals("http://www.w3.org/TR/REC-xml"))
            id = publicId;
        else if (type.equals("http://www.w3.org/2001/XMLSchema"))
            id = namespaceURI;
        else {
            System.out.println("*** NO SCHEMA ***");
            printInfo(type, namespaceURI, publicId, systemId, baseURI);
            return null;
        }
        String filename = catalog.get(id);
        if (filename == null) {
            System.out.println("*** NO SCHEMA ***");
            printInfo(type, namespaceURI, publicId, systemId, baseURI);
            return null;
        }
        return makeLSInput(schemaRepository + filename);
    }

    LSInput makeLSInput(String schema) {
        try {
            InputStream is = getClass().getResourceAsStream(schema);
            DOMImplementationRegistry dir = DOMImplementationRegistry
                    .newInstance();
            DOMImplementationLS di = (DOMImplementationLS) dir
                    .getDOMImplementation("LS 3.0");
            LSInput in = di.createLSInput();
            in.setByteStream(is);
            return in;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void printInfo(String type, String namespaceURI, String publicId,
            String systemId, String baseURI) {
        System.out.println("-----");
        System.out.println("type        :" + type);
        System.out.println("namespaceURI:" + namespaceURI);
        System.out.println("publicId    :" + publicId);
        System.out.println("systemId    :" + systemId);
        System.out.println("baseURI     :" + baseURI);
        System.out.println("-----");
    }
}
